/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.x9;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.ValidationParams;
import java.math.BigInteger;
import java.util.Enumeration;

public class DomainParameters
extends ASN1Object {
    private final ASN1Integer a;
    private final ASN1Integer b;
    private final ASN1Integer c;
    private final ASN1Integer d;
    private final ValidationParams e;

    public static DomainParameters getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return DomainParameters.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static DomainParameters getInstance(Object object) {
        if (object instanceof DomainParameters) {
            return (DomainParameters)object;
        }
        if (object != null) {
            return new DomainParameters(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DomainParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, ValidationParams validationParams) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("'p' cannot be null");
        }
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("'g' cannot be null");
        }
        if (bigInteger3 == null) {
            throw new IllegalArgumentException("'q' cannot be null");
        }
        this.a = new ASN1Integer(bigInteger);
        this.b = new ASN1Integer(bigInteger2);
        this.c = new ASN1Integer(bigInteger3);
        this.d = bigInteger4 != null ? new ASN1Integer(bigInteger4) : null;
        this.e = validationParams;
    }

    private DomainParameters(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 3 || aSN1Sequence.size() > 5) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = ASN1Integer.getInstance(enumeration.nextElement());
        this.b = ASN1Integer.getInstance(enumeration.nextElement());
        this.c = ASN1Integer.getInstance(enumeration.nextElement());
        ASN1Encodable aSN1Encodable = DomainParameters.a(enumeration);
        if (aSN1Encodable != null && aSN1Encodable instanceof ASN1Integer) {
            this.d = ASN1Integer.getInstance(aSN1Encodable);
            aSN1Encodable = DomainParameters.a(enumeration);
        } else {
            this.d = null;
        }
        this.e = aSN1Encodable != null ? ValidationParams.getInstance(aSN1Encodable.toASN1Primitive()) : null;
    }

    private static ASN1Encodable a(Enumeration enumeration) {
        return enumeration.hasMoreElements() ? (ASN1Encodable)enumeration.nextElement() : null;
    }

    public BigInteger getP() {
        return this.a.getPositiveValue();
    }

    public BigInteger getG() {
        return this.b.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.c.getPositiveValue();
    }

    public BigInteger getJ() {
        if (this.d == null) {
            return null;
        }
        return this.d.getPositiveValue();
    }

    public ValidationParams getValidationParams() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

