/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Certificate;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Time;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import com.aspose.imaging.internal.bouncycastle.cert.CertIOException;
import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.cert.a;
import com.aspose.imaging.internal.bouncycastle.operator.ContentSigner;
import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;

public class X509v3CertificateBuilder {
    private V3TBSCertificateGenerator a = new V3TBSCertificateGenerator();
    private ExtensionsGenerator b;

    public X509v3CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Date date, Date date2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(x500Name, bigInteger, new Time(date), new Time(date2), x500Name2, subjectPublicKeyInfo);
    }

    public X509v3CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Date date, Date date2, Locale locale, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(x500Name, bigInteger, new Time(date, locale), new Time(date2, locale), x500Name2, subjectPublicKeyInfo);
    }

    public X509v3CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Time time, Time time2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.a.setSerialNumber(new ASN1Integer(bigInteger));
        this.a.setIssuer(x500Name);
        this.a.setStartDate(time);
        this.a.setEndDate(time2);
        this.a.setSubject(x500Name2);
        this.a.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        this.b = new ExtensionsGenerator();
    }

    public X509v3CertificateBuilder setSubjectUniqueID(boolean[] blArray) {
        this.a.setSubjectUniqueID(com.aspose.imaging.internal.bouncycastle.cert.a.a(blArray));
        return this;
    }

    public X509v3CertificateBuilder setIssuerUniqueID(boolean[] blArray) {
        this.a.setIssuerUniqueID(com.aspose.imaging.internal.bouncycastle.cert.a.a(blArray));
        return this;
    }

    public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) throws CertIOException {
        com.aspose.imaging.internal.bouncycastle.cert.a.a(this.b, aSN1ObjectIdentifier, bl2, aSN1Encodable);
        return this;
    }

    public X509v3CertificateBuilder addExtension(Extension extension) throws CertIOException {
        this.b.addExtension(extension);
        return this;
    }

    public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, byte[] byArray) throws CertIOException {
        this.b.addExtension(aSN1ObjectIdentifier, bl2, byArray);
        return this;
    }

    public X509v3CertificateBuilder copyAndAddExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, X509CertificateHolder x509CertificateHolder) {
        Certificate certificate = x509CertificateHolder.toASN1Structure();
        Extension extension = certificate.getTBSCertificate().getExtensions().getExtension(aSN1ObjectIdentifier);
        if (extension == null) {
            throw new NullPointerException("extension " + aSN1ObjectIdentifier + " not present");
        }
        this.b.addExtension(aSN1ObjectIdentifier, bl2, extension.getExtnValue().getOctets());
        return this;
    }

    public X509CertificateHolder build(ContentSigner contentSigner) {
        this.a.setSignature(contentSigner.getAlgorithmIdentifier());
        if (!this.b.isEmpty()) {
            this.a.setExtensions(this.b.generate());
        }
        return com.aspose.imaging.internal.bouncycastle.cert.a.a(contentSigner, this.a.generateTBSCertificate());
    }
}

