/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert.crmf;

import com.aspose.imaging.internal.bouncycastle.asn1.cms.EnvelopedData;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.EncKeyWithID;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.EncryptedKey;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.PKIArchiveOptions;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.imaging.internal.bouncycastle.cert.crmf.PKIArchiveControl;
import com.aspose.imaging.internal.bouncycastle.cms.CMSEnvelopedData;
import com.aspose.imaging.internal.bouncycastle.cms.CMSEnvelopedDataGenerator;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.CMSProcessableByteArray;
import com.aspose.imaging.internal.bouncycastle.cms.RecipientInfoGenerator;
import com.aspose.imaging.internal.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator a;
    private CMSProcessableByteArray b;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.b = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.a = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.a.addRecipientInfoGenerator(recipientInfoGenerator);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor outputEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.a.generate(this.b, outputEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

