/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert.dane;

import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.IOException;

public class DANEEntry {
    public static final int CERT_USAGE_CA = 0;
    public static final int CERT_USAGE_PKIX_VALIDATE = 1;
    public static final int CERT_USAGE_TRUST_ANCHOR = 2;
    public static final int CERT_USAGE_ACCEPT = 3;
    static final int CERT_USAGE = 0;
    static final int SELECTOR = 1;
    static final int MATCHING_TYPE = 2;
    private final String a;
    private final byte[] b;
    private final X509CertificateHolder c;

    DANEEntry(String string, byte[] byArray, X509CertificateHolder x509CertificateHolder) {
        this.b = byArray;
        this.a = string;
        this.c = x509CertificateHolder;
    }

    public DANEEntry(String string, byte[] byArray) throws IOException {
        this(string, Arrays.copyOfRange(byArray, 0, 3), new X509CertificateHolder(Arrays.copyOfRange(byArray, 3, byArray.length)));
    }

    public byte[] getFlags() {
        return Arrays.clone(this.b);
    }

    public X509CertificateHolder getCertificate() {
        return this.c;
    }

    public String getDomainName() {
        return this.a;
    }

    public byte[] getRDATA() throws IOException {
        byte[] byArray = this.c.getEncoded();
        byte[] byArray2 = new byte[this.b.length + byArray.length];
        System.arraycopy(this.b, 0, byArray2, 0, this.b.length);
        System.arraycopy(byArray, 0, byArray2, this.b.length, byArray.length);
        return byArray2;
    }

    public static boolean isValidCertificate(byte[] byArray) {
        return (byArray[0] >= 0 || byArray[0] <= 3) && byArray[1] == 0 && byArray[2] == 0;
    }
}

