/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cert.dane;

import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.cert.dane.DANEEntry;
import com.aspose.imaging.internal.bouncycastle.cert.dane.DANEEntrySelector;
import com.aspose.imaging.internal.bouncycastle.cert.dane.DANEEntrySelectorFactory;
import com.aspose.imaging.internal.bouncycastle.cert.dane.DANEException;
import com.aspose.imaging.internal.bouncycastle.operator.DigestCalculator;

public class DANEEntryFactory {
    private final DANEEntrySelectorFactory a;

    public DANEEntryFactory(DigestCalculator digestCalculator) {
        this.a = new DANEEntrySelectorFactory(digestCalculator);
    }

    public DANEEntry createEntry(String string, X509CertificateHolder x509CertificateHolder) throws DANEException {
        return this.createEntry(string, 3, x509CertificateHolder);
    }

    public DANEEntry createEntry(String string, int n2, X509CertificateHolder x509CertificateHolder) throws DANEException {
        if (n2 < 0 || n2 > 3) {
            throw new DANEException("unknown certificate usage: " + n2);
        }
        DANEEntrySelector dANEEntrySelector = this.a.createSelector(string);
        byte[] byArray = new byte[]{(byte)n2, 0, 0};
        return new DANEEntry(dANEEntrySelector.getDomainName(), byArray, x509CertificateHolder);
    }
}

