/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.OriginatorInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Certificate;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.CertificateList;
import com.aspose.imaging.internal.bouncycastle.cert.X509CRLHolder;
import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.util.CollectionStore;
import com.aspose.imaging.internal.bouncycastle.util.Store;
import java.util.ArrayList;
import java.util.Enumeration;

public class OriginatorInformation {
    private OriginatorInfo a;

    OriginatorInformation(OriginatorInfo originatorInfo) {
        this.a = originatorInfo;
    }

    public Store getCertificates() {
        ASN1Set aSN1Set = this.a.getCertificates();
        if (aSN1Set != null) {
            ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(aSN1Set.size());
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive();
                if (!(aSN1Primitive instanceof ASN1Sequence)) continue;
                arrayList.add(new X509CertificateHolder(Certificate.getInstance(aSN1Primitive)));
            }
            return new CollectionStore(arrayList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getCRLs() {
        ASN1Set aSN1Set = this.a.getCRLs();
        if (aSN1Set != null) {
            ArrayList<X509CRLHolder> arrayList = new ArrayList<X509CRLHolder>(aSN1Set.size());
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive();
                if (!(aSN1Primitive instanceof ASN1Sequence)) continue;
                arrayList.add(new X509CRLHolder(CertificateList.getInstance(aSN1Primitive)));
            }
            return new CollectionStore(arrayList);
        }
        return new CollectionStore(new ArrayList());
    }

    public OriginatorInfo toASN1Structure() {
        return this.a;
    }
}

