/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.CMSTypedStream;
import com.aspose.imaging.internal.bouncycastle.cms.Recipient;
import com.aspose.imaging.internal.bouncycastle.cms.RecipientId;
import com.aspose.imaging.internal.bouncycastle.cms.RecipientOperator;
import com.aspose.imaging.internal.bouncycastle.cms.a;
import com.aspose.imaging.internal.bouncycastle.cms.h;
import com.aspose.imaging.internal.bouncycastle.cms.l;
import com.aspose.imaging.internal.bouncycastle.cms.o;
import com.aspose.imaging.internal.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public abstract class RecipientInformation {
    protected RecipientId rid;
    protected AlgorithmIdentifier keyEncAlg;
    protected AlgorithmIdentifier messageAlgorithm;
    protected l secureReadable;
    private a a;
    private byte[] b;
    private RecipientOperator c;

    RecipientInformation(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, l l2, a a2) {
        this.keyEncAlg = algorithmIdentifier;
        this.messageAlgorithm = algorithmIdentifier2;
        this.secureReadable = l2;
        this.a = a2;
    }

    public RecipientId getRID() {
        return this.rid;
    }

    private byte[] a(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable != null) {
            return aSN1Encodable.toASN1Primitive().getEncoded();
        }
        return null;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncAlg;
    }

    public String getKeyEncryptionAlgOID() {
        return this.keyEncAlg.getAlgorithm().getId();
    }

    public byte[] getKeyEncryptionAlgParams() {
        try {
            return this.a(this.keyEncAlg.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public byte[] getContentDigest() {
        if (this.secureReadable instanceof h.b) {
            return ((h.b)this.secureReadable).b();
        }
        return null;
    }

    public byte[] getMac() {
        if (this.b == null && this.c.isMacBased()) {
            if (this.a != null) {
                try {
                    Streams.drain(this.c.getInputStream(new ByteArrayInputStream(this.a.a().getEncoded("DER"))));
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("unable to drain input: " + iOException.getMessage());
                }
            }
            this.b = this.c.getMac();
        }
        return this.b;
    }

    public byte[] getContent(Recipient recipient) throws CMSException {
        try {
            return o.b(this.getContentStream(recipient).getContentStream());
        }
        catch (IOException iOException) {
            throw new CMSException("unable to parse internal stream: " + iOException.getMessage(), iOException);
        }
    }

    public CMSTypedStream getContentStream(Recipient recipient) throws CMSException, IOException {
        this.c = this.getRecipientOperator(recipient);
        if (this.a != null) {
            return new CMSTypedStream(this.secureReadable.a());
        }
        return new CMSTypedStream(this.c.getInputStream(this.secureReadable.a()));
    }

    protected abstract RecipientOperator getRecipientOperator(Recipient var1) throws CMSException, IOException;
}

