/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms.bc;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.PasswordRecipientInfoGenerator;
import com.aspose.imaging.internal.bouncycastle.cms.bc.d;
import com.aspose.imaging.internal.bouncycastle.cms.bc.e;
import com.aspose.imaging.internal.bouncycastle.crypto.PBEParametersGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.Wrapper;
import com.aspose.imaging.internal.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.imaging.internal.bouncycastle.operator.GenericKey;

public class BcPasswordRecipientInfoGenerator
extends PasswordRecipientInfoGenerator {
    public BcPasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray) {
        super(aSN1ObjectIdentifier, cArray);
    }

    @Override
    protected byte[] calculateDerivedKey(int n2, AlgorithmIdentifier algorithmIdentifier, int n3) throws CMSException {
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(algorithmIdentifier.getParameters());
        byte[] byArray = n2 == 0 ? PBEParametersGenerator.PKCS5PasswordToBytes(this.password) : PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(this.password);
        try {
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(e.a(pBKDF2Params.getPrf()));
            pKCS5S2ParametersGenerator.init(byArray, pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue());
            return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n3)).getKey();
        }
        catch (Exception exception) {
            throw new CMSException("exception creating derived key: " + exception.getMessage(), exception);
        }
    }

    @Override
    public byte[] generateEncryptedBytes(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, GenericKey genericKey) throws CMSException {
        byte[] byArray2 = ((KeyParameter)d.a(genericKey)).getKey();
        Wrapper wrapper = e.c(algorithmIdentifier.getAlgorithm());
        wrapper.init(true, new ParametersWithIV(new KeyParameter(byArray), ASN1OctetString.getInstance(algorithmIdentifier.getParameters()).getOctets()));
        return wrapper.wrap(byArray2, 0, byArray2.length);
    }
}

