/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.cms.jcajce;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.KeyTransRecipient;
import com.aspose.imaging.internal.bouncycastle.cms.KeyTransRecipientId;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.a;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.b;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.w;
import com.aspose.imaging.internal.bouncycastle.cms.jcajce.x;
import com.aspose.imaging.internal.bouncycastle.operator.OperatorException;
import com.aspose.imaging.internal.bouncycastle.operator.jcajce.JceKTSKeyUnwrapper;
import com.aspose.imaging.internal.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;

public abstract class JceKTSKeyTransRecipient
implements KeyTransRecipient {
    private static final byte[] a = Hex.decode("0c14416e6f6e796d6f75732053656e64657220202020");
    private final byte[] b;
    private PrivateKey c;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;
    protected Map extraMappings;
    protected boolean validateKeySize;
    protected boolean unwrappedKeyMustBeEncodable;

    public JceKTSKeyTransRecipient(PrivateKey privateKey, byte[] byArray) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new b());
        this.extraMappings = new HashMap();
        this.validateKeySize = false;
        this.c = privateKey;
        this.b = byArray;
    }

    public JceKTSKeyTransRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new x(provider));
        return this;
    }

    public JceKTSKeyTransRecipient setProvider(String string) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new w(string));
        return this;
    }

    public JceKTSKeyTransRecipient setAlgorithmMapping(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        this.extraMappings.put(aSN1ObjectIdentifier, string);
        return this;
    }

    public JceKTSKeyTransRecipient setContentProvider(Provider provider) {
        this.contentHelper = com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.a(provider);
        return this;
    }

    public JceKTSKeyTransRecipient setContentProvider(String string) {
        this.contentHelper = com.aspose.imaging.internal.bouncycastle.cms.jcajce.a.a(string);
        return this;
    }

    public JceKTSKeyTransRecipient setKeySizeValidation(boolean bl2) {
        this.validateKeySize = bl2;
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        JceKTSKeyUnwrapper jceKTSKeyUnwrapper = this.helper.createAsymmetricUnwrapper(algorithmIdentifier, this.c, a, this.b);
        try {
            Key key = this.helper.getJceKey(algorithmIdentifier2.getAlgorithm(), jceKTSKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
            if (this.validateKeySize) {
                this.helper.keySizeCheck(algorithmIdentifier2, key);
            }
            return key;
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }

    protected static byte[] getPartyVInfoFromRID(KeyTransRecipientId keyTransRecipientId) throws IOException {
        if (keyTransRecipientId.getSerialNumber() != null) {
            return new IssuerAndSerialNumber(keyTransRecipientId.getIssuer(), keyTransRecipientId.getSerialNumber()).getEncoded("DER");
        }
        return new DEROctetString(keyTransRecipientId.getSubjectKeyIdentifier()).getEncoded();
    }
}

