/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.digests;

import com.aspose.imaging.internal.bouncycastle.crypto.digests.LongDigest;
import com.aspose.imaging.internal.bouncycastle.util.Memoable;
import com.aspose.imaging.internal.bouncycastle.util.MemoableResetException;
import com.aspose.imaging.internal.bouncycastle.util.Pack;

public class SHA512tDigest
extends LongDigest {
    private int a;
    private long b;
    private long c;
    private long d;
    private long e;
    private long f;
    private long g;
    private long h;
    private long i;

    public SHA512tDigest(int n2) {
        if (n2 >= 512) {
            throw new IllegalArgumentException("bitLength cannot be >= 512");
        }
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("bitLength needs to be a multiple of 8");
        }
        if (n2 == 384) {
            throw new IllegalArgumentException("bitLength cannot be 384 use SHA384 instead");
        }
        this.a = n2 / 8;
        this.a(this.a * 8);
        this.reset();
    }

    public SHA512tDigest(SHA512tDigest sHA512tDigest) {
        super(sHA512tDigest);
        this.a = sHA512tDigest.a;
        this.reset(sHA512tDigest);
    }

    public SHA512tDigest(byte[] byArray) {
        this(SHA512tDigest.a(byArray));
        this.restoreState(byArray);
    }

    private static int a(byte[] byArray) {
        return Pack.bigEndianToInt(byArray, byArray.length - 4);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-512/" + Integer.toString(this.a * 8);
    }

    @Override
    public int getDigestSize() {
        return this.a;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        this.finish();
        SHA512tDigest.a(this.H1, byArray, n2, this.a);
        SHA512tDigest.a(this.H2, byArray, n2 + 8, this.a - 8);
        SHA512tDigest.a(this.H3, byArray, n2 + 16, this.a - 16);
        SHA512tDigest.a(this.H4, byArray, n2 + 24, this.a - 24);
        SHA512tDigest.a(this.H5, byArray, n2 + 32, this.a - 32);
        SHA512tDigest.a(this.H6, byArray, n2 + 40, this.a - 40);
        SHA512tDigest.a(this.H7, byArray, n2 + 48, this.a - 48);
        SHA512tDigest.a(this.H8, byArray, n2 + 56, this.a - 56);
        this.reset();
        return this.a;
    }

    @Override
    public void reset() {
        super.reset();
        this.H1 = this.b;
        this.H2 = this.c;
        this.H3 = this.d;
        this.H4 = this.e;
        this.H5 = this.f;
        this.H6 = this.g;
        this.H7 = this.h;
        this.H8 = this.i;
    }

    private void a(int n2) {
        this.H1 = -3482333909917012819L;
        this.H2 = 2216346199247487646L;
        this.H3 = -7364697282686394994L;
        this.H4 = 65953792586715988L;
        this.H5 = -816286391624063116L;
        this.H6 = 4512832404995164602L;
        this.H7 = -5033199132376557362L;
        this.H8 = -124578254951840548L;
        this.update((byte)83);
        this.update((byte)72);
        this.update((byte)65);
        this.update((byte)45);
        this.update((byte)53);
        this.update((byte)49);
        this.update((byte)50);
        this.update((byte)47);
        if (n2 > 100) {
            this.update((byte)(n2 / 100 + 48));
            this.update((byte)((n2 %= 100) / 10 + 48));
            this.update((byte)((n2 %= 10) + 48));
        } else if (n2 > 10) {
            this.update((byte)(n2 / 10 + 48));
            this.update((byte)((n2 %= 10) + 48));
        } else {
            this.update((byte)(n2 + 48));
        }
        this.finish();
        this.b = this.H1;
        this.c = this.H2;
        this.d = this.H3;
        this.e = this.H4;
        this.f = this.H5;
        this.g = this.H6;
        this.h = this.H7;
        this.i = this.H8;
    }

    private static void a(long l2, byte[] byArray, int n2, int n3) {
        if (n3 > 0) {
            SHA512tDigest.a((int)(l2 >>> 32), byArray, n2, n3);
            if (n3 > 4) {
                SHA512tDigest.a((int)(l2 & 0xFFFFFFFFL), byArray, n2 + 4, n3 - 4);
            }
        }
    }

    private static void a(int n2, byte[] byArray, int n3, int n4) {
        int n5 = Math.min(4, n4);
        while (--n5 >= 0) {
            int n6 = 8 * (3 - n5);
            byArray[n3 + n5] = (byte)(n2 >>> n6);
        }
    }

    @Override
    public Memoable copy() {
        return new SHA512tDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHA512tDigest sHA512tDigest = (SHA512tDigest)memoable;
        if (this.a != sHA512tDigest.a) {
            throw new MemoableResetException("digestLength inappropriate in other");
        }
        super.copyIn(sHA512tDigest);
        this.b = sHA512tDigest.b;
        this.c = sHA512tDigest.c;
        this.d = sHA512tDigest.d;
        this.e = sHA512tDigest.e;
        this.f = sHA512tDigest.f;
        this.g = sHA512tDigest.g;
        this.h = sHA512tDigest.h;
        this.i = sHA512tDigest.i;
    }

    @Override
    public byte[] getEncodedState() {
        int n2 = this.getEncodedStateSize();
        byte[] byArray = new byte[n2 + 4];
        this.populateState(byArray);
        Pack.intToBigEndian(this.a * 8, byArray, n2);
        return byArray;
    }
}

