/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.ec;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.sec.SECObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.A;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.B;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.C;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.D;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.E;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.F;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.a;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.b;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.c;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.d;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.e;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.f;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.g;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.h;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.i;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.j;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.k;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.l;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.m;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.n;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.o;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.p;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.q;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.r;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.s;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.t;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.u;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.v;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.w;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.x;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.y;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.z;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.math.ec.endo.GLVTypeBEndomorphism;
import com.aspose.imaging.internal.bouncycastle.math.ec.endo.GLVTypeBParameters;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CustomNamedCurves {
    static X9ECParametersHolder curve25519 = new a();
    static X9ECParametersHolder secp128r1 = new l();
    static X9ECParametersHolder secp160k1 = new w();
    static X9ECParametersHolder secp160r1 = new A();
    static X9ECParametersHolder secp160r2 = new B();
    static X9ECParametersHolder secp192k1 = new C();
    static X9ECParametersHolder secp192r1 = new D();
    static X9ECParametersHolder secp224k1 = new E();
    static X9ECParametersHolder secp224r1 = new F();
    static X9ECParametersHolder secp256k1 = new b();
    static X9ECParametersHolder secp256r1 = new c();
    static X9ECParametersHolder secp384r1 = new d();
    static X9ECParametersHolder secp521r1 = new e();
    static X9ECParametersHolder sect113r1 = new f();
    static X9ECParametersHolder sect113r2 = new g();
    static X9ECParametersHolder sect131r1 = new h();
    static X9ECParametersHolder sect131r2 = new i();
    static X9ECParametersHolder sect163k1 = new j();
    static X9ECParametersHolder sect163r1 = new k();
    static X9ECParametersHolder sect163r2 = new m();
    static X9ECParametersHolder sect193r1 = new n();
    static X9ECParametersHolder sect193r2 = new o();
    static X9ECParametersHolder sect233k1 = new p();
    static X9ECParametersHolder sect233r1 = new q();
    static X9ECParametersHolder sect239k1 = new r();
    static X9ECParametersHolder sect283k1 = new s();
    static X9ECParametersHolder sect283r1 = new t();
    static X9ECParametersHolder sect409k1 = new u();
    static X9ECParametersHolder sect409r1 = new v();
    static X9ECParametersHolder sect571k1 = new x();
    static X9ECParametersHolder sect571r1 = new y();
    static X9ECParametersHolder sm2p256v1 = new z();
    static final Hashtable nameToCurve = new Hashtable();
    static final Hashtable nameToOID = new Hashtable();
    static final Hashtable oidToCurve = new Hashtable();
    static final Hashtable oidToName = new Hashtable();
    static final Vector names = new Vector();

    private static ECCurve a(ECCurve eCCurve) {
        return eCCurve;
    }

    private static ECCurve a(ECCurve eCCurve, GLVTypeBParameters gLVTypeBParameters) {
        return eCCurve.configure().setEndomorphism(new GLVTypeBEndomorphism(eCCurve, gLVTypeBParameters)).create();
    }

    static void defineCurve(String string, X9ECParametersHolder x9ECParametersHolder) {
        names.addElement(string);
        string = Strings.toLowerCase(string);
        nameToCurve.put(string, x9ECParametersHolder);
    }

    static void defineCurveWithOID(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, X9ECParametersHolder x9ECParametersHolder) {
        names.addElement(string);
        oidToName.put(aSN1ObjectIdentifier, string);
        oidToCurve.put(aSN1ObjectIdentifier, x9ECParametersHolder);
        string = Strings.toLowerCase(string);
        nameToOID.put(string, aSN1ObjectIdentifier);
        nameToCurve.put(string, x9ECParametersHolder);
    }

    static void defineCurveAlias(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Object v2 = oidToCurve.get(aSN1ObjectIdentifier);
        if (v2 == null) {
            throw new IllegalStateException();
        }
        string = Strings.toLowerCase(string);
        nameToOID.put(string, aSN1ObjectIdentifier);
        nameToCurve.put(string, v2);
    }

    public static X9ECParameters getByName(String string) {
        X9ECParametersHolder x9ECParametersHolder = (X9ECParametersHolder)nameToCurve.get(Strings.toLowerCase(string));
        return x9ECParametersHolder == null ? null : x9ECParametersHolder.getParameters();
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParametersHolder x9ECParametersHolder = (X9ECParametersHolder)oidToCurve.get(aSN1ObjectIdentifier);
        return x9ECParametersHolder == null ? null : x9ECParametersHolder.getParameters();
    }

    public static ASN1ObjectIdentifier getOID(String string) {
        return (ASN1ObjectIdentifier)nameToOID.get(Strings.toLowerCase(string));
    }

    public static String getName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (String)oidToName.get(aSN1ObjectIdentifier);
    }

    public static Enumeration getNames() {
        return names.elements();
    }

    static /* synthetic */ ECCurve access$000(ECCurve eCCurve) {
        return CustomNamedCurves.a(eCCurve);
    }

    static /* synthetic */ ECCurve access$100(ECCurve eCCurve, GLVTypeBParameters gLVTypeBParameters) {
        return CustomNamedCurves.a(eCCurve, gLVTypeBParameters);
    }

    static {
        CustomNamedCurves.defineCurve("curve25519", curve25519);
        CustomNamedCurves.defineCurveWithOID("secp128r1", SECObjectIdentifiers.secp128r1, secp128r1);
        CustomNamedCurves.defineCurveWithOID("secp160k1", SECObjectIdentifiers.secp160k1, secp160k1);
        CustomNamedCurves.defineCurveWithOID("secp160r1", SECObjectIdentifiers.secp160r1, secp160r1);
        CustomNamedCurves.defineCurveWithOID("secp160r2", SECObjectIdentifiers.secp160r2, secp160r2);
        CustomNamedCurves.defineCurveWithOID("secp192k1", SECObjectIdentifiers.secp192k1, secp192k1);
        CustomNamedCurves.defineCurveWithOID("secp192r1", SECObjectIdentifiers.secp192r1, secp192r1);
        CustomNamedCurves.defineCurveWithOID("secp224k1", SECObjectIdentifiers.secp224k1, secp224k1);
        CustomNamedCurves.defineCurveWithOID("secp224r1", SECObjectIdentifiers.secp224r1, secp224r1);
        CustomNamedCurves.defineCurveWithOID("secp256k1", SECObjectIdentifiers.secp256k1, secp256k1);
        CustomNamedCurves.defineCurveWithOID("secp256r1", SECObjectIdentifiers.secp256r1, secp256r1);
        CustomNamedCurves.defineCurveWithOID("secp384r1", SECObjectIdentifiers.secp384r1, secp384r1);
        CustomNamedCurves.defineCurveWithOID("secp521r1", SECObjectIdentifiers.secp521r1, secp521r1);
        CustomNamedCurves.defineCurveWithOID("sect113r1", SECObjectIdentifiers.sect113r1, sect113r1);
        CustomNamedCurves.defineCurveWithOID("sect113r2", SECObjectIdentifiers.sect113r2, sect113r2);
        CustomNamedCurves.defineCurveWithOID("sect131r1", SECObjectIdentifiers.sect131r1, sect131r1);
        CustomNamedCurves.defineCurveWithOID("sect131r2", SECObjectIdentifiers.sect131r2, sect131r2);
        CustomNamedCurves.defineCurveWithOID("sect163k1", SECObjectIdentifiers.sect163k1, sect163k1);
        CustomNamedCurves.defineCurveWithOID("sect163r1", SECObjectIdentifiers.sect163r1, sect163r1);
        CustomNamedCurves.defineCurveWithOID("sect163r2", SECObjectIdentifiers.sect163r2, sect163r2);
        CustomNamedCurves.defineCurveWithOID("sect193r1", SECObjectIdentifiers.sect193r1, sect193r1);
        CustomNamedCurves.defineCurveWithOID("sect193r2", SECObjectIdentifiers.sect193r2, sect193r2);
        CustomNamedCurves.defineCurveWithOID("sect233k1", SECObjectIdentifiers.sect233k1, sect233k1);
        CustomNamedCurves.defineCurveWithOID("sect233r1", SECObjectIdentifiers.sect233r1, sect233r1);
        CustomNamedCurves.defineCurveWithOID("sect239k1", SECObjectIdentifiers.sect239k1, sect239k1);
        CustomNamedCurves.defineCurveWithOID("sect283k1", SECObjectIdentifiers.sect283k1, sect283k1);
        CustomNamedCurves.defineCurveWithOID("sect283r1", SECObjectIdentifiers.sect283r1, sect283r1);
        CustomNamedCurves.defineCurveWithOID("sect409k1", SECObjectIdentifiers.sect409k1, sect409k1);
        CustomNamedCurves.defineCurveWithOID("sect409r1", SECObjectIdentifiers.sect409r1, sect409r1);
        CustomNamedCurves.defineCurveWithOID("sect571k1", SECObjectIdentifiers.sect571k1, sect571k1);
        CustomNamedCurves.defineCurveWithOID("sect571r1", SECObjectIdentifiers.sect571r1, sect571r1);
        CustomNamedCurves.defineCurveWithOID("sm2p256v1", GMObjectIdentifiers.sm2p256v1, sm2p256v1);
        CustomNamedCurves.defineCurveAlias("B-163", SECObjectIdentifiers.sect163r2);
        CustomNamedCurves.defineCurveAlias("B-233", SECObjectIdentifiers.sect233r1);
        CustomNamedCurves.defineCurveAlias("B-283", SECObjectIdentifiers.sect283r1);
        CustomNamedCurves.defineCurveAlias("B-409", SECObjectIdentifiers.sect409r1);
        CustomNamedCurves.defineCurveAlias("B-571", SECObjectIdentifiers.sect571r1);
        CustomNamedCurves.defineCurveAlias("K-163", SECObjectIdentifiers.sect163k1);
        CustomNamedCurves.defineCurveAlias("K-233", SECObjectIdentifiers.sect233k1);
        CustomNamedCurves.defineCurveAlias("K-283", SECObjectIdentifiers.sect283k1);
        CustomNamedCurves.defineCurveAlias("K-409", SECObjectIdentifiers.sect409k1);
        CustomNamedCurves.defineCurveAlias("K-571", SECObjectIdentifiers.sect571k1);
        CustomNamedCurves.defineCurveAlias("P-192", SECObjectIdentifiers.secp192r1);
        CustomNamedCurves.defineCurveAlias("P-224", SECObjectIdentifiers.secp224r1);
        CustomNamedCurves.defineCurveAlias("P-256", SECObjectIdentifiers.secp256r1);
        CustomNamedCurves.defineCurveAlias("P-384", SECObjectIdentifiers.secp384r1);
        CustomNamedCurves.defineCurveAlias("P-521", SECObjectIdentifiers.secp521r1);
    }
}

