/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.encodings;

import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.crypto.util.DigestFactory;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] a;
    private Digest b;
    private AsymmetricBlockCipher c;
    private SecureRandom d;
    private boolean e;

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this(asymmetricBlockCipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, byte[] byArray) {
        this(asymmetricBlockCipher, digest, digest, byArray);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray) {
        this.c = asymmetricBlockCipher;
        this.b = digest2;
        this.a = new byte[digest.getDigestSize()];
        digest.reset();
        if (byArray != null) {
            digest.update(byArray, 0, byArray.length);
        }
        digest.doFinal(this.a, 0);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.c;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.d = parametersWithRandom.getRandom();
        } else {
            this.d = new SecureRandom();
        }
        this.c.init(bl2, cipherParameters);
        this.e = bl2;
    }

    @Override
    public int getInputBlockSize() {
        int n2 = this.c.getInputBlockSize();
        if (this.e) {
            return n2 - 1 - 2 * this.a.length;
        }
        return n2;
    }

    @Override
    public int getOutputBlockSize() {
        int n2 = this.c.getOutputBlockSize();
        if (this.e) {
            return n2;
        }
        return n2 - 1 - 2 * this.a.length;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.e) {
            return this.encodeBlock(byArray, n2, n3);
        }
        return this.decodeBlock(byArray, n2, n3);
    }

    public byte[] encodeBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        if (n3 > this.getInputBlockSize()) {
            throw new DataLengthException("input data too long");
        }
        byte[] byArray2 = new byte[this.getInputBlockSize() + 1 + 2 * this.a.length];
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        byArray2[byArray2.length - n3 - 1] = 1;
        System.arraycopy(this.a, 0, byArray2, this.a.length, this.a.length);
        byte[] byArray3 = new byte[this.a.length];
        this.d.nextBytes(byArray3);
        byte[] byArray4 = this.a(byArray3, 0, byArray3.length, byArray2.length - this.a.length);
        for (n4 = this.a.length; n4 != byArray2.length; ++n4) {
            int n5 = n4;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray4[n4 - this.a.length]);
        }
        System.arraycopy(byArray3, 0, byArray2, 0, this.a.length);
        byArray4 = this.a(byArray2, this.a.length, byArray2.length - this.a.length, this.a.length);
        for (n4 = 0; n4 != this.a.length; ++n4) {
            int n6 = n4;
            byArray2[n6] = (byte)(byArray2[n6] ^ byArray4[n4]);
        }
        return this.c.processBlock(byArray2, 0, byArray2.length);
    }

    public byte[] decodeBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        int n5;
        int n6;
        byte[] byArray2 = this.c.processBlock(byArray, n2, n3);
        byte[] byArray3 = new byte[this.c.getOutputBlockSize()];
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        int n7 = byArray3.length < 2 * this.a.length + 1 ? 1 : 0;
        byte[] byArray4 = this.a(byArray3, this.a.length, byArray3.length - this.a.length, this.a.length);
        for (n6 = 0; n6 != this.a.length; ++n6) {
            int n8 = n6;
            byArray3[n8] = (byte)(byArray3[n8] ^ byArray4[n6]);
        }
        byArray4 = this.a(byArray3, 0, this.a.length, byArray3.length - this.a.length);
        for (n6 = this.a.length; n6 != byArray3.length; ++n6) {
            int n9 = n6;
            byArray3[n9] = (byte)(byArray3[n9] ^ byArray4[n6 - this.a.length]);
        }
        n6 = 0;
        for (n5 = 0; n5 != this.a.length; ++n5) {
            if (this.a[n5] == byArray3[this.a.length + n5]) continue;
            n6 = 1;
        }
        n5 = byArray3.length;
        for (n4 = 2 * this.a.length; n4 != byArray3.length; ++n4) {
            if (!(byArray3[n4] != 0 & n5 == byArray3.length)) continue;
            n5 = n4;
        }
        n4 = (n5 > byArray3.length - 1 ? 1 : 0) | (byArray3[n5] != 1 ? 1 : 0);
        ++n5;
        if ((n6 | n7 | n4) != 0) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("data wrong");
        }
        byte[] byArray5 = new byte[byArray3.length - n5];
        System.arraycopy(byArray3, n5, byArray5, 0, byArray5.length);
        return byArray5;
    }

    private void a(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    private byte[] a(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[this.b.getDigestSize()];
        byte[] byArray4 = new byte[4];
        this.b.reset();
        for (n5 = 0; n5 < n4 / byArray3.length; ++n5) {
            this.a(n5, byArray4);
            this.b.update(byArray, n2, n3);
            this.b.update(byArray4, 0, byArray4.length);
            this.b.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * byArray3.length, byArray3.length);
        }
        if (n5 * byArray3.length < n4) {
            this.a(n5, byArray4);
            this.b.update(byArray, n2, n3);
            this.b.update(byArray4, 0, byArray4.length);
            this.b.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * byArray3.length, byArray2.length - n5 * byArray3.length);
        }
        return byArray2;
    }
}

