/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.engines;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.Wrapper;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.RC2Engine;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.crypto.util.DigestFactory;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class RC2WrapEngine
implements Wrapper {
    private CBCBlockCipher a;
    private CipherParameters b;
    private ParametersWithIV c;
    private byte[] d;
    private boolean e;
    private SecureRandom f;
    private static final byte[] g = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    Digest sha1 = DigestFactory.createSHA1();
    byte[] digest = new byte[20];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.e = bl2;
        this.a = new CBCBlockCipher(new RC2Engine());
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.f = parametersWithRandom.getRandom();
            cipherParameters = parametersWithRandom.getParameters();
        } else {
            this.f = new SecureRandom();
        }
        if (cipherParameters instanceof ParametersWithIV) {
            this.c = (ParametersWithIV)cipherParameters;
            this.d = this.c.getIV();
            this.b = this.c.getParameters();
            if (!this.e) throw new IllegalArgumentException("You should not supply an IV for unwrapping");
            if (this.d != null && this.d.length == 8) return;
            throw new IllegalArgumentException("IV is not 8 octets");
        }
        this.b = cipherParameters;
        if (!this.e) return;
        this.d = new byte[8];
        this.f.nextBytes(this.d);
        this.c = new ParametersWithIV(this.b, this.d);
    }

    @Override
    public String getAlgorithmName() {
        return "RC2";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) {
        if (!this.e) {
            throw new IllegalStateException("Not initialized for wrapping");
        }
        int n4 = n3 + 1;
        if (n4 % 8 != 0) {
            n4 += 8 - n4 % 8;
        }
        byte[] byArray2 = new byte[n4];
        byArray2[0] = (byte)n3;
        System.arraycopy(byArray, n2, byArray2, 1, n3);
        byte[] byArray3 = new byte[byArray2.length - n3 - 1];
        if (byArray3.length > 0) {
            this.f.nextBytes(byArray3);
            System.arraycopy(byArray3, 0, byArray2, n3 + 1, byArray3.length);
        }
        byte[] byArray4 = this.a(byArray2);
        byte[] byArray5 = new byte[byArray2.length + byArray4.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray4, 0, byArray5, byArray2.length, byArray4.length);
        byte[] byArray6 = new byte[byArray5.length];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
        int n5 = byArray5.length / this.a.getBlockSize();
        int n6 = byArray5.length % this.a.getBlockSize();
        if (n6 != 0) {
            throw new IllegalStateException("Not multiple of block length");
        }
        this.a.init(true, this.c);
        for (int i2 = 0; i2 < n5; ++i2) {
            int n7 = i2 * this.a.getBlockSize();
            this.a.processBlock(byArray6, n7, byArray6, n7);
        }
        byte[] byArray7 = new byte[this.d.length + byArray6.length];
        System.arraycopy(this.d, 0, byArray7, 0, this.d.length);
        System.arraycopy(byArray6, 0, byArray7, this.d.length, byArray6.length);
        byte[] byArray8 = new byte[byArray7.length];
        for (int i3 = 0; i3 < byArray7.length; ++i3) {
            byArray8[i3] = byArray7[byArray7.length - (i3 + 1)];
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.b, g);
        this.a.init(true, parametersWithIV);
        for (int i4 = 0; i4 < n5 + 1; ++i4) {
            int n8 = i4 * this.a.getBlockSize();
            this.a.processBlock(byArray8, n8, byArray8, n8);
        }
        return byArray8;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        if (this.e) {
            throw new IllegalStateException("Not set for unwrapping");
        }
        if (byArray == null) {
            throw new InvalidCipherTextException("Null pointer as ciphertext");
        }
        if (n3 % this.a.getBlockSize() != 0) {
            throw new InvalidCipherTextException("Ciphertext not multiple of " + this.a.getBlockSize());
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.b, g);
        this.a.init(false, parametersWithIV);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        for (int i2 = 0; i2 < byArray2.length / this.a.getBlockSize(); ++i2) {
            n4 = i2 * this.a.getBlockSize();
            this.a.processBlock(byArray2, n4, byArray2, n4);
        }
        byte[] byArray3 = new byte[byArray2.length];
        for (n4 = 0; n4 < byArray2.length; ++n4) {
            byArray3[n4] = byArray2[byArray2.length - (n4 + 1)];
        }
        this.d = new byte[8];
        byte[] byArray4 = new byte[byArray3.length - 8];
        System.arraycopy(byArray3, 0, this.d, 0, 8);
        System.arraycopy(byArray3, 8, byArray4, 0, byArray3.length - 8);
        this.c = new ParametersWithIV(this.b, this.d);
        this.a.init(false, this.c);
        byte[] byArray5 = new byte[byArray4.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        for (int i3 = 0; i3 < byArray5.length / this.a.getBlockSize(); ++i3) {
            int n5 = i3 * this.a.getBlockSize();
            this.a.processBlock(byArray5, n5, byArray5, n5);
        }
        byte[] byArray6 = new byte[byArray5.length - 8];
        byte[] byArray7 = new byte[8];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length - 8);
        System.arraycopy(byArray5, byArray5.length - 8, byArray7, 0, 8);
        if (!this.a(byArray6, byArray7)) {
            throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
        }
        if (byArray6.length - ((byArray6[0] & 0xFF) + 1) > 7) {
            throw new InvalidCipherTextException("too many pad bytes (" + (byArray6.length - ((byArray6[0] & 0xFF) + 1)) + ")");
        }
        byte[] byArray8 = new byte[byArray6[0]];
        System.arraycopy(byArray6, 1, byArray8, 0, byArray8.length);
        return byArray8;
    }

    private byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        this.sha1.update(byArray, 0, byArray.length);
        this.sha1.doFinal(this.digest, 0);
        System.arraycopy(this.digest, 0, byArray2, 0, 8);
        return byArray2;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        return Arrays.constantTimeAreEqual(this.a(byArray), byArray2);
    }
}

