/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.generators;

import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.DigestDerivationFunction;
import com.aspose.imaging.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ISO18033KDFParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KDFParameters;
import com.aspose.imaging.internal.bouncycastle.util.Pack;

public class BaseKDFBytesGenerator
implements DigestDerivationFunction {
    private int a;
    private Digest b;
    private byte[] c;
    private byte[] d;

    protected BaseKDFBytesGenerator(int n2, Digest digest) {
        this.a = n2;
        this.b = digest;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFParameters) {
            KDFParameters kDFParameters = (KDFParameters)derivationParameters;
            this.c = kDFParameters.getSharedSecret();
            this.d = kDFParameters.getIV();
        } else if (derivationParameters instanceof ISO18033KDFParameters) {
            ISO18033KDFParameters iSO18033KDFParameters = (ISO18033KDFParameters)derivationParameters;
            this.c = iSO18033KDFParameters.getSeed();
            this.d = null;
        } else {
            throw new IllegalArgumentException("KDF parameters required for generator");
        }
    }

    @Override
    public Digest getDigest() {
        return this.b;
    }

    @Override
    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n3 < n2) {
            throw new OutputLengthException("output buffer too small");
        }
        long l2 = n3;
        int n4 = this.b.getDigestSize();
        if (l2 > 0x1FFFFFFFFL) {
            throw new IllegalArgumentException("Output length too large");
        }
        int n5 = (int)((l2 + (long)n4 - 1L) / (long)n4);
        byte[] byArray2 = new byte[this.b.getDigestSize()];
        byte[] byArray3 = new byte[4];
        Pack.intToBigEndian(this.a, byArray3, 0);
        int n6 = this.a & 0xFFFFFF00;
        for (int i2 = 0; i2 < n5; ++i2) {
            this.b.update(this.c, 0, this.c.length);
            this.b.update(byArray3, 0, byArray3.length);
            if (this.d != null) {
                this.b.update(this.d, 0, this.d.length);
            }
            this.b.doFinal(byArray2, 0);
            if (n3 > n4) {
                System.arraycopy(byArray2, 0, byArray, n2, n4);
                n2 += n4;
                n3 -= n4;
            } else {
                System.arraycopy(byArray2, 0, byArray, n2, n3);
            }
            byArray3[3] = (byte)(byArray3[3] + 1);
            if (byArray3[3] != 0) continue;
            Pack.intToBigEndian(n6 += 256, byArray3, 0);
        }
        this.b.reset();
        return (int)l2;
    }
}

