/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.io;

import com.aspose.imaging.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.SkippingCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.StreamCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.io.CipherIOException;
import com.aspose.imaging.internal.bouncycastle.crypto.io.InvalidCipherTextIOException;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.AEADBlockCipher;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CipherInputStream
extends FilterInputStream {
    private static final int a = 2048;
    private SkippingCipher b;
    private byte[] c;
    private BufferedBlockCipher d;
    private StreamCipher e;
    private AEADBlockCipher f;
    private byte[] g;
    private byte[] h;
    private int i;
    private int j;
    private boolean k;
    private long l;
    private int m;

    public CipherInputStream(InputStream inputStream, BufferedBlockCipher bufferedBlockCipher) {
        this(inputStream, bufferedBlockCipher, 2048);
    }

    public CipherInputStream(InputStream inputStream, StreamCipher streamCipher) {
        this(inputStream, streamCipher, 2048);
    }

    public CipherInputStream(InputStream inputStream, AEADBlockCipher aEADBlockCipher) {
        this(inputStream, aEADBlockCipher, 2048);
    }

    public CipherInputStream(InputStream inputStream, BufferedBlockCipher bufferedBlockCipher, int n2) {
        super(inputStream);
        this.d = bufferedBlockCipher;
        this.c = new byte[n2];
        this.b = bufferedBlockCipher instanceof SkippingCipher ? (SkippingCipher)((Object)bufferedBlockCipher) : null;
    }

    public CipherInputStream(InputStream inputStream, StreamCipher streamCipher, int n2) {
        super(inputStream);
        this.e = streamCipher;
        this.c = new byte[n2];
        this.b = streamCipher instanceof SkippingCipher ? (SkippingCipher)((Object)streamCipher) : null;
    }

    public CipherInputStream(InputStream inputStream, AEADBlockCipher aEADBlockCipher, int n2) {
        super(inputStream);
        this.f = aEADBlockCipher;
        this.c = new byte[n2];
        this.b = aEADBlockCipher instanceof SkippingCipher ? (SkippingCipher)((Object)aEADBlockCipher) : null;
    }

    private int a() throws IOException {
        if (this.k) {
            return -1;
        }
        this.i = 0;
        this.j = 0;
        while (this.j == 0) {
            int n2 = this.in.read(this.c);
            if (n2 == -1) {
                this.b();
                if (this.j == 0) {
                    return -1;
                }
                return this.j;
            }
            try {
                this.a(n2, false);
                if (this.d != null) {
                    this.j = this.d.processBytes(this.c, 0, n2, this.g, 0);
                    continue;
                }
                if (this.f != null) {
                    this.j = this.f.processBytes(this.c, 0, n2, this.g, 0);
                    continue;
                }
                this.e.processBytes(this.c, 0, n2, this.g, 0);
                this.j = n2;
            }
            catch (Exception exception) {
                throw new CipherIOException("Error processing stream ", exception);
            }
        }
        return this.j;
    }

    private void b() throws IOException {
        try {
            this.k = true;
            this.a(0, true);
            this.j = this.d != null ? this.d.doFinal(this.g, 0) : (this.f != null ? this.f.doFinal(this.g, 0) : 0);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new InvalidCipherTextIOException("Error finalising cipher", invalidCipherTextException);
        }
        catch (Exception exception) {
            throw new IOException("Error finalising cipher " + exception);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.i >= this.j && this.a() < 0) {
            return -1;
        }
        return this.g[this.i++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.i >= this.j && this.a() < 0) {
            return -1;
        }
        int n4 = Math.min(n3, this.available());
        System.arraycopy(this.g, this.i, byArray, n2, n4);
        this.i += n4;
        return n4;
    }

    @Override
    public long skip(long l2) throws IOException {
        if (l2 <= 0L) {
            return 0L;
        }
        if (this.b != null) {
            long l3;
            int n2 = this.available();
            if (l2 <= (long)n2) {
                this.i = (int)((long)this.i + l2);
                return l2;
            }
            this.i = this.j;
            long l4 = this.in.skip(l2 - (long)n2);
            if (l4 != (l3 = this.b.skip(l4))) {
                throw new IOException("Unable to skip cipher " + l4 + " bytes.");
            }
            return l4 + (long)n2;
        }
        int n3 = (int)Math.min(l2, (long)this.available());
        this.i += n3;
        return n3;
    }

    @Override
    public int available() throws IOException {
        return this.j - this.i;
    }

    private void a(int n2, boolean bl2) {
        int n3 = n2;
        if (bl2) {
            if (this.d != null) {
                n3 = this.d.getOutputSize(n2);
            } else if (this.f != null) {
                n3 = this.f.getOutputSize(n2);
            }
        } else if (this.d != null) {
            n3 = this.d.getUpdateOutputSize(n2);
        } else if (this.f != null) {
            n3 = this.f.getUpdateOutputSize(n2);
        }
        if (this.g == null || this.g.length < n3) {
            this.g = new byte[n3];
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            if (!this.k) {
                this.b();
            }
        }
        this.i = 0;
        this.j = 0;
        this.m = 0;
        this.l = 0L;
        if (this.h != null) {
            Arrays.fill(this.h, (byte)0);
            this.h = null;
        }
        if (this.g != null) {
            Arrays.fill(this.g, (byte)0);
            this.g = null;
        }
        Arrays.fill(this.c, (byte)0);
    }

    @Override
    public void mark(int n2) {
        this.in.mark(n2);
        if (this.b != null) {
            this.l = this.b.getPosition();
        }
        if (this.g != null) {
            this.h = new byte[this.g.length];
            System.arraycopy(this.g, 0, this.h, 0, this.g.length);
        }
        this.m = this.i;
    }

    @Override
    public void reset() throws IOException {
        if (this.b == null) {
            throw new IOException("cipher must implement SkippingCipher to be used with reset()");
        }
        this.in.reset();
        this.b.seekTo(this.l);
        if (this.h != null) {
            this.g = this.h;
        }
        this.i = this.m;
    }

    @Override
    public boolean markSupported() {
        if (this.b != null) {
            return this.in.markSupported();
        }
        return false;
    }
}

