/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.modes;

import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.Mac;
import com.aspose.imaging.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.macs.CMac;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.AEADBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.SICBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AEADParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class EAXBlockCipher
implements AEADBlockCipher {
    private static final byte a = 0;
    private static final byte b = 1;
    private static final byte c = 2;
    private SICBlockCipher d;
    private boolean e;
    private int f;
    private Mac g;
    private byte[] h;
    private byte[] i;
    private byte[] j;
    private int k;
    private byte[] l;
    private int m;
    private boolean n;
    private byte[] o;

    public EAXBlockCipher(BlockCipher blockCipher) {
        this.f = blockCipher.getBlockSize();
        this.g = new CMac(blockCipher);
        this.j = new byte[this.f];
        this.i = new byte[this.g.getMacSize()];
        this.h = new byte[this.g.getMacSize()];
        this.d = new SICBlockCipher(blockCipher);
    }

    @Override
    public String getAlgorithmName() {
        return this.d.getUnderlyingCipher().getAlgorithmName() + "/EAX";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.d.getUnderlyingCipher();
    }

    public int getBlockSize() {
        return this.d.getBlockSize();
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2;
        byte[] byArray;
        Object object;
        this.e = bl2;
        if (cipherParameters instanceof AEADParameters) {
            object = (AEADParameters)cipherParameters;
            byArray = ((AEADParameters)object).getNonce();
            this.o = ((AEADParameters)object).getAssociatedText();
            this.k = ((AEADParameters)object).getMacSize() / 8;
            cipherParameters2 = ((AEADParameters)object).getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            object = (ParametersWithIV)cipherParameters;
            byArray = ((ParametersWithIV)object).getIV();
            this.o = null;
            this.k = this.g.getMacSize() / 2;
            cipherParameters2 = ((ParametersWithIV)object).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to EAX");
        }
        this.l = new byte[bl2 ? this.f : this.f + this.k];
        object = new byte[this.f];
        this.g.init(cipherParameters2);
        object[this.f - 1] = false;
        this.g.update((byte[])object, 0, this.f);
        this.g.update(byArray, 0, byArray.length);
        this.g.doFinal(this.h, 0);
        this.d.init(true, new ParametersWithIV(null, this.h));
        this.reset();
    }

    private void a() {
        if (this.n) {
            return;
        }
        this.n = true;
        this.g.doFinal(this.i, 0);
        byte[] byArray = new byte[this.f];
        byArray[this.f - 1] = 2;
        this.g.update(byArray, 0, this.f);
    }

    private void b() {
        byte[] byArray = new byte[this.f];
        this.g.doFinal(byArray, 0);
        for (int i2 = 0; i2 < this.j.length; ++i2) {
            this.j[i2] = (byte)(this.h[i2] ^ this.i[i2] ^ byArray[i2]);
        }
    }

    @Override
    public void reset() {
        this.a(true);
    }

    private void a(boolean bl2) {
        this.d.reset();
        this.g.reset();
        this.m = 0;
        Arrays.fill(this.l, (byte)0);
        if (bl2) {
            Arrays.fill(this.j, (byte)0);
        }
        byte[] byArray = new byte[this.f];
        byArray[this.f - 1] = 1;
        this.g.update(byArray, 0, this.f);
        this.n = false;
        if (this.o != null) {
            this.processAADBytes(this.o, 0, this.o.length);
        }
    }

    @Override
    public void processAADByte(byte by2) {
        if (this.n) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
        }
        this.g.update(by2);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n2, int n3) {
        if (this.n) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
        }
        this.g.update(byArray, n2, n3);
    }

    @Override
    public int processByte(byte by2, byte[] byArray, int n2) throws DataLengthException {
        this.a();
        return this.a(by2, byArray, n2);
    }

    @Override
    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
        this.a();
        if (byArray.length < n2 + n3) {
            throw new DataLengthException("Input buffer too short");
        }
        int n5 = 0;
        for (int i2 = 0; i2 != n3; ++i2) {
            n5 += this.a(byArray[n2 + i2], byArray2, n4 + n5);
        }
        return n5;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, InvalidCipherTextException {
        this.a();
        int n3 = this.m;
        byte[] byArray2 = new byte[this.l.length];
        this.m = 0;
        if (this.e) {
            if (byArray.length < n2 + n3 + this.k) {
                throw new OutputLengthException("Output buffer too short");
            }
            this.d.processBlock(this.l, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            this.g.update(byArray2, 0, n3);
            this.b();
            System.arraycopy(this.j, 0, byArray, n2 + n3, this.k);
            this.a(false);
            return n3 + this.k;
        }
        if (n3 < this.k) {
            throw new InvalidCipherTextException("data too short");
        }
        if (byArray.length < n2 + n3 - this.k) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (n3 > this.k) {
            this.g.update(this.l, 0, n3 - this.k);
            this.d.processBlock(this.l, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2, n3 - this.k);
        }
        this.b();
        if (!this.a(this.l, n3 - this.k)) {
            throw new InvalidCipherTextException("mac check in EAX failed");
        }
        this.a(false);
        return n3 - this.k;
    }

    @Override
    public byte[] getMac() {
        byte[] byArray = new byte[this.k];
        System.arraycopy(this.j, 0, byArray, 0, this.k);
        return byArray;
    }

    @Override
    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.m;
        if (!this.e) {
            if (n3 < this.k) {
                return 0;
            }
            n3 -= this.k;
        }
        return n3 - n3 % this.f;
    }

    @Override
    public int getOutputSize(int n2) {
        int n3 = n2 + this.m;
        if (this.e) {
            return n3 + this.k;
        }
        return n3 < this.k ? 0 : n3 - this.k;
    }

    private int a(byte by2, byte[] byArray, int n2) {
        this.l[this.m++] = by2;
        if (this.m == this.l.length) {
            int n3;
            if (byArray.length < n2 + this.f) {
                throw new OutputLengthException("Output buffer is too short");
            }
            if (this.e) {
                n3 = this.d.processBlock(this.l, 0, byArray, n2);
                this.g.update(byArray, n2, this.f);
            } else {
                this.g.update(this.l, 0, this.f);
                n3 = this.d.processBlock(this.l, 0, byArray, n2);
            }
            this.m = 0;
            if (!this.e) {
                System.arraycopy(this.l, this.f, this.l, 0, this.k);
                this.m = this.k;
            }
            return n3;
        }
        return 0;
    }

    private boolean a(byte[] byArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.k; ++i2) {
            n3 |= this.j[i2] ^ byArray[n2 + i2];
        }
        return n3 == 0;
    }
}

