/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.modes;

import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.StreamBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class KCTRBlockCipher
extends StreamBlockCipher {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private int d;
    private boolean e;
    private BlockCipher f;

    public KCTRBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.f = blockCipher;
        this.a = new byte[blockCipher.getBlockSize()];
        this.b = new byte[blockCipher.getBlockSize()];
        this.c = new byte[blockCipher.getBlockSize()];
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.e = true;
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("invalid parameter passed");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        int n2 = this.a.length - byArray.length;
        Arrays.fill(this.a, (byte)0);
        System.arraycopy(byArray, 0, this.a, n2, byArray.length);
        cipherParameters = parametersWithIV.getParameters();
        if (cipherParameters != null) {
            this.f.init(true, cipherParameters);
        }
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/KCTR";
    }

    @Override
    public int getBlockSize() {
        return this.f.getBlockSize();
    }

    @Override
    protected byte calculateByte(byte by2) {
        if (this.d == 0) {
            this.a(0);
            this.a();
            this.f.processBlock(this.b, 0, this.c, 0);
            return (byte)(this.c[this.d++] ^ by2);
        }
        byte by3 = (byte)(this.c[this.d++] ^ by2);
        if (this.d == this.b.length) {
            this.d = 0;
        }
        return by3;
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (byArray.length - n2 < this.getBlockSize()) {
            throw new DataLengthException("input buffer too short");
        }
        if (byArray2.length - n3 < this.getBlockSize()) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processBytes(byArray, n2, this.getBlockSize(), byArray2, n3);
        return this.getBlockSize();
    }

    @Override
    public void reset() {
        if (this.e) {
            this.f.processBlock(this.a, 0, this.b, 0);
        }
        this.f.reset();
        this.d = 0;
    }

    private void a(int n2) {
        int n3 = n2;
        while (n3 < this.b.length) {
            int n4 = n3++;
            this.b[n4] = (byte)(this.b[n4] + 1);
            if (this.b[n4] == 0) continue;
            break;
        }
    }

    private void a() {
    }
}

