/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.modes.gcm;

import com.aspose.imaging.internal.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] a;
    private long[][][] b;

    @Override
    public void init(byte[] byArray) {
        if (this.b == null) {
            this.b = new long[16][256][2];
        } else if (Arrays.areEqual(this.a, byArray)) {
            return;
        }
        this.a = Arrays.clone(byArray);
        for (int i2 = 0; i2 < 16; ++i2) {
            long[][] lArray = this.b[i2];
            if (i2 == 0) {
                GCMUtil.asLongs(this.a, lArray[1]);
                GCMUtil.multiplyP7(lArray[1], lArray[1]);
            } else {
                GCMUtil.multiplyP8(this.b[i2 - 1][1], lArray[1]);
            }
            for (int i3 = 2; i3 < 256; i3 += 2) {
                GCMUtil.divideP(lArray[i3 >> 1], lArray[i3]);
                GCMUtil.xor(lArray[i3], lArray[1], lArray[i3 + 1]);
            }
        }
    }

    @Override
    public void multiplyH(byte[] byArray) {
        long[] lArray = this.b[15][byArray[15] & 0xFF];
        long l2 = lArray[0];
        long l3 = lArray[1];
        for (int i2 = 14; i2 >= 0; --i2) {
            lArray = this.b[i2][byArray[i2] & 0xFF];
            l2 ^= lArray[0];
            l3 ^= lArray[1];
        }
        Pack.longToBigEndian(l2, byArray, 0);
        Pack.longToBigEndian(l3, byArray, 8);
    }
}

