/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.params;

import com.aspose.imaging.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public final class KDFCounterParameters
implements DerivationParameters {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private int d;

    public KDFCounterParameters(byte[] byArray, byte[] byArray2, int n2) {
        this(byArray, null, byArray2, n2);
    }

    public KDFCounterParameters(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.a = Arrays.clone(byArray);
        this.b = byArray2 == null ? new byte[0] : Arrays.clone(byArray2);
        this.c = byArray3 == null ? new byte[0] : Arrays.clone(byArray3);
        if (n2 != 8 && n2 != 16 && n2 != 24 && n2 != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        this.d = n2;
    }

    public byte[] getKI() {
        return this.a;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.c);
    }

    public byte[] getFixedInputDataCounterPrefix() {
        return Arrays.clone(this.b);
    }

    public byte[] getFixedInputDataCounterSuffix() {
        return Arrays.clone(this.c);
    }

    public int getR() {
        return this.d;
    }
}

