/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg;

import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.EntropySource;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.encoders.Hex;

public class CTRSP800DRBG
implements SP80090DRBG {
    private static final long a = 0x80000000L;
    private static final long b = 0x800000000000L;
    private static final int c = 4096;
    private static final int d = 262144;
    private EntropySource e;
    private BlockCipher f;
    private int g;
    private int h;
    private int i;
    private byte[] j;
    private byte[] k;
    private long l = 0L;
    private boolean m = false;
    private static final byte[] n = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");

    public CTRSP800DRBG(BlockCipher blockCipher, int n2, int n3, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        this.e = entropySource;
        this.f = blockCipher;
        this.g = n2;
        this.i = n3;
        this.h = n2 + blockCipher.getBlockSize() * 8;
        this.m = this.a(blockCipher);
        if (n3 > 256) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (this.a(blockCipher, n2) < n3) {
            throw new IllegalArgumentException("Requested security strength is not supported by block cipher and key size");
        }
        if (entropySource.entropySize() < n3) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        byte[] byArray3 = this.a();
        this.a(byArray3, byArray2, byArray);
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = Arrays.concatenate(byArray, byArray2, byArray3);
        byte[] byArray5 = this.a(byArray4, this.h);
        int n2 = this.f.getBlockSize();
        this.j = new byte[(this.g + 7) / 8];
        this.k = new byte[n2];
        this.b(byArray5, this.j, this.k);
        this.l = 1L;
    }

    private void b(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length];
        byte[] byArray5 = new byte[this.f.getBlockSize()];
        int n2 = 0;
        int n3 = this.f.getBlockSize();
        this.f.init(true, new KeyParameter(this.expandKey(byArray2)));
        while (n2 * n3 < byArray.length) {
            this.b(byArray3);
            this.f.processBlock(byArray3, 0, byArray5, 0);
            int n4 = byArray4.length - n2 * n3 > n3 ? n3 : byArray4.length - n2 * n3;
            System.arraycopy(byArray5, 0, byArray4, n2 * n3, n4);
            ++n2;
        }
        this.a(byArray4, byArray, byArray4, 0);
        System.arraycopy(byArray4, 0, byArray2, 0, byArray2.length);
        System.arraycopy(byArray4, byArray2.length, byArray3, 0, byArray3.length);
    }

    private void a(byte[] byArray) {
        byte[] byArray2 = Arrays.concatenate(this.a(), byArray);
        byArray2 = this.a(byArray2, this.h);
        this.b(byArray2, this.j, this.k);
        this.l = 1L;
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)(byArray2[i2] ^ byArray3[i2 + n2]);
        }
    }

    private void b(byte[] byArray) {
        int n2 = 1;
        for (int i2 = 1; i2 <= byArray.length; ++i2) {
            int n3 = (byArray[byArray.length - i2] & 0xFF) + n2;
            n2 = n3 > 255 ? 1 : 0;
            byArray[byArray.length - i2] = (byte)n3;
        }
    }

    private byte[] a() {
        byte[] byArray = this.e.getEntropy();
        if (byArray.length < (this.i + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    private byte[] a(byte[] byArray, int n2) {
        int n3 = this.f.getBlockSize();
        int n4 = byArray.length;
        int n5 = n2 / 8;
        int n6 = 8 + n4 + 1;
        int n7 = (n6 + n3 - 1) / n3 * n3;
        byte[] byArray2 = new byte[n7];
        this.a(byArray2, n4, 0);
        this.a(byArray2, n5, 4);
        System.arraycopy(byArray, 0, byArray2, 8, n4);
        byArray2[8 + n4] = -128;
        byte[] byArray3 = new byte[this.g / 8 + n3];
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n3];
        int n8 = 0;
        byte[] byArray6 = new byte[this.g / 8];
        System.arraycopy(n, 0, byArray6, 0, byArray6.length);
        while (n8 * n3 * 8 < this.g + n3 * 8) {
            this.a(byArray5, n8, 0);
            this.a(byArray4, byArray6, byArray5, byArray2);
            int n9 = byArray3.length - n8 * n3 > n3 ? n3 : byArray3.length - n8 * n3;
            System.arraycopy(byArray4, 0, byArray3, n8 * n3, n9);
            ++n8;
        }
        byte[] byArray7 = new byte[n3];
        System.arraycopy(byArray3, 0, byArray6, 0, byArray6.length);
        System.arraycopy(byArray3, byArray6.length, byArray7, 0, byArray7.length);
        byArray3 = new byte[n2 / 8];
        n8 = 0;
        this.f.init(true, new KeyParameter(this.expandKey(byArray6)));
        while (n8 * n3 < byArray3.length) {
            this.f.processBlock(byArray7, 0, byArray7, 0);
            int n10 = byArray3.length - n8 * n3 > n3 ? n3 : byArray3.length - n8 * n3;
            System.arraycopy(byArray7, 0, byArray3, n8 * n3, n10);
            ++n8;
        }
        return byArray3;
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n2 = this.f.getBlockSize();
        byte[] byArray5 = new byte[n2];
        int n3 = byArray4.length / n2;
        byte[] byArray6 = new byte[n2];
        this.f.init(true, new KeyParameter(this.expandKey(byArray2)));
        this.f.processBlock(byArray3, 0, byArray5, 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.a(byArray6, byArray5, byArray4, i2 * n2);
            this.f.processBlock(byArray6, 0, byArray5, 0);
        }
        System.arraycopy(byArray5, 0, byArray, 0, byArray.length);
    }

    private void a(byte[] byArray, int n2, int n3) {
        byArray[n3 + 0] = (byte)(n2 >> 24);
        byArray[n3 + 1] = (byte)(n2 >> 16);
        byArray[n3 + 2] = (byte)(n2 >> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    @Override
    public int getBlockSize() {
        return this.k.length * 8;
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl2) {
        if (this.m) {
            if (this.l > 0x80000000L) {
                return -1;
            }
            if (com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a.a(byArray, 512)) {
                throw new IllegalArgumentException("Number of bits per request limited to 4096");
            }
        } else {
            if (this.l > 0x800000000000L) {
                return -1;
            }
            if (com.aspose.imaging.internal.bouncycastle.crypto.prng.drbg.a.a(byArray, 32768)) {
                throw new IllegalArgumentException("Number of bits per request limited to 262144");
            }
        }
        if (bl2) {
            this.a(byArray2);
            byArray2 = null;
        }
        if (byArray2 != null) {
            byArray2 = this.a(byArray2, this.h);
            this.b(byArray2, this.j, this.k);
        } else {
            byArray2 = new byte[this.h];
        }
        byte[] byArray3 = new byte[this.k.length];
        this.f.init(true, new KeyParameter(this.expandKey(this.j)));
        for (int i2 = 0; i2 <= byArray.length / byArray3.length; ++i2) {
            int n2;
            int n3 = n2 = byArray.length - i2 * byArray3.length > byArray3.length ? byArray3.length : byArray.length - i2 * this.k.length;
            if (n2 == 0) continue;
            this.b(this.k);
            this.f.processBlock(this.k, 0, byArray3, 0);
            System.arraycopy(byArray3, 0, byArray, i2 * byArray3.length, n2);
        }
        this.b(byArray2, this.j, this.k);
        ++this.l;
        return byArray.length * 8;
    }

    @Override
    public void reseed(byte[] byArray) {
        this.a(byArray);
    }

    private boolean a(BlockCipher blockCipher) {
        return blockCipher.getAlgorithmName().equals("DESede") || blockCipher.getAlgorithmName().equals("TDEA");
    }

    private int a(BlockCipher blockCipher, int n2) {
        if (this.a(blockCipher) && n2 == 168) {
            return 112;
        }
        if (blockCipher.getAlgorithmName().equals("AES")) {
            return n2;
        }
        return -1;
    }

    byte[] expandKey(byte[] byArray) {
        if (this.m) {
            byte[] byArray2 = new byte[24];
            this.a(byArray, 0, byArray2, 0);
            this.a(byArray, 7, byArray2, 8);
            this.a(byArray, 14, byArray2, 16);
            return byArray2;
        }
        return byArray;
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        byArray2[n3 + 0] = (byte)(byArray[n2 + 0] & 0xFE);
        byArray2[n3 + 1] = (byte)(byArray[n2 + 0] << 7 | (byArray[n2 + 1] & 0xFC) >>> 1);
        byArray2[n3 + 2] = (byte)(byArray[n2 + 1] << 6 | (byArray[n2 + 2] & 0xF8) >>> 2);
        byArray2[n3 + 3] = (byte)(byArray[n2 + 2] << 5 | (byArray[n2 + 3] & 0xF0) >>> 3);
        byArray2[n3 + 4] = (byte)(byArray[n2 + 3] << 4 | (byArray[n2 + 4] & 0xE0) >>> 4);
        byArray2[n3 + 5] = (byte)(byArray[n2 + 4] << 3 | (byArray[n2 + 5] & 0xC0) >>> 5);
        byArray2[n3 + 6] = (byte)(byArray[n2 + 5] << 2 | (byArray[n2 + 6] & 0x80) >>> 6);
        byArray2[n3 + 7] = (byte)(byArray[n2 + 6] << 1);
        for (int i2 = n3; i2 <= n3 + 7; ++i2) {
            byte by2 = byArray2[i2];
            byArray2[i2] = (byte)(by2 & 0xFE | (by2 >> 1 ^ by2 >> 2 ^ by2 >> 3 ^ by2 >> 4 ^ by2 >> 5 ^ by2 >> 6 ^ by2 >> 7 ^ 1) & 1);
        }
    }
}

