/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.signers;

import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.CryptoException;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.SignerWithRecovery;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RSAKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.signers.ISOTrailers;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class ISO9796d2Signer
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    private Digest a;
    private AsymmetricBlockCipher b;
    private int c;
    private int d;
    private byte[] e;
    private byte[] f;
    private int g;
    private boolean h;
    private byte[] i;
    private byte[] j;
    private byte[] k;

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, boolean bl2) {
        this.b = asymmetricBlockCipher;
        this.a = digest;
        if (bl2) {
            this.c = 188;
        } else {
            Integer n2 = ISOTrailers.getTrailer(digest);
            if (n2 != null) {
                this.c = n2;
            } else {
                throw new IllegalArgumentException("no valid trailer for digest: " + digest.getAlgorithmName());
            }
        }
    }

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, false);
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)cipherParameters;
        this.b.init(bl2, rSAKeyParameters);
        this.d = rSAKeyParameters.getModulus().bitLength();
        this.e = new byte[(this.d + 7) / 8];
        this.f = this.c == 188 ? new byte[this.e.length - this.a.getDigestSize() - 2] : new byte[this.e.length - this.a.getDigestSize() - 3];
        this.reset();
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        boolean bl2 = true;
        if (this.g > this.f.length) {
            if (this.f.length > byArray2.length) {
                bl2 = false;
            }
            for (int i2 = 0; i2 != this.f.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                bl2 = false;
            }
        } else {
            if (this.g != byArray2.length) {
                bl2 = false;
            }
            for (int i3 = 0; i3 != byArray2.length; ++i3) {
                if (byArray[i3] == byArray2[i3]) continue;
                bl2 = false;
            }
        }
        return bl2;
    }

    private void a(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    @Override
    public void updateWithRecoveredMessage(byte[] byArray) throws InvalidCipherTextException {
        int n2;
        byte[] byArray2 = this.b.processBlock(byArray, 0, byArray.length);
        if ((byArray2[0] & 0xC0 ^ 0x40) != 0) {
            throw new InvalidCipherTextException("malformed signature");
        }
        if ((byArray2[byArray2.length - 1] & 0xF ^ 0xC) != 0) {
            throw new InvalidCipherTextException("malformed signature");
        }
        int n3 = 0;
        if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) == 0) {
            n3 = 1;
        } else {
            n2 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
            Integer n4 = ISOTrailers.getTrailer(this.a);
            if (n4 != null) {
                int n5 = n4;
                if (n2 != n5 && (n5 != 15052 || n2 != 16588)) {
                    throw new IllegalStateException("signer initialised with wrong digest for trailer " + n2);
                }
            } else {
                throw new IllegalArgumentException("unrecognised hash in signature");
            }
            n3 = 2;
        }
        n2 = 0;
        for (n2 = 0; n2 != byArray2.length && (byArray2[n2] & 0xF ^ 0xA) != 0; ++n2) {
        }
        int n6 = byArray2.length - n3 - this.a.getDigestSize();
        if (n6 - ++n2 <= 0) {
            throw new InvalidCipherTextException("malformed block");
        }
        if ((byArray2[0] & 0x20) == 0) {
            this.h = true;
            this.i = new byte[n6 - n2];
            System.arraycopy(byArray2, n2, this.i, 0, this.i.length);
        } else {
            this.h = false;
            this.i = new byte[n6 - n2];
            System.arraycopy(byArray2, n2, this.i, 0, this.i.length);
        }
        this.j = byArray;
        this.k = byArray2;
        this.a.update(this.i, 0, this.i.length);
        this.g = this.i.length;
        System.arraycopy(this.i, 0, this.f, 0, this.i.length);
    }

    @Override
    public void update(byte by2) {
        this.a.update(by2);
        if (this.g < this.f.length) {
            this.f[this.g] = by2;
        }
        ++this.g;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        while (n3 > 0 && this.g < this.f.length) {
            this.update(byArray[n2]);
            ++n2;
            --n3;
        }
        this.a.update(byArray, n2, n3);
        this.g += n3;
    }

    @Override
    public void reset() {
        this.a.reset();
        this.g = 0;
        this.a(this.f);
        if (this.i != null) {
            this.a(this.i);
        }
        this.i = null;
        this.h = false;
        if (this.j != null) {
            this.j = null;
            this.a(this.k);
            this.k = null;
        }
    }

    @Override
    public byte[] generateSignature() throws CryptoException {
        int n2;
        int n3 = this.a.getDigestSize();
        int n4 = 0;
        int n5 = 0;
        if (this.c == 188) {
            n4 = 8;
            n5 = this.e.length - n3 - 1;
            this.a.doFinal(this.e, n5);
            this.e[this.e.length - 1] = -68;
        } else {
            n4 = 16;
            n5 = this.e.length - n3 - 2;
            this.a.doFinal(this.e, n5);
            this.e[this.e.length - 2] = (byte)(this.c >>> 8);
            this.e[this.e.length - 1] = (byte)this.c;
        }
        int n6 = 0;
        int n7 = (n3 + this.g) * 8 + n4 + 4 - this.d;
        if (n7 > 0) {
            n2 = this.g - (n7 + 7) / 8;
            n6 = 96;
            System.arraycopy(this.f, 0, this.e, n5 -= n2, n2);
            this.i = new byte[n2];
        } else {
            n6 = 64;
            System.arraycopy(this.f, 0, this.e, n5 -= this.g, this.g);
            this.i = new byte[this.g];
        }
        if (n5 - 1 > 0) {
            for (n2 = n5 - 1; n2 != 0; --n2) {
                this.e[n2] = -69;
            }
            int n8 = n5 - 1;
            this.e[n8] = (byte)(this.e[n8] ^ 1);
            this.e[0] = 11;
            this.e[0] = (byte)(this.e[0] | n6);
        } else {
            this.e[0] = 10;
            this.e[0] = (byte)(this.e[0] | n6);
        }
        byte[] byArray = this.b.processBlock(this.e, 0, this.e.length);
        this.h = (n6 & 0x20) == 0;
        System.arraycopy(this.f, 0, this.i, 0, this.i.length);
        this.g = 0;
        this.a(this.f);
        this.a(this.e);
        return byArray;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        int n2;
        Object object;
        int n3;
        byte[] byArray2 = null;
        if (this.j == null) {
            try {
                byArray2 = this.b.processBlock(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            if (!Arrays.areEqual(this.j, byArray)) {
                throw new IllegalStateException("updateWithRecoveredMessage called on different signature");
            }
            byArray2 = this.k;
            this.j = null;
            this.k = null;
        }
        if ((byArray2[0] & 0xC0 ^ 0x40) != 0) {
            return this.b(byArray2);
        }
        if ((byArray2[byArray2.length - 1] & 0xF ^ 0xC) != 0) {
            return this.b(byArray2);
        }
        int n4 = 0;
        if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) == 0) {
            n4 = 1;
        } else {
            n3 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
            object = ISOTrailers.getTrailer(this.a);
            if (object != null) {
                n2 = object.intValue();
                if (n3 != n2 && (n2 != 15052 || n3 != 16588)) {
                    throw new IllegalStateException("signer initialised with wrong digest for trailer " + n3);
                }
            } else {
                throw new IllegalArgumentException("unrecognised hash in signature");
            }
            n4 = 2;
        }
        n3 = 0;
        for (n3 = 0; n3 != byArray2.length && (byArray2[n3] & 0xF ^ 0xA) != 0; ++n3) {
        }
        object = new byte[this.a.getDigestSize()];
        n2 = byArray2.length - n4 - ((byte[])object).length;
        if (n2 - ++n3 <= 0) {
            return this.b(byArray2);
        }
        if ((byArray2[0] & 0x20) == 0) {
            this.h = true;
            if (this.g > n2 - n3) {
                return this.b(byArray2);
            }
            this.a.reset();
            this.a.update(byArray2, n3, n2 - n3);
            this.a.doFinal((byte[])object, 0);
            boolean bl2 = true;
            for (int i2 = 0; i2 != ((Object)object).length; ++i2) {
                int n5 = n2 + i2;
                byArray2[n5] = (byte)(byArray2[n5] ^ object[i2]);
                if (byArray2[n2 + i2] == 0) continue;
                bl2 = false;
            }
            if (!bl2) {
                return this.b(byArray2);
            }
            this.i = new byte[n2 - n3];
            System.arraycopy(byArray2, n3, this.i, 0, this.i.length);
        } else {
            this.h = false;
            this.a.doFinal((byte[])object, 0);
            boolean bl3 = true;
            for (int i3 = 0; i3 != ((Object)object).length; ++i3) {
                int n6 = n2 + i3;
                byArray2[n6] = (byte)(byArray2[n6] ^ object[i3]);
                if (byArray2[n2 + i3] == 0) continue;
                bl3 = false;
            }
            if (!bl3) {
                return this.b(byArray2);
            }
            this.i = new byte[n2 - n3];
            System.arraycopy(byArray2, n3, this.i, 0, this.i.length);
        }
        if (this.g != 0 && !this.a(this.f, this.i)) {
            return this.b(byArray2);
        }
        this.a(this.f);
        this.a(byArray2);
        this.g = 0;
        return true;
    }

    private boolean b(byte[] byArray) {
        this.g = 0;
        this.a(this.f);
        this.a(byArray);
        return false;
    }

    @Override
    public boolean hasFullMessage() {
        return this.h;
    }

    @Override
    public byte[] getRecoveredMessage() {
        return this.i;
    }
}

