/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.signers;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.DigestInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.CryptoException;
import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.Signer;
import com.aspose.imaging.internal.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.RSABlindedEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Hashtable;

public class RSADigestSigner
implements Signer {
    private final AsymmetricBlockCipher a = new PKCS1Encoding(new RSABlindedEngine());
    private final AlgorithmIdentifier b;
    private final Digest c;
    private boolean d;
    private static final Hashtable e = new Hashtable();

    public RSADigestSigner(Digest digest) {
        this(digest, (ASN1ObjectIdentifier)e.get(digest.getAlgorithmName()));
    }

    public RSADigestSigner(Digest digest, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.c = digest;
        this.b = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
    }

    public String getAlgorithmName() {
        return this.c.getAlgorithmName() + "withRSA";
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.d = bl2;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl2 && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!bl2 && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        this.reset();
        this.a.init(bl2, cipherParameters);
    }

    @Override
    public void update(byte by2) {
        this.c.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.c.update(byArray, n2, n3);
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (!this.d) {
            throw new IllegalStateException("RSADigestSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.c.getDigestSize()];
        this.c.doFinal(byArray, 0);
        try {
            byte[] byArray2 = this.a(byArray);
            return this.a.processBlock(byArray2, 0, byArray2.length);
        }
        catch (IOException iOException) {
            throw new CryptoException("unable to encode signature: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        byte[] byArray2;
        byte[] byArray3;
        if (this.d) {
            throw new IllegalStateException("RSADigestSigner not initialised for verification");
        }
        byte[] byArray4 = new byte[this.c.getDigestSize()];
        this.c.doFinal(byArray4, 0);
        try {
            byArray3 = this.a.processBlock(byArray, 0, byArray.length);
            byArray2 = this.a(byArray4);
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray3.length == byArray2.length) {
            return Arrays.constantTimeAreEqual(byArray3, byArray2);
        }
        if (byArray3.length == byArray2.length - 2) {
            int n2;
            int n3 = byArray3.length - byArray4.length - 2;
            int n4 = byArray2.length - byArray4.length - 2;
            byArray2[1] = (byte)(byArray2[1] - 2);
            byArray2[3] = (byte)(byArray2[3] - 2);
            int n5 = 0;
            for (n2 = 0; n2 < byArray4.length; ++n2) {
                n5 |= byArray3[n3 + n2] ^ byArray2[n4 + n2];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                n5 |= byArray3[n2] ^ byArray2[n2];
            }
            return n5 == 0;
        }
        Arrays.constantTimeAreEqual(byArray2, byArray2);
        return false;
    }

    @Override
    public void reset() {
        this.c.reset();
    }

    private byte[] a(byte[] byArray) throws IOException {
        DigestInfo digestInfo = new DigestInfo(this.b, byArray);
        return digestInfo.getEncoded("DER");
    }

    static {
        e.put("RIPEMD128", TeleTrusTObjectIdentifiers.ripemd128);
        e.put("RIPEMD160", TeleTrusTObjectIdentifiers.ripemd160);
        e.put("RIPEMD256", TeleTrusTObjectIdentifiers.ripemd256);
        e.put("SHA-1", X509ObjectIdentifiers.id_SHA1);
        e.put("SHA-224", NISTObjectIdentifiers.id_sha224);
        e.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        e.put("SHA-384", NISTObjectIdentifiers.id_sha384);
        e.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        e.put("SHA-512/224", NISTObjectIdentifiers.id_sha512_224);
        e.put("SHA-512/256", NISTObjectIdentifiers.id_sha512_256);
        e.put("SHA3-224", NISTObjectIdentifiers.id_sha3_224);
        e.put("SHA3-256", NISTObjectIdentifiers.id_sha3_256);
        e.put("SHA3-384", NISTObjectIdentifiers.id_sha3_384);
        e.put("SHA3-512", NISTObjectIdentifiers.id_sha3_512);
        e.put("MD2", PKCSObjectIdentifiers.md2);
        e.put("MD4", PKCSObjectIdentifiers.md4);
        e.put("MD5", PKCSObjectIdentifiers.md5);
    }
}

