/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.tls;

import com.aspose.imaging.internal.bouncycastle.crypto.tls.AbstractTlsPeer;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.Certificate;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.CertificateRequest;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.CertificateStatus;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.MaxFragmentLength;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.NamedCurve;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.NewSessionTicket;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.ProtocolVersion;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.TlsCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.TlsCipherFactory;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.TlsCompression;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.TlsECCUtils;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.TlsExtensionsUtils;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.TlsFatalAlert;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.TlsNullCompression;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.TlsServer;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.TlsServerContext;
import com.aspose.imaging.internal.bouncycastle.crypto.tls.TlsUtils;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    protected TlsCipherFactory cipherFactory;
    protected TlsServerContext context;
    protected ProtocolVersion clientVersion;
    protected int[] offeredCipherSuites;
    protected short[] offeredCompressionMethods;
    protected Hashtable clientExtensions;
    protected boolean encryptThenMACOffered;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected Vector supportedSignatureAlgorithms;
    protected boolean eccCipherSuitesOffered;
    protected int[] namedCurves;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected ProtocolVersion serverVersion;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected Hashtable serverExtensions;

    public AbstractTlsServer() {
        this(new DefaultTlsCipherFactory());
    }

    public AbstractTlsServer(TlsCipherFactory tlsCipherFactory) {
        this.cipherFactory = tlsCipherFactory;
    }

    protected boolean allowEncryptThenMAC() {
        return true;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
        return this.serverExtensions;
    }

    protected abstract int[] getCipherSuites();

    protected short[] getCompressionMethods() {
        return new short[]{0};
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.TLSv11;
    }

    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    protected boolean supportsClientECCCapabilities(int[] nArray, short[] sArray) {
        if (nArray == null) {
            return TlsECCUtils.hasAnySupportedNamedCurves();
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (!NamedCurve.isValid(n2) || NamedCurve.refersToASpecificNamedCurve(n2) && !TlsECCUtils.isSupportedNamedCurve(n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void init(TlsServerContext tlsServerContext) {
        this.context = tlsServerContext;
    }

    @Override
    public void notifyClientVersion(ProtocolVersion protocolVersion) throws IOException {
        this.clientVersion = protocolVersion;
    }

    @Override
    public void notifyFallback(boolean bl2) throws IOException {
        if (bl2 && this.getMaximumVersion().isLaterVersionOf(this.clientVersion)) {
            throw new TlsFatalAlert(86);
        }
    }

    @Override
    public void notifyOfferedCipherSuites(int[] nArray) throws IOException {
        this.offeredCipherSuites = nArray;
        this.eccCipherSuitesOffered = TlsECCUtils.containsECCCipherSuites(this.offeredCipherSuites);
    }

    @Override
    public void notifyOfferedCompressionMethods(short[] sArray) throws IOException {
        this.offeredCompressionMethods = sArray;
    }

    @Override
    public void processClientExtensions(Hashtable hashtable) throws IOException {
        this.clientExtensions = hashtable;
        if (hashtable != null) {
            this.encryptThenMACOffered = TlsExtensionsUtils.hasEncryptThenMACExtension(hashtable);
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension(hashtable);
            if (this.maxFragmentLengthOffered >= 0 && !MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
                throw new TlsFatalAlert(47);
            }
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension(hashtable);
            this.supportedSignatureAlgorithms = TlsUtils.getSignatureAlgorithmsExtension(hashtable);
            if (this.supportedSignatureAlgorithms != null && !TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.clientVersion)) {
                throw new TlsFatalAlert(47);
            }
            this.namedCurves = TlsECCUtils.getSupportedEllipticCurvesExtension(hashtable);
            this.clientECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(hashtable);
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        if (this.getMinimumVersion().isEqualOrEarlierVersionOf(this.clientVersion)) {
            ProtocolVersion protocolVersion = this.getMaximumVersion();
            if (this.clientVersion.isEqualOrEarlierVersionOf(protocolVersion)) {
                this.serverVersion = this.clientVersion;
                return this.serverVersion;
            }
            if (this.clientVersion.isLaterVersionOf(protocolVersion)) {
                this.serverVersion = protocolVersion;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        Vector vector = TlsUtils.getUsableSignatureAlgorithms(this.supportedSignatureAlgorithms);
        boolean bl2 = this.supportsClientECCCapabilities(this.namedCurves, this.clientECPointFormats);
        int[] nArray = this.getCipherSuites();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (!Arrays.contains(this.offeredCipherSuites, n2) || !bl2 && TlsECCUtils.isECCCipherSuite(n2) || !TlsUtils.isValidCipherSuiteForVersion(n2, this.serverVersion) || !TlsUtils.isValidCipherSuiteForSignatureAlgorithms(n2, vector)) continue;
            this.selectedCipherSuite = n2;
            return this.selectedCipherSuite;
        }
        throw new TlsFatalAlert(40);
    }

    @Override
    public short getSelectedCompressionMethod() throws IOException {
        short[] sArray = this.getCompressionMethods();
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (!Arrays.contains(this.offeredCompressionMethods, sArray[i2])) continue;
            this.selectedCompressionMethod = sArray[i2];
            return this.selectedCompressionMethod;
        }
        throw new TlsFatalAlert(40);
    }

    @Override
    public Hashtable getServerExtensions() throws IOException {
        if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite(this.selectedCipherSuite)) {
            TlsExtensionsUtils.addEncryptThenMACExtension(this.checkServerExtensions());
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension(this.checkServerExtensions(), this.maxFragmentLengthOffered);
        }
        if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
            TlsExtensionsUtils.addTruncatedHMacExtension(this.checkServerExtensions());
        }
        if (this.clientECPointFormats != null && TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
            this.serverECPointFormats = new short[]{0, 1, 2};
            TlsECCUtils.addSupportedPointFormatsExtension(this.checkServerExtensions(), this.serverECPointFormats);
        }
        return this.serverExtensions;
    }

    @Override
    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    @Override
    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    @Override
    public void processClientSupplementalData(Vector vector) throws IOException {
        if (vector != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void notifyClientCertificate(Certificate certificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        int n2 = TlsUtils.getEncryptionAlgorithm(this.selectedCipherSuite);
        int n3 = TlsUtils.getMACAlgorithm(this.selectedCipherSuite);
        return this.cipherFactory.createCipher(this.context, n2, n3);
    }

    @Override
    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

