/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.est.jcajce;

import com.aspose.imaging.internal.bouncycastle.est.ESTClientProvider;
import com.aspose.imaging.internal.bouncycastle.est.ESTService;
import com.aspose.imaging.internal.bouncycastle.est.ESTServiceBuilder;
import com.aspose.imaging.internal.bouncycastle.est.jcajce.ChannelBindingProvider;
import com.aspose.imaging.internal.bouncycastle.est.jcajce.JcaJceUtils;
import com.aspose.imaging.internal.bouncycastle.est.jcajce.JsseDefaultHostnameAuthorizer;
import com.aspose.imaging.internal.bouncycastle.est.jcajce.JsseHostnameAuthorizer;
import com.aspose.imaging.internal.bouncycastle.est.jcajce.SSLSocketFactoryCreator;
import com.aspose.imaging.internal.bouncycastle.est.jcajce.c;
import com.aspose.imaging.internal.bouncycastle.est.jcajce.f;
import com.aspose.imaging.internal.bouncycastle.est.jcajce.h;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509TrustManager;

public class JsseESTServiceBuilder
extends ESTServiceBuilder {
    protected SSLSocketFactoryCreator socketFactoryCreator;
    protected JsseHostnameAuthorizer hostNameAuthorizer = new JsseDefaultHostnameAuthorizer(null);
    protected int timeoutMillis = 0;
    protected ChannelBindingProvider bindingProvider;
    protected Set<String> supportedSuites = new HashSet<String>();
    protected Long absoluteLimit;
    protected h sslSocketFactoryCreatorBuilder;
    protected boolean filterCipherSuites = true;

    public JsseESTServiceBuilder(String string, SSLSocketFactoryCreator sSLSocketFactoryCreator) {
        super(string);
        if (sSLSocketFactoryCreator == null) {
            throw new NullPointerException("No socket factory creator.");
        }
        this.socketFactoryCreator = sSLSocketFactoryCreator;
    }

    public JsseESTServiceBuilder(String string) {
        super(string);
        this.sslSocketFactoryCreatorBuilder = new h(JcaJceUtils.getTrustAllTrustManager());
    }

    public JsseESTServiceBuilder(String string, X509TrustManager x509TrustManager) {
        super(string);
        this.sslSocketFactoryCreatorBuilder = new h(x509TrustManager);
    }

    public JsseESTServiceBuilder(String string, X509TrustManager[] x509TrustManagerArray) {
        super(string);
        this.sslSocketFactoryCreatorBuilder = new h(x509TrustManagerArray);
    }

    public JsseESTServiceBuilder withHostNameAuthorizer(JsseHostnameAuthorizer jsseHostnameAuthorizer) {
        this.hostNameAuthorizer = jsseHostnameAuthorizer;
        return this;
    }

    @Override
    public JsseESTServiceBuilder withClientProvider(ESTClientProvider eSTClientProvider) {
        this.clientProvider = eSTClientProvider;
        return this;
    }

    public JsseESTServiceBuilder withTimeout(int n2) {
        this.timeoutMillis = n2;
        return this;
    }

    public JsseESTServiceBuilder withReadLimit(long l2) {
        this.absoluteLimit = l2;
        return this;
    }

    public JsseESTServiceBuilder withChannelBindingProvider(ChannelBindingProvider channelBindingProvider) {
        this.bindingProvider = channelBindingProvider;
        return this;
    }

    public JsseESTServiceBuilder addCipherSuites(String string) {
        this.supportedSuites.add(string);
        return this;
    }

    public JsseESTServiceBuilder addCipherSuites(String[] stringArray) {
        this.supportedSuites.addAll(Arrays.asList(stringArray));
        return this;
    }

    public JsseESTServiceBuilder withTLSVersion(String string) {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.a(string);
        return this;
    }

    public JsseESTServiceBuilder withSecureRandom(SecureRandom secureRandom) {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.a(secureRandom);
        return this;
    }

    public JsseESTServiceBuilder withProvider(String string) throws NoSuchProviderException {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.b(string);
        return this;
    }

    public JsseESTServiceBuilder withProvider(Provider provider) {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.a(provider);
        return this;
    }

    public JsseESTServiceBuilder withKeyManager(KeyManager keyManager) {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.a(keyManager);
        return this;
    }

    public JsseESTServiceBuilder withKeyManagers(KeyManager[] keyManagerArray) {
        if (this.socketFactoryCreator != null) {
            throw new IllegalStateException("Socket Factory Creator was defined in the constructor.");
        }
        this.sslSocketFactoryCreatorBuilder.a(keyManagerArray);
        return this;
    }

    public JsseESTServiceBuilder withFilterCipherSuites(boolean bl2) {
        this.filterCipherSuites = bl2;
        return this;
    }

    @Override
    public ESTService build() {
        if (this.bindingProvider == null) {
            this.bindingProvider = new f(this);
        }
        if (this.socketFactoryCreator == null) {
            this.socketFactoryCreator = this.sslSocketFactoryCreatorBuilder.a();
        }
        if (this.clientProvider == null) {
            this.clientProvider = new c(this.hostNameAuthorizer, this.socketFactoryCreator, this.timeoutMillis, this.bindingProvider, this.supportedSuites, this.absoluteLimit, this.filterCipherSuites);
        }
        return super.build();
    }
}

