/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.Selector;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;

public class PKIXCRLStoreSelector<T extends CRL>
implements Selector<T> {
    private final CRLSelector a;
    private final boolean b;
    private final boolean c;
    private final BigInteger d;
    private final byte[] e;
    private final boolean f;

    private PKIXCRLStoreSelector(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.d = builder.d;
        this.e = builder.e;
        this.f = builder.f;
    }

    public boolean isIssuingDistributionPointEnabled() {
        return this.f;
    }

    @Override
    public boolean match(CRL cRL) {
        byte[] byArray;
        if (!(cRL instanceof X509CRL)) {
            return this.a.match(cRL);
        }
        X509CRL x509CRL = (X509CRL)cRL;
        ASN1Integer aSN1Integer = null;
        try {
            byArray = x509CRL.getExtensionValue(Extension.deltaCRLIndicator.getId());
            if (byArray != null) {
                aSN1Integer = ASN1Integer.getInstance(ASN1OctetString.getInstance(byArray).getOctets());
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (this.isDeltaCRLIndicatorEnabled() && aSN1Integer == null) {
            return false;
        }
        if (this.isCompleteCRLEnabled() && aSN1Integer != null) {
            return false;
        }
        if (aSN1Integer != null && this.d != null && aSN1Integer.getPositiveValue().compareTo(this.d) == 1) {
            return false;
        }
        if (this.f) {
            byArray = x509CRL.getExtensionValue(Extension.issuingDistributionPoint.getId());
            if (this.e == null ? byArray != null : !Arrays.areEqual(byArray, this.e)) {
                return false;
            }
        }
        return this.a.match(cRL);
    }

    public boolean isDeltaCRLIndicatorEnabled() {
        return this.b;
    }

    @Override
    public Object clone() {
        return this;
    }

    public boolean isCompleteCRLEnabled() {
        return this.c;
    }

    public BigInteger getMaxBaseCRLNumber() {
        return this.d;
    }

    public byte[] getIssuingDistributionPoint() {
        return Arrays.clone(this.e);
    }

    public X509Certificate getCertificateChecking() {
        if (this.a instanceof X509CRLSelector) {
            return ((X509CRLSelector)this.a).getCertificateChecking();
        }
        return null;
    }

    public static Collection<? extends CRL> getCRLs(PKIXCRLStoreSelector pKIXCRLStoreSelector, CertStore certStore) throws CertStoreException {
        return certStore.getCRLs(new a(pKIXCRLStoreSelector));
    }

    /* synthetic */ PKIXCRLStoreSelector(Builder builder, com.aspose.imaging.internal.bouncycastle.jcajce.a a2) {
        this(builder);
    }

    public static class Builder {
        private final CRLSelector a;
        private boolean b = false;
        private boolean c = false;
        private BigInteger d = null;
        private byte[] e = null;
        private boolean f = false;

        public Builder(CRLSelector cRLSelector) {
            this.a = (CRLSelector)cRLSelector.clone();
        }

        public Builder setCompleteCRLEnabled(boolean bl2) {
            this.c = bl2;
            return this;
        }

        public Builder setDeltaCRLIndicatorEnabled(boolean bl2) {
            this.b = bl2;
            return this;
        }

        public void setMaxBaseCRLNumber(BigInteger bigInteger) {
            this.d = bigInteger;
        }

        public void setIssuingDistributionPointEnabled(boolean bl2) {
            this.f = bl2;
        }

        public void setIssuingDistributionPoint(byte[] byArray) {
            this.e = Arrays.clone(byArray);
        }

        public PKIXCRLStoreSelector<? extends CRL> build() {
            return new PKIXCRLStoreSelector(this, null);
        }
    }

    private static class a
    extends X509CRLSelector {
        private final PKIXCRLStoreSelector a;

        a(PKIXCRLStoreSelector pKIXCRLStoreSelector) {
            this.a = pKIXCRLStoreSelector;
            if (pKIXCRLStoreSelector.a instanceof X509CRLSelector) {
                X509CRLSelector x509CRLSelector = (X509CRLSelector)pKIXCRLStoreSelector.a;
                this.setCertificateChecking(x509CRLSelector.getCertificateChecking());
                this.setDateAndTime(x509CRLSelector.getDateAndTime());
                this.setIssuers(x509CRLSelector.getIssuers());
                this.setMinCRLNumber(x509CRLSelector.getMinCRL());
                this.setMaxCRLNumber(x509CRLSelector.getMaxCRL());
            }
        }

        @Override
        public boolean match(CRL cRL) {
            return this.a == null ? cRL != null : this.a.match(cRL);
        }
    }
}

