/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.dh;

import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.imaging.internal.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.generators.DHParametersGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DHParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPrivateKey;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPublicKey;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import com.aspose.imaging.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.imaging.internal.bouncycastle.util.Integers;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable a = new Hashtable();
    private static Object b = new Object();
    DHKeyGenerationParameters param;
    DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
    int strength = 2048;
    SecureRandom random = new SecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DH");
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        this.strength = n2;
        this.random = secureRandom;
        this.initialised = false;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
        }
        DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
        try {
            this.param = new DHKeyGenerationParameters(secureRandom, new DHParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), null, dHParameterSpec.getL()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        Object object3;
        if (!this.initialised) {
            object3 = Integers.valueOf(this.strength);
            if (a.containsKey(object3)) {
                this.param = (DHKeyGenerationParameters)a.get(object3);
            } else {
                object2 = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters(this.strength);
                if (object2 != null) {
                    this.param = new DHKeyGenerationParameters(this.random, new DHParameters(((DHParameterSpec)object2).getP(), ((DHParameterSpec)object2).getG(), null, ((DHParameterSpec)object2).getL()));
                } else {
                    object = b;
                    synchronized (object) {
                        if (a.containsKey(object3)) {
                            this.param = (DHKeyGenerationParameters)a.get(object3);
                        } else {
                            DHParametersGenerator dHParametersGenerator = new DHParametersGenerator();
                            dHParametersGenerator.init(this.strength, PrimeCertaintyCalculator.getDefaultCertainty(this.strength), this.random);
                            this.param = new DHKeyGenerationParameters(this.random, dHParametersGenerator.generateParameters());
                            a.put(object3, this.param);
                        }
                    }
                }
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        object3 = this.engine.generateKeyPair();
        object2 = (DHPublicKeyParameters)((AsymmetricCipherKeyPair)object3).getPublic();
        object = (DHPrivateKeyParameters)((AsymmetricCipherKeyPair)object3).getPrivate();
        return new KeyPair(new BCDHPublicKey((DHPublicKeyParameters)object2), new BCDHPrivateKey((DHPrivateKeyParameters)object));
    }
}

