/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.ecgost12;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.aspose.imaging.internal.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X962Parameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.aspose.imaging.internal.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.aspose.imaging.internal.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPointEncoder;
import com.aspose.imaging.internal.bouncycastle.jce.interfaces.ECPublicKey;
import com.aspose.imaging.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.imaging.internal.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.aspose.imaging.internal.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;

public class BCECGOST3410_2012PublicKey
implements ECPointEncoder,
ECPublicKey,
java.security.interfaces.ECPublicKey {
    static final long serialVersionUID = 7026240464295649314L;
    private String a = "ECGOST3410-2012";
    private boolean b;
    private transient ECPublicKeyParameters c;
    private transient ECParameterSpec d;
    private transient GOST3410PublicKeyAlgParameters e;

    public BCECGOST3410_2012PublicKey(BCECGOST3410_2012PublicKey bCECGOST3410_2012PublicKey) {
        this.c = bCECGOST3410_2012PublicKey.c;
        this.d = bCECGOST3410_2012PublicKey.d;
        this.b = bCECGOST3410_2012PublicKey.b;
        this.e = bCECGOST3410_2012PublicKey.e;
    }

    public BCECGOST3410_2012PublicKey(ECPublicKeySpec eCPublicKeySpec) {
        this.d = eCPublicKeySpec.getParams();
        this.c = new ECPublicKeyParameters(EC5Util.convertPoint(this.d, eCPublicKeySpec.getW(), false), EC5Util.getDomainParameters(null, eCPublicKeySpec.getParams()));
    }

    public BCECGOST3410_2012PublicKey(com.aspose.imaging.internal.bouncycastle.jce.spec.ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        if (eCPublicKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPublicKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPublicKeySpec.getParams().getSeed());
            this.c = new ECPublicKeyParameters(eCPublicKeySpec.getQ(), ECUtil.getDomainParameters(providerConfiguration, eCPublicKeySpec.getParams()));
            this.d = EC5Util.convertSpec(ellipticCurve, eCPublicKeySpec.getParams());
        } else {
            com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = providerConfiguration.getEcImplicitlyCa();
            this.c = new ECPublicKeyParameters(eCParameterSpec.getCurve().createPoint(eCPublicKeySpec.getQ().getAffineXCoord().toBigInteger(), eCPublicKeySpec.getQ().getAffineYCoord().toBigInteger()), EC5Util.getDomainParameters(providerConfiguration, null));
            this.d = null;
        }
    }

    public BCECGOST3410_2012PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.a = string;
        this.c = eCPublicKeyParameters;
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = this.a(ellipticCurve, eCDomainParameters);
        } else {
            this.d = eCParameterSpec;
        }
    }

    public BCECGOST3410_2012PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.a = string;
        this.c = eCPublicKeyParameters;
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = this.a(ellipticCurve, eCDomainParameters);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            this.d = EC5Util.convertSpec(ellipticCurve, eCParameterSpec);
        }
    }

    public BCECGOST3410_2012PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters) {
        this.a = string;
        this.c = eCPublicKeyParameters;
        this.d = null;
    }

    private ECParameterSpec a(EllipticCurve ellipticCurve, ECDomainParameters eCDomainParameters) {
        return new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
    }

    public BCECGOST3410_2012PublicKey(java.security.interfaces.ECPublicKey eCPublicKey) {
        this.a = eCPublicKey.getAlgorithm();
        this.d = eCPublicKey.getParams();
        this.c = new ECPublicKeyParameters(EC5Util.convertPoint(this.d, eCPublicKey.getW(), false), EC5Util.getDomainParameters(null, eCPublicKey.getParams()));
    }

    BCECGOST3410_2012PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.a(subjectPublicKeyInfo);
    }

    private void a(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1OctetString aSN1OctetString;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
        this.a = "ECGOST3410-2012";
        try {
            aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(dERBitString.getBytes());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error recovering public key");
        }
        byte[] byArray = aSN1OctetString.getOctets();
        int n2 = 32;
        if (aSN1ObjectIdentifier.equals(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512)) {
            n2 = 64;
        }
        int n3 = 2 * n2;
        byte[] byArray2 = new byte[1 + n3];
        byArray2[0] = 4;
        for (int i2 = 1; i2 <= n2; ++i2) {
            byArray2[i2] = byArray[n2 - i2];
            byArray2[i2 + n2] = byArray[n3 - i2];
        }
        this.e = GOST3410PublicKeyAlgParameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.e.getPublicKeyParamSet()));
        ECCurve eCCurve = eCNamedCurveParameterSpec.getCurve();
        EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCNamedCurveParameterSpec.getSeed());
        this.c = new ECPublicKeyParameters(eCCurve.decodePoint(byArray2), ECUtil.getDomainParameters(null, eCNamedCurveParameterSpec));
        this.d = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName(this.e.getPublicKeyParamSet()), ellipticCurve, EC5Util.convertPoint(eCNamedCurveParameterSpec.getG()), eCNamedCurveParameterSpec.getN(), eCNamedCurveParameterSpec.getH());
    }

    @Override
    public String getAlgorithm() {
        return this.a;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        int n2;
        int n3;
        BigInteger bigInteger = this.c.getQ().getAffineXCoord().toBigInteger();
        BigInteger bigInteger2 = this.c.getQ().getAffineYCoord().toBigInteger();
        boolean bl2 = bigInteger.bitLength() > 256;
        ASN1Object aSN1Object = this.getGostParams();
        if (aSN1Object == null) {
            if (this.d instanceof ECNamedCurveSpec) {
                aSN1Object = bl2 ? new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.d).getName()), RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512) : new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.d).getName()), RosstandartObjectIdentifiers.id_tc26_gost_3411_12_256);
            } else {
                ECCurve eCCurve = EC5Util.convertCurve(this.d.getCurve());
                X9ECParameters x9ECParameters = new X9ECParameters(eCCurve, EC5Util.convertPoint(eCCurve, this.d.getGenerator(), this.b), this.d.getOrder(), BigInteger.valueOf(this.d.getCofactor()), this.d.getCurve().getSeed());
                aSN1Object = new X962Parameters(x9ECParameters);
            }
        }
        if (bl2) {
            n3 = 128;
            n2 = 64;
            aSN1ObjectIdentifier = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512;
        } else {
            n3 = 64;
            n2 = 32;
            aSN1ObjectIdentifier = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256;
        }
        byte[] byArray = new byte[n3];
        this.a(byArray, n3 / 2, 0, bigInteger);
        this.a(byArray, n3 / 2, n2, bigInteger2);
        try {
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier, aSN1Object), new DEROctetString(byArray));
        }
        catch (IOException iOException) {
            return null;
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo(subjectPublicKeyInfo);
    }

    private void a(byte[] byArray, int n2, int n3, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < n2) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i2 = 0; i2 != n2; ++i2) {
            byArray[n3 + i2] = byArray2[byArray2.length - 1 - i2];
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.d;
    }

    @Override
    public com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        if (this.d == null) {
            return null;
        }
        return EC5Util.convertSpec(this.d, this.b);
    }

    @Override
    public ECPoint getW() {
        return EC5Util.convertPoint(this.c.getQ());
    }

    @Override
    public com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint getQ() {
        if (this.d == null) {
            return this.c.getQ().getDetachedPoint();
        }
        return this.c.getQ();
    }

    ECPublicKeyParameters engineGetKeyParameters() {
        return this.c;
    }

    com.aspose.imaging.internal.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.d != null) {
            return EC5Util.convertSpec(this.d, this.b);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public String toString() {
        return ECUtil.publicKeyToString(this.a, this.c.getQ(), this.engineGetSpec());
    }

    @Override
    public void setPointFormat(String string) {
        this.b = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECGOST3410_2012PublicKey)) {
            return false;
        }
        BCECGOST3410_2012PublicKey bCECGOST3410_2012PublicKey = (BCECGOST3410_2012PublicKey)object;
        return this.c.getQ().equals(bCECGOST3410_2012PublicKey.c.getQ()) && this.engineGetSpec().equals(bCECGOST3410_2012PublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.c.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.a(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    public GOST3410PublicKeyAlgParameters getGostParams() {
        if (this.e == null && this.d instanceof ECNamedCurveSpec) {
            BigInteger bigInteger = this.c.getQ().getAffineXCoord().toBigInteger();
            boolean bl2 = bigInteger.bitLength() > 256;
            this.e = bl2 ? new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.d).getName()), RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512) : new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.d).getName()), RosstandartObjectIdentifiers.id_tc26_gost_3411_12_256);
        }
        return this.e;
    }
}

