/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jce;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.CertificationRequest;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.aspose.imaging.internal.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.X509Name;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.jce.X509Principal;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PSSParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class PKCS10CertificationRequest
extends CertificationRequest {
    private static Hashtable a = new Hashtable();
    private static Hashtable b = new Hashtable();
    private static Hashtable c = new Hashtable();
    private static Hashtable d = new Hashtable();
    private static Set e = new HashSet();

    private static RSASSAPSSparams a(AlgorithmIdentifier algorithmIdentifier, int n2) {
        return new RSASSAPSSparams(algorithmIdentifier, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier), new ASN1Integer(n2), new ASN1Integer(1L));
    }

    private static ASN1Sequence a(byte[] byArray) {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            return (ASN1Sequence)aSN1InputStream.readObject();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("badly encoded request");
        }
    }

    public PKCS10CertificationRequest(byte[] byArray) {
        super(PKCS10CertificationRequest.a(byArray));
    }

    public PKCS10CertificationRequest(ASN1Sequence aSN1Sequence) {
        super(aSN1Sequence);
    }

    public PKCS10CertificationRequest(String string, X509Name x509Name, PublicKey publicKey, ASN1Set aSN1Set, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(string, x509Name, publicKey, aSN1Set, privateKey, "BC");
    }

    private static X509Name a(X500Principal x500Principal) {
        try {
            return new X509Principal(x500Principal.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't convert name");
        }
    }

    public PKCS10CertificationRequest(String string, X500Principal x500Principal, PublicKey publicKey, ASN1Set aSN1Set, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(string, PKCS10CertificationRequest.a(x500Principal), publicKey, aSN1Set, privateKey, "BC");
    }

    public PKCS10CertificationRequest(String string, X500Principal x500Principal, PublicKey publicKey, ASN1Set aSN1Set, PrivateKey privateKey, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(string, PKCS10CertificationRequest.a(x500Principal), publicKey, aSN1Set, privateKey, string2);
    }

    public PKCS10CertificationRequest(String string, X509Name x509Name, PublicKey publicKey, ASN1Set aSN1Set, PrivateKey privateKey, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Object object;
        String string3 = Strings.toUpperCase(string);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)a.get(string3);
        if (aSN1ObjectIdentifier == null) {
            try {
                aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string3);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Unknown signature type requested");
            }
        }
        if (x509Name == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        this.sigAlgId = e.contains(aSN1ObjectIdentifier) ? new AlgorithmIdentifier(aSN1ObjectIdentifier) : (b.containsKey(string3) ? new AlgorithmIdentifier(aSN1ObjectIdentifier, (ASN1Encodable)b.get(string3)) : new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE));
        try {
            object = (ASN1Sequence)ASN1Primitive.fromByteArray(publicKey.getEncoded());
            this.reqInfo = new CertificationRequestInfo(x509Name, SubjectPublicKeyInfo.getInstance(object), aSN1Set);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't encode public key");
        }
        object = string2 == null ? Signature.getInstance(string) : Signature.getInstance(string, string2);
        ((Signature)object).initSign(privateKey);
        try {
            ((Signature)object).update(this.reqInfo.getEncoded("DER"));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("exception encoding TBS cert request - " + exception);
        }
        this.sigBits = new DERBitString(((Signature)object).sign());
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        return this.getPublicKey("BC");
    }

    public PublicKey getPublicKey(String string) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.reqInfo.getSubjectPublicKeyInfo();
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(new DERBitString(subjectPublicKeyInfo).getOctets());
            AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
            try {
                if (string == null) {
                    return KeyFactory.getInstance(algorithmIdentifier.getAlgorithm().getId()).generatePublic(x509EncodedKeySpec);
                }
                return KeyFactory.getInstance(algorithmIdentifier.getAlgorithm().getId(), string).generatePublic(x509EncodedKeySpec);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (c.get(algorithmIdentifier.getAlgorithm()) != null) {
                    String string2 = (String)c.get(algorithmIdentifier.getAlgorithm());
                    if (string == null) {
                        return KeyFactory.getInstance(string2).generatePublic(x509EncodedKeySpec);
                    }
                    return KeyFactory.getInstance(string2, string).generatePublic(x509EncodedKeySpec);
                }
                throw noSuchAlgorithmException;
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("error decoding public key");
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("error decoding public key");
        }
    }

    public boolean verify() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        return this.verify("BC");
    }

    public boolean verify(String string) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        return this.verify(this.getPublicKey(string), string);
    }

    public boolean verify(PublicKey publicKey, String string) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature signature;
        try {
            signature = string == null ? Signature.getInstance(PKCS10CertificationRequest.getSignatureName(this.sigAlgId)) : Signature.getInstance(PKCS10CertificationRequest.getSignatureName(this.sigAlgId), string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (d.get(this.sigAlgId.getAlgorithm()) != null) {
                String string2 = (String)d.get(this.sigAlgId.getAlgorithm());
                signature = string == null ? Signature.getInstance(string2) : Signature.getInstance(string2, string);
            }
            throw noSuchAlgorithmException;
        }
        this.a(signature, this.sigAlgId.getParameters());
        signature.initVerify(publicKey);
        try {
            signature.update(this.reqInfo.getEncoded("DER"));
        }
        catch (Exception exception) {
            throw new SignatureException("exception encoding TBS cert request - " + exception);
        }
        return signature.verify(this.sigBits.getOctets());
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void a(Signature signature, ASN1Encodable aSN1Encodable) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (aSN1Encodable != null && !DERNull.INSTANCE.equals(aSN1Encodable)) {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(signature.getAlgorithm(), signature.getProvider());
            try {
                algorithmParameters.init(aSN1Encodable.toASN1Primitive().getEncoded("DER"));
            }
            catch (IOException iOException) {
                throw new SignatureException("IOException decoding parameters: " + iOException.getMessage());
            }
            if (signature.getAlgorithm().endsWith("MGF1")) {
                try {
                    signature.setParameter(algorithmParameters.getParameterSpec(PSSParameterSpec.class));
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new SignatureException("Exception extracting parameters: " + generalSecurityException.getMessage());
                }
            }
        }
    }

    static String getSignatureName(AlgorithmIdentifier algorithmIdentifier) {
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        if (aSN1Encodable != null && !DERNull.INSTANCE.equals(aSN1Encodable) && algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            RSASSAPSSparams rSASSAPSSparams = RSASSAPSSparams.getInstance(aSN1Encodable);
            return PKCS10CertificationRequest.a(rSASSAPSSparams.getHashAlgorithm().getAlgorithm()) + "withRSAandMGF1";
        }
        return algorithmIdentifier.getAlgorithm().getId();
    }

    private static String a(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (PKCSObjectIdentifiers.md5.equals(aSN1ObjectIdentifier)) {
            return "MD5";
        }
        if (OIWObjectIdentifiers.idSHA1.equals(aSN1ObjectIdentifier)) {
            return "SHA1";
        }
        if (NISTObjectIdentifiers.id_sha224.equals(aSN1ObjectIdentifier)) {
            return "SHA224";
        }
        if (NISTObjectIdentifiers.id_sha256.equals(aSN1ObjectIdentifier)) {
            return "SHA256";
        }
        if (NISTObjectIdentifiers.id_sha384.equals(aSN1ObjectIdentifier)) {
            return "SHA384";
        }
        if (NISTObjectIdentifiers.id_sha512.equals(aSN1ObjectIdentifier)) {
            return "SHA512";
        }
        if (TeleTrusTObjectIdentifiers.ripemd128.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD128";
        }
        if (TeleTrusTObjectIdentifiers.ripemd160.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD160";
        }
        if (TeleTrusTObjectIdentifiers.ripemd256.equals(aSN1ObjectIdentifier)) {
            return "RIPEMD256";
        }
        if (CryptoProObjectIdentifiers.gostR3411.equals(aSN1ObjectIdentifier)) {
            return "GOST3411";
        }
        return aSN1ObjectIdentifier.getId();
    }

    static {
        a.put("MD2WITHRSAENCRYPTION", new ASN1ObjectIdentifier("1.2.840.113549.1.1.2"));
        a.put("MD2WITHRSA", new ASN1ObjectIdentifier("1.2.840.113549.1.1.2"));
        a.put("MD5WITHRSAENCRYPTION", new ASN1ObjectIdentifier("1.2.840.113549.1.1.4"));
        a.put("MD5WITHRSA", new ASN1ObjectIdentifier("1.2.840.113549.1.1.4"));
        a.put("RSAWITHMD5", new ASN1ObjectIdentifier("1.2.840.113549.1.1.4"));
        a.put("SHA1WITHRSAENCRYPTION", new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"));
        a.put("SHA1WITHRSA", new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"));
        a.put("SHA224WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        a.put("SHA224WITHRSA", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        a.put("SHA256WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        a.put("SHA256WITHRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        a.put("SHA384WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        a.put("SHA384WITHRSA", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        a.put("SHA512WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        a.put("SHA512WITHRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        a.put("SHA1WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        a.put("SHA224WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        a.put("SHA256WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        a.put("SHA384WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        a.put("SHA512WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        a.put("RSAWITHSHA1", new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"));
        a.put("RIPEMD128WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        a.put("RIPEMD128WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        a.put("RIPEMD160WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        a.put("RIPEMD160WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        a.put("RIPEMD256WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        a.put("RIPEMD256WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        a.put("SHA1WITHDSA", new ASN1ObjectIdentifier("1.2.840.10040.4.3"));
        a.put("DSAWITHSHA1", new ASN1ObjectIdentifier("1.2.840.10040.4.3"));
        a.put("SHA224WITHDSA", NISTObjectIdentifiers.dsa_with_sha224);
        a.put("SHA256WITHDSA", NISTObjectIdentifiers.dsa_with_sha256);
        a.put("SHA384WITHDSA", NISTObjectIdentifiers.dsa_with_sha384);
        a.put("SHA512WITHDSA", NISTObjectIdentifiers.dsa_with_sha512);
        a.put("SHA1WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA1);
        a.put("SHA224WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA224);
        a.put("SHA256WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA256);
        a.put("SHA384WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA384);
        a.put("SHA512WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA512);
        a.put("ECDSAWITHSHA1", X9ObjectIdentifiers.ecdsa_with_SHA1);
        a.put("GOST3411WITHGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        a.put("GOST3410WITHGOST3411", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        a.put("GOST3411WITHECGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        a.put("GOST3411WITHECGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        a.put("GOST3411WITHGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        d.put(new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"), "SHA1WITHRSA");
        d.put(PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224WITHRSA");
        d.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA");
        d.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WITHRSA");
        d.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA");
        d.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, "GOST3411WITHGOST3410");
        d.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, "GOST3411WITHECGOST3410");
        d.put(new ASN1ObjectIdentifier("1.2.840.113549.1.1.4"), "MD5WITHRSA");
        d.put(new ASN1ObjectIdentifier("1.2.840.113549.1.1.2"), "MD2WITHRSA");
        d.put(new ASN1ObjectIdentifier("1.2.840.10040.4.3"), "SHA1WITHDSA");
        d.put(X9ObjectIdentifiers.ecdsa_with_SHA1, "SHA1WITHECDSA");
        d.put(X9ObjectIdentifiers.ecdsa_with_SHA224, "SHA224WITHECDSA");
        d.put(X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256WITHECDSA");
        d.put(X9ObjectIdentifiers.ecdsa_with_SHA384, "SHA384WITHECDSA");
        d.put(X9ObjectIdentifiers.ecdsa_with_SHA512, "SHA512WITHECDSA");
        d.put(OIWObjectIdentifiers.sha1WithRSA, "SHA1WITHRSA");
        d.put(OIWObjectIdentifiers.dsaWithSHA1, "SHA1WITHDSA");
        d.put(NISTObjectIdentifiers.dsa_with_sha224, "SHA224WITHDSA");
        d.put(NISTObjectIdentifiers.dsa_with_sha256, "SHA256WITHDSA");
        c.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        c.put(X9ObjectIdentifiers.id_dsa, "DSA");
        e.add(X9ObjectIdentifiers.ecdsa_with_SHA1);
        e.add(X9ObjectIdentifiers.ecdsa_with_SHA224);
        e.add(X9ObjectIdentifiers.ecdsa_with_SHA256);
        e.add(X9ObjectIdentifiers.ecdsa_with_SHA384);
        e.add(X9ObjectIdentifiers.ecdsa_with_SHA512);
        e.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        e.add(NISTObjectIdentifiers.dsa_with_sha224);
        e.add(NISTObjectIdentifiers.dsa_with_sha256);
        e.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        e.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
        b.put("SHA1WITHRSAANDMGF1", PKCS10CertificationRequest.a(algorithmIdentifier, 20));
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha224, DERNull.INSTANCE);
        b.put("SHA224WITHRSAANDMGF1", PKCS10CertificationRequest.a(algorithmIdentifier2, 28));
        AlgorithmIdentifier algorithmIdentifier3 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE);
        b.put("SHA256WITHRSAANDMGF1", PKCS10CertificationRequest.a(algorithmIdentifier3, 32));
        AlgorithmIdentifier algorithmIdentifier4 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, DERNull.INSTANCE);
        b.put("SHA384WITHRSAANDMGF1", PKCS10CertificationRequest.a(algorithmIdentifier4, 48));
        AlgorithmIdentifier algorithmIdentifier5 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, DERNull.INSTANCE);
        b.put("SHA512WITHRSAANDMGF1", PKCS10CertificationRequest.a(algorithmIdentifier5, 64));
    }
}

