/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jce.provider;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.util.encoders.Base64;
import java.io.IOException;
import java.io.InputStream;

public class PEMUtil {
    private final String a;
    private final String b;
    private final String c;
    private final String d;

    PEMUtil(String string) {
        this.a = "-----BEGIN " + string + "-----";
        this.b = "-----BEGIN X509 " + string + "-----";
        this.c = "-----END " + string + "-----";
        this.d = "-----END X509 " + string + "-----";
    }

    private String a(InputStream inputStream) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if ((n2 = inputStream.read()) != 13 && n2 != 10 && n2 >= 0) {
                if (n2 == 13) continue;
                stringBuffer.append((char)n2);
                continue;
            }
            if (n2 < 0 || stringBuffer.length() != 0) break;
        }
        if (n2 < 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    ASN1Sequence readPEMObject(InputStream inputStream) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.a(inputStream)) != null && !string.startsWith(this.a) && !string.startsWith(this.b)) {
        }
        while ((string = this.a(inputStream)) != null && !string.startsWith(this.c) && !string.startsWith(this.d)) {
            stringBuffer.append(string);
        }
        if (stringBuffer.length() != 0) {
            ASN1Primitive aSN1Primitive = new ASN1InputStream(Base64.decode(stringBuffer.toString())).readObject();
            if (!(aSN1Primitive instanceof ASN1Sequence)) {
                throw new IOException("malformed PEM data encountered");
            }
            return (ASN1Sequence)aSN1Primitive;
        }
        return null;
    }
}

