/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.jce.provider;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Enumerated;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.util.ASN1Dump;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.CRLReason;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.GeneralNames;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.TBSCertList;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.X509Extension;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CRLEntryObject
extends X509CRLEntry {
    private TBSCertList.CRLEntry a;
    private X500Name b;
    private int c;
    private boolean d;

    public X509CRLEntryObject(TBSCertList.CRLEntry cRLEntry) {
        this.a = cRLEntry;
        this.b = null;
    }

    public X509CRLEntryObject(TBSCertList.CRLEntry cRLEntry, boolean bl2, X500Name x500Name) {
        this.a = cRLEntry;
        this.b = this.a(bl2, x500Name);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        return set != null && !set.isEmpty();
    }

    private X500Name a(boolean bl2, X500Name x500Name) {
        if (!bl2) {
            return null;
        }
        Extension extension = this.a(Extension.certificateIssuer);
        if (extension == null) {
            return x500Name;
        }
        try {
            GeneralName[] generalNameArray = GeneralNames.getInstance(extension.getParsedValue()).getNames();
            for (int i2 = 0; i2 < generalNameArray.length; ++i2) {
                if (generalNameArray[i2].getTagNo() != 4) continue;
                return X500Name.getInstance(generalNameArray[i2].getName());
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public X500Principal getCertificateIssuer() {
        if (this.b == null) {
            return null;
        }
        try {
            return new X500Principal(this.b.getEncoded());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Set a(boolean bl2) {
        Extensions extensions = this.a.getExtensions();
        if (extensions != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = extensions.oids();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
                if (bl2 != extension.isCritical()) continue;
                hashSet.add(aSN1ObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.a(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.a(false);
    }

    private Extension a(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Extensions extensions = this.a.getExtensions();
        if (extensions != null) {
            return extensions.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    @Override
    public byte[] getExtensionValue(String string) {
        Extension extension = this.a(new ASN1ObjectIdentifier(string));
        if (extension != null) {
            try {
                return extension.getExtnValue().getEncoded();
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        if (!this.d) {
            this.c = super.hashCode();
            this.d = true;
        }
        return this.c;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof X509CRLEntryObject) {
            X509CRLEntryObject x509CRLEntryObject = (X509CRLEntryObject)object;
            return this.a.equals(x509CRLEntryObject.a);
        }
        return super.equals(this);
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        try {
            return this.a.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.a.getUserCertificate().getValue();
    }

    @Override
    public Date getRevocationDate() {
        return this.a.getRevocationDate().getDate();
    }

    @Override
    public boolean hasExtensions() {
        return this.a.getExtensions() != null;
    }

    @Override
    public String toString() {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("      userCertificate: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("       revocationDate: ").append(this.getRevocationDate()).append(string);
        stringBuffer.append("       certificateIssuer: ").append(this.getCertificateIssuer()).append(string);
        Extensions extensions = this.a.getExtensions();
        if (extensions != null && (enumeration = extensions.oids()).hasMoreElements()) {
            stringBuffer.append("   crlEntryExtensions:").append(string);
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
                if (extension.getExtnValue() != null) {
                    byte[] byArray = extension.getExtnValue().getOctets();
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
                    stringBuffer.append("                       critical(").append(extension.isCritical()).append(") ");
                    try {
                        if (aSN1ObjectIdentifier.equals(X509Extension.reasonCode)) {
                            stringBuffer.append(CRLReason.getInstance(ASN1Enumerated.getInstance(aSN1InputStream.readObject()))).append(string);
                            continue;
                        }
                        if (aSN1ObjectIdentifier.equals(X509Extension.certificateIssuer)) {
                            stringBuffer.append("Certificate issuer: ").append(GeneralNames.getInstance(aSN1InputStream.readObject())).append(string);
                            continue;
                        }
                        stringBuffer.append(aSN1ObjectIdentifier.getId());
                        stringBuffer.append(" value = ").append(ASN1Dump.dumpAsString(aSN1InputStream.readObject())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(aSN1ObjectIdentifier.getId());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }
}

