/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.math.field;

import com.aspose.imaging.internal.bouncycastle.math.field.FiniteField;
import com.aspose.imaging.internal.bouncycastle.math.field.PolynomialExtensionField;
import com.aspose.imaging.internal.bouncycastle.math.field.a;
import com.aspose.imaging.internal.bouncycastle.math.field.b;
import com.aspose.imaging.internal.bouncycastle.math.field.c;
import java.math.BigInteger;

public abstract class FiniteFields {
    static final FiniteField GF_2 = new c(BigInteger.valueOf(2L));
    static final FiniteField GF_3 = new c(BigInteger.valueOf(3L));

    public static PolynomialExtensionField getBinaryExtensionField(int[] nArray) {
        if (nArray[0] != 0) {
            throw new IllegalArgumentException("Irreducible polynomials in GF(2) must have constant term");
        }
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] > nArray[i2 - 1]) continue;
            throw new IllegalArgumentException("Polynomial exponents must be montonically increasing");
        }
        return new b(GF_2, new a(nArray));
    }

    public static FiniteField getPrimeField(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength();
        if (bigInteger.signum() <= 0 || n2 < 2) {
            throw new IllegalArgumentException("'characteristic' must be >= 2");
        }
        if (n2 < 3) {
            switch (bigInteger.intValue()) {
                case 2: {
                    return GF_2;
                }
                case 3: {
                    return GF_3;
                }
            }
        }
        return new c(bigInteger);
    }
}

