/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.openssl.bc;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.PBEParametersGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.digests.SHA1Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.AESEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.BlowfishEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.DESEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.DESedeEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.RC2Engine;
import com.aspose.imaging.internal.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CFBBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.OFBBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.PKCS7Padding;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RC2Parameters;
import com.aspose.imaging.internal.bouncycastle.openssl.EncryptionException;
import com.aspose.imaging.internal.bouncycastle.openssl.PEMException;
import com.aspose.imaging.internal.bouncycastle.util.Integers;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class b {
    private static final Map a = new HashMap();
    private static final Set b = new HashSet();
    private static final Set c = new HashSet();

    b() {
    }

    static int a(String string) {
        if (!a.containsKey(string)) {
            throw new IllegalStateException("no key size for algorithm: " + string);
        }
        return (Integer)a.get(string);
    }

    static boolean a(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return b.contains(aSN1ObjectIdentifier);
    }

    static boolean b(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return c.contains(aSN1ObjectIdentifier);
    }

    public static boolean c(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return aSN1ObjectIdentifier.getId().startsWith(PKCSObjectIdentifiers.pkcs_12PbeIds.getId());
    }

    public static KeyParameter a(String string, char[] cArray, byte[] byArray, int n2) {
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator(new SHA1Digest());
        pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray, n2);
        return (KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(com.aspose.imaging.internal.bouncycastle.openssl.bc.b.a(string));
    }

    static byte[] a(boolean bl2, byte[] byArray, char[] cArray, String string, byte[] byArray2) throws PEMException {
        BlockCipher blockCipher;
        KeyParameter keyParameter;
        byte[] byArray3 = byArray2;
        String string2 = "CBC";
        PKCS7Padding pKCS7Padding = new PKCS7Padding();
        if (string.endsWith("-CFB")) {
            string2 = "CFB";
            pKCS7Padding = null;
        }
        if (string.endsWith("-ECB") || "DES-EDE".equals(string) || "DES-EDE3".equals(string)) {
            string2 = "ECB";
            byArray3 = null;
        }
        if (string.endsWith("-OFB")) {
            string2 = "OFB";
            pKCS7Padding = null;
        }
        if (string.startsWith("DES-EDE")) {
            boolean bl3 = !string.startsWith("DES-EDE3");
            keyParameter = com.aspose.imaging.internal.bouncycastle.openssl.bc.b.a(cArray, 24, byArray2, bl3);
            blockCipher = new DESedeEngine();
        } else if (string.startsWith("DES-")) {
            keyParameter = com.aspose.imaging.internal.bouncycastle.openssl.bc.b.a(cArray, 8, byArray2);
            blockCipher = new DESEngine();
        } else if (string.startsWith("BF-")) {
            keyParameter = com.aspose.imaging.internal.bouncycastle.openssl.bc.b.a(cArray, 16, byArray2);
            blockCipher = new BlowfishEngine();
        } else if (string.startsWith("RC2-")) {
            int n2 = 128;
            if (string.startsWith("RC2-40-")) {
                n2 = 40;
            } else if (string.startsWith("RC2-64-")) {
                n2 = 64;
            }
            keyParameter = new RC2Parameters(com.aspose.imaging.internal.bouncycastle.openssl.bc.b.a(cArray, n2 / 8, byArray2).getKey(), n2);
            blockCipher = new RC2Engine();
        } else if (string.startsWith("AES-")) {
            int n3;
            byte[] byArray4 = byArray2;
            if (byArray4.length > 8) {
                byArray4 = new byte[8];
                System.arraycopy(byArray2, 0, byArray4, 0, 8);
            }
            if (string.startsWith("AES-128-")) {
                n3 = 128;
            } else if (string.startsWith("AES-192-")) {
                n3 = 192;
            } else if (string.startsWith("AES-256-")) {
                n3 = 256;
            } else {
                throw new EncryptionException("unknown AES encryption with private key: " + string);
            }
            keyParameter = com.aspose.imaging.internal.bouncycastle.openssl.bc.b.a(cArray, n3 / 8, byArray4);
            blockCipher = new AESEngine();
        } else {
            throw new EncryptionException("unknown encryption with private key: " + string);
        }
        if (string2.equals("CBC")) {
            blockCipher = new CBCBlockCipher(blockCipher);
        } else if (string2.equals("CFB")) {
            blockCipher = new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8);
        } else if (string2.equals("OFB")) {
            blockCipher = new OFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8);
        }
        try {
            BufferedBlockCipher bufferedBlockCipher = pKCS7Padding == null ? new BufferedBlockCipher(blockCipher) : new PaddedBufferedBlockCipher(blockCipher, pKCS7Padding);
            if (byArray3 == null) {
                bufferedBlockCipher.init(bl2, keyParameter);
            } else {
                bufferedBlockCipher.init(bl2, new ParametersWithIV(keyParameter, byArray3));
            }
            byte[] byArray5 = new byte[bufferedBlockCipher.getOutputSize(byArray.length)];
            int n4 = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray5, 0);
            n4 += bufferedBlockCipher.doFinal(byArray5, n4);
            if (n4 == byArray5.length) {
                return byArray5;
            }
            byte[] byArray6 = new byte[n4];
            System.arraycopy(byArray5, 0, byArray6, 0, n4);
            return byArray6;
        }
        catch (Exception exception) {
            throw new EncryptionException("exception using cipher - please check password and data.", (Throwable)exception);
        }
    }

    private static KeyParameter a(char[] cArray, int n2, byte[] byArray) throws PEMException {
        return com.aspose.imaging.internal.bouncycastle.openssl.bc.b.a(cArray, n2, byArray, false);
    }

    private static KeyParameter a(char[] cArray, int n2, byte[] byArray, boolean bl2) throws PEMException {
        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
        openSSLPBEParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray, 1);
        KeyParameter keyParameter = (KeyParameter)((PBEParametersGenerator)openSSLPBEParametersGenerator).generateDerivedParameters(n2 * 8);
        if (bl2 && keyParameter.getKey().length == 24) {
            byte[] byArray2 = keyParameter.getKey();
            System.arraycopy(byArray2, 0, byArray2, 16, 8);
            return new KeyParameter(byArray2);
        }
        return keyParameter;
    }

    static {
        b.add(PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC);
        b.add(PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC);
        b.add(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC);
        b.add(PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC);
        b.add(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC);
        b.add(PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC);
        c.add(PKCSObjectIdentifiers.id_PBES2);
        c.add(PKCSObjectIdentifiers.des_EDE3_CBC);
        c.add(NISTObjectIdentifiers.id_aes128_CBC);
        c.add(NISTObjectIdentifiers.id_aes192_CBC);
        c.add(NISTObjectIdentifiers.id_aes256_CBC);
        a.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), Integers.valueOf(192));
        a.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), Integers.valueOf(128));
        a.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), Integers.valueOf(192));
        a.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), Integers.valueOf(256));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4.getId(), Integers.valueOf(128));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4, Integers.valueOf(40));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC, Integers.valueOf(128));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC, Integers.valueOf(192));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC, Integers.valueOf(128));
        a.put(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, Integers.valueOf(40));
    }
}

