/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.operator;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.operator.AlgorithmNameFinder;
import java.util.HashMap;
import java.util.Map;

public class DefaultAlgorithmNameFinder
implements AlgorithmNameFinder {
    private static final Map a = new HashMap();

    @Override
    public boolean hasAlgorithmName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return a.containsKey(aSN1ObjectIdentifier);
    }

    @Override
    public String getAlgorithmName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = (String)a.get(aSN1ObjectIdentifier);
        return string != null ? string : aSN1ObjectIdentifier.getId();
    }

    @Override
    public String getAlgorithmName(AlgorithmIdentifier algorithmIdentifier) {
        return this.getAlgorithmName(algorithmIdentifier.getAlgorithm());
    }

    static {
        a.put(BSIObjectIdentifiers.ecdsa_plain_RIPEMD160, "RIPEMD160WITHPLAIN-ECDSA");
        a.put(BSIObjectIdentifiers.ecdsa_plain_SHA1, "SHA1WITHPLAIN-ECDSA");
        a.put(BSIObjectIdentifiers.ecdsa_plain_SHA224, "SHA224WITHPLAIN-ECDSA");
        a.put(BSIObjectIdentifiers.ecdsa_plain_SHA256, "SHA256WITHPLAIN-ECDSA");
        a.put(BSIObjectIdentifiers.ecdsa_plain_SHA384, "SHA384WITHPLAIN-ECDSA");
        a.put(BSIObjectIdentifiers.ecdsa_plain_SHA512, "SHA512WITHPLAIN-ECDSA");
        a.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, "GOST3411WITHECGOST3410");
        a.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, "GOST3411WITHECGOST3410-2001");
        a.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, "GOST3411WITHGOST3410-2001");
        a.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, "GOST3411WITHGOST3410");
        a.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, "GOST3411WITHGOST3410-94");
        a.put(CryptoProObjectIdentifiers.gostR3411, "GOST3411");
        a.put(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256, "GOST3411WITHGOST3410-2012-256");
        a.put(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512, "GOST3411WITHGOST3410-2012-512");
        a.put(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256, "GOST3411WITHECGOST3410-2012-256");
        a.put(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512, "GOST3411WITHECGOST3410-2012-512");
        a.put(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256, "GOST3411-2012-256WITHGOST3410-2012-256");
        a.put(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512, "GOST3411-2012-512WITHGOST3410-2012-512");
        a.put(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256, "GOST3411-2012-256WITHECGOST3410-2012-256");
        a.put(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512, "GOST3411-2012-512WITHECGOST3410-2012-512");
        a.put(EACObjectIdentifiers.id_TA_ECDSA_SHA_1, "SHA1WITHCVC-ECDSA");
        a.put(EACObjectIdentifiers.id_TA_ECDSA_SHA_224, "SHA224WITHCVC-ECDSA");
        a.put(EACObjectIdentifiers.id_TA_ECDSA_SHA_256, "SHA256WITHCVC-ECDSA");
        a.put(EACObjectIdentifiers.id_TA_ECDSA_SHA_384, "SHA384WITHCVC-ECDSA");
        a.put(EACObjectIdentifiers.id_TA_ECDSA_SHA_512, "SHA512WITHCVC-ECDSA");
        a.put(NISTObjectIdentifiers.id_sha224, "SHA224");
        a.put(NISTObjectIdentifiers.id_sha256, "SHA256");
        a.put(NISTObjectIdentifiers.id_sha384, "SHA384");
        a.put(NISTObjectIdentifiers.id_sha512, "SHA512");
        a.put(NISTObjectIdentifiers.id_sha3_224, "SHA3-224");
        a.put(NISTObjectIdentifiers.id_sha3_256, "SHA3-256");
        a.put(NISTObjectIdentifiers.id_sha3_384, "SHA3-384");
        a.put(NISTObjectIdentifiers.id_sha3_512, "SHA3-512");
        a.put(OIWObjectIdentifiers.elGamalAlgorithm, "ELGAMAL");
        a.put(OIWObjectIdentifiers.idSHA1, "SHA1");
        a.put(OIWObjectIdentifiers.md5WithRSA, "MD5WITHRSA");
        a.put(OIWObjectIdentifiers.sha1WithRSA, "SHA1WITHRSA");
        a.put(PKCSObjectIdentifiers.id_RSAES_OAEP, "RSAOAEP");
        a.put(PKCSObjectIdentifiers.id_RSASSA_PSS, "RSAPSS");
        a.put(PKCSObjectIdentifiers.md2WithRSAEncryption, "MD2WITHRSA");
        a.put(PKCSObjectIdentifiers.md5, "MD5");
        a.put(PKCSObjectIdentifiers.md5WithRSAEncryption, "MD5WITHRSA");
        a.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        a.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WITHRSA");
        a.put(PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224WITHRSA");
        a.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA");
        a.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384WITHRSA");
        a.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA");
        a.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, "SHA3-224WITHRSA");
        a.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, "SHA3-256WITHRSA");
        a.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, "SHA3-384WITHRSA");
        a.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, "SHA3-512WITHRSA");
        a.put(TeleTrusTObjectIdentifiers.ripemd128, "RIPEMD128");
        a.put(TeleTrusTObjectIdentifiers.ripemd160, "RIPEMD160");
        a.put(TeleTrusTObjectIdentifiers.ripemd256, "RIPEMD256");
        a.put(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128, "RIPEMD128WITHRSA");
        a.put(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160, "RIPEMD160WITHRSA");
        a.put(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256, "RIPEMD256WITHRSA");
        a.put(X9ObjectIdentifiers.ecdsa_with_SHA1, "ECDSAWITHSHA1");
        a.put(X9ObjectIdentifiers.ecdsa_with_SHA1, "SHA1WITHECDSA");
        a.put(X9ObjectIdentifiers.ecdsa_with_SHA224, "SHA224WITHECDSA");
        a.put(X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256WITHECDSA");
        a.put(X9ObjectIdentifiers.ecdsa_with_SHA384, "SHA384WITHECDSA");
        a.put(X9ObjectIdentifiers.ecdsa_with_SHA512, "SHA512WITHECDSA");
        a.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_224, "SHA3-224WITHECDSA");
        a.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_256, "SHA3-256WITHECDSA");
        a.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_384, "SHA3-384WITHECDSA");
        a.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_512, "SHA3-512WITHECDSA");
        a.put(X9ObjectIdentifiers.id_dsa_with_sha1, "SHA1WITHDSA");
        a.put(NISTObjectIdentifiers.dsa_with_sha224, "SHA224WITHDSA");
        a.put(NISTObjectIdentifiers.dsa_with_sha256, "SHA256WITHDSA");
        a.put(NISTObjectIdentifiers.dsa_with_sha384, "SHA384WITHDSA");
        a.put(NISTObjectIdentifiers.dsa_with_sha512, "SHA512WITHDSA");
        a.put(NISTObjectIdentifiers.id_dsa_with_sha3_224, "SHA3-224WITHDSA");
        a.put(NISTObjectIdentifiers.id_dsa_with_sha3_256, "SHA3-256WITHDSA");
        a.put(NISTObjectIdentifiers.id_dsa_with_sha3_384, "SHA3-384WITHDSA");
        a.put(NISTObjectIdentifiers.id_dsa_with_sha3_512, "SHA3-512WITHDSA");
        a.put(GNUObjectIdentifiers.Tiger_192, "Tiger");
        a.put(PKCSObjectIdentifiers.RC2_CBC, "RC2/CBC");
        a.put(PKCSObjectIdentifiers.des_EDE3_CBC, "DESEDE-3KEY/CBC");
        a.put(NISTObjectIdentifiers.id_aes128_ECB, "AES-128/ECB");
        a.put(NISTObjectIdentifiers.id_aes192_ECB, "AES-192/ECB");
        a.put(NISTObjectIdentifiers.id_aes256_ECB, "AES-256/ECB");
        a.put(NISTObjectIdentifiers.id_aes128_CBC, "AES-128/CBC");
        a.put(NISTObjectIdentifiers.id_aes192_CBC, "AES-192/CBC");
        a.put(NISTObjectIdentifiers.id_aes256_CBC, "AES-256/CBC");
        a.put(NISTObjectIdentifiers.id_aes128_CFB, "AES-128/CFB");
        a.put(NISTObjectIdentifiers.id_aes192_CFB, "AES-192/CFB");
        a.put(NISTObjectIdentifiers.id_aes256_CFB, "AES-256/CFB");
        a.put(NISTObjectIdentifiers.id_aes128_OFB, "AES-128/OFB");
        a.put(NISTObjectIdentifiers.id_aes192_OFB, "AES-192/OFB");
        a.put(NISTObjectIdentifiers.id_aes256_OFB, "AES-256/OFB");
        a.put(NTTObjectIdentifiers.id_camellia128_cbc, "CAMELLIA-128/CBC");
        a.put(NTTObjectIdentifiers.id_camellia192_cbc, "CAMELLIA-192/CBC");
        a.put(NTTObjectIdentifiers.id_camellia256_cbc, "CAMELLIA-256/CBC");
        a.put(KISAObjectIdentifiers.id_seedCBC, "SEED/CBC");
        a.put(MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC, "IDEA/CBC");
        a.put(MiscObjectIdentifiers.cast5CBC, "CAST5/CBC");
        a.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_ECB, "Blowfish/ECB");
        a.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CBC, "Blowfish/CBC");
        a.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_CFB, "Blowfish/CFB");
        a.put(MiscObjectIdentifiers.cryptlib_algorithm_blowfish_OFB, "Blowfish/OFB");
        a.put(GNUObjectIdentifiers.Serpent_128_ECB, "Serpent-128/ECB");
        a.put(GNUObjectIdentifiers.Serpent_128_CBC, "Serpent-128/CBC");
        a.put(GNUObjectIdentifiers.Serpent_128_CFB, "Serpent-128/CFB");
        a.put(GNUObjectIdentifiers.Serpent_128_OFB, "Serpent-128/OFB");
        a.put(GNUObjectIdentifiers.Serpent_192_ECB, "Serpent-192/ECB");
        a.put(GNUObjectIdentifiers.Serpent_192_CBC, "Serpent-192/CBC");
        a.put(GNUObjectIdentifiers.Serpent_192_CFB, "Serpent-192/CFB");
        a.put(GNUObjectIdentifiers.Serpent_192_OFB, "Serpent-192/OFB");
        a.put(GNUObjectIdentifiers.Serpent_256_ECB, "Serpent-256/ECB");
        a.put(GNUObjectIdentifiers.Serpent_256_CBC, "Serpent-256/CBC");
        a.put(GNUObjectIdentifiers.Serpent_256_CFB, "Serpent-256/CFB");
        a.put(GNUObjectIdentifiers.Serpent_256_OFB, "Serpent-256/OFB");
    }
}

