/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.operator;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.bc.BCObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.aspose.imaging.internal.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultSignatureAlgorithmIdentifierFinder
implements SignatureAlgorithmIdentifierFinder {
    private static Map a = new HashMap();
    private static Set b = new HashSet();
    private static Map c = new HashMap();
    private static Set d = new HashSet();
    private static Map e = new HashMap();
    private static final ASN1ObjectIdentifier f = PKCSObjectIdentifiers.rsaEncryption;
    private static final ASN1ObjectIdentifier g = X9ObjectIdentifiers.id_dsa_with_sha1;
    private static final ASN1ObjectIdentifier h = X9ObjectIdentifiers.ecdsa_with_SHA1;
    private static final ASN1ObjectIdentifier i = PKCSObjectIdentifiers.id_RSASSA_PSS;
    private static final ASN1ObjectIdentifier j = CryptoProObjectIdentifiers.gostR3410_94;
    private static final ASN1ObjectIdentifier k = CryptoProObjectIdentifiers.gostR3410_2001;
    private static final ASN1ObjectIdentifier l = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256;
    private static final ASN1ObjectIdentifier m = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512;

    private static AlgorithmIdentifier a(String string) {
        String string2 = Strings.toUpperCase(string);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)a.get(string2);
        if (aSN1ObjectIdentifier == null) {
            throw new IllegalArgumentException("Unknown signature type requested: " + string2);
        }
        AlgorithmIdentifier algorithmIdentifier = b.contains(aSN1ObjectIdentifier) ? new AlgorithmIdentifier(aSN1ObjectIdentifier) : (c.containsKey(string2) ? new AlgorithmIdentifier(aSN1ObjectIdentifier, (ASN1Encodable)c.get(string2)) : new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE));
        if (d.contains(aSN1ObjectIdentifier)) {
            AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
        } else {
            AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier;
        }
        if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            AlgorithmIdentifier algorithmIdentifier4 = ((RSASSAPSSparams)algorithmIdentifier.getParameters()).getHashAlgorithm();
        } else {
            AlgorithmIdentifier algorithmIdentifier5 = new AlgorithmIdentifier((ASN1ObjectIdentifier)e.get(aSN1ObjectIdentifier), DERNull.INSTANCE);
        }
        return algorithmIdentifier;
    }

    private static RSASSAPSSparams a(AlgorithmIdentifier algorithmIdentifier, int n2) {
        return new RSASSAPSSparams(algorithmIdentifier, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier), new ASN1Integer(n2), new ASN1Integer(1L));
    }

    @Override
    public AlgorithmIdentifier find(String string) {
        return DefaultSignatureAlgorithmIdentifierFinder.a(string);
    }

    static {
        a.put("MD2WITHRSAENCRYPTION", PKCSObjectIdentifiers.md2WithRSAEncryption);
        a.put("MD2WITHRSA", PKCSObjectIdentifiers.md2WithRSAEncryption);
        a.put("MD5WITHRSAENCRYPTION", PKCSObjectIdentifiers.md5WithRSAEncryption);
        a.put("MD5WITHRSA", PKCSObjectIdentifiers.md5WithRSAEncryption);
        a.put("SHA1WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        a.put("SHA1WITHRSA", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        a.put("SHA224WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        a.put("SHA224WITHRSA", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        a.put("SHA256WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        a.put("SHA256WITHRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        a.put("SHA384WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        a.put("SHA384WITHRSA", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        a.put("SHA512WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        a.put("SHA512WITHRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        a.put("SHA1WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        a.put("SHA224WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        a.put("SHA256WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        a.put("SHA384WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        a.put("SHA512WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        a.put("RIPEMD160WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        a.put("RIPEMD160WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        a.put("RIPEMD128WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        a.put("RIPEMD128WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        a.put("RIPEMD256WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        a.put("RIPEMD256WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        a.put("SHA1WITHDSA", X9ObjectIdentifiers.id_dsa_with_sha1);
        a.put("DSAWITHSHA1", X9ObjectIdentifiers.id_dsa_with_sha1);
        a.put("SHA224WITHDSA", NISTObjectIdentifiers.dsa_with_sha224);
        a.put("SHA256WITHDSA", NISTObjectIdentifiers.dsa_with_sha256);
        a.put("SHA384WITHDSA", NISTObjectIdentifiers.dsa_with_sha384);
        a.put("SHA512WITHDSA", NISTObjectIdentifiers.dsa_with_sha512);
        a.put("SHA3-224WITHDSA", NISTObjectIdentifiers.id_dsa_with_sha3_224);
        a.put("SHA3-256WITHDSA", NISTObjectIdentifiers.id_dsa_with_sha3_256);
        a.put("SHA3-384WITHDSA", NISTObjectIdentifiers.id_dsa_with_sha3_384);
        a.put("SHA3-512WITHDSA", NISTObjectIdentifiers.id_dsa_with_sha3_512);
        a.put("SHA3-224WITHECDSA", NISTObjectIdentifiers.id_ecdsa_with_sha3_224);
        a.put("SHA3-256WITHECDSA", NISTObjectIdentifiers.id_ecdsa_with_sha3_256);
        a.put("SHA3-384WITHECDSA", NISTObjectIdentifiers.id_ecdsa_with_sha3_384);
        a.put("SHA3-512WITHECDSA", NISTObjectIdentifiers.id_ecdsa_with_sha3_512);
        a.put("SHA3-224WITHRSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224);
        a.put("SHA3-256WITHRSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256);
        a.put("SHA3-384WITHRSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384);
        a.put("SHA3-512WITHRSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512);
        a.put("SHA3-224WITHRSAENCRYPTION", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224);
        a.put("SHA3-256WITHRSAENCRYPTION", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256);
        a.put("SHA3-384WITHRSAENCRYPTION", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384);
        a.put("SHA3-512WITHRSAENCRYPTION", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512);
        a.put("SHA1WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA1);
        a.put("ECDSAWITHSHA1", X9ObjectIdentifiers.ecdsa_with_SHA1);
        a.put("SHA224WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA224);
        a.put("SHA256WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA256);
        a.put("SHA384WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA384);
        a.put("SHA512WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA512);
        a.put("GOST3411WITHGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        a.put("GOST3411WITHGOST3410-94", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        a.put("GOST3411WITHECGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        a.put("GOST3411WITHECGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        a.put("GOST3411WITHGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        a.put("GOST3411WITHECGOST3410-2012-256", RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256);
        a.put("GOST3411WITHECGOST3410-2012-512", RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512);
        a.put("GOST3411WITHGOST3410-2012-256", RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256);
        a.put("GOST3411WITHGOST3410-2012-512", RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512);
        a.put("GOST3411-2012-256WITHECGOST3410-2012-256", RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256);
        a.put("GOST3411-2012-512WITHECGOST3410-2012-512", RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512);
        a.put("GOST3411-2012-256WITHGOST3410-2012-256", RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256);
        a.put("GOST3411-2012-512WITHGOST3410-2012-512", RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512);
        a.put("SHA1WITHPLAIN-ECDSA", BSIObjectIdentifiers.ecdsa_plain_SHA1);
        a.put("SHA224WITHPLAIN-ECDSA", BSIObjectIdentifiers.ecdsa_plain_SHA224);
        a.put("SHA256WITHPLAIN-ECDSA", BSIObjectIdentifiers.ecdsa_plain_SHA256);
        a.put("SHA384WITHPLAIN-ECDSA", BSIObjectIdentifiers.ecdsa_plain_SHA384);
        a.put("SHA512WITHPLAIN-ECDSA", BSIObjectIdentifiers.ecdsa_plain_SHA512);
        a.put("RIPEMD160WITHPLAIN-ECDSA", BSIObjectIdentifiers.ecdsa_plain_RIPEMD160);
        a.put("SHA1WITHCVC-ECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_1);
        a.put("SHA224WITHCVC-ECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_224);
        a.put("SHA256WITHCVC-ECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_256);
        a.put("SHA384WITHCVC-ECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_384);
        a.put("SHA512WITHCVC-ECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_512);
        a.put("SHA3-512WITHSPHINCS256", BCObjectIdentifiers.sphincs256_with_SHA3_512);
        a.put("SHA512WITHSPHINCS256", BCObjectIdentifiers.sphincs256_with_SHA512);
        a.put("SM3WITHSM2", GMObjectIdentifiers.sm2sign_with_sm3);
        a.put("SHA256WITHXMSS", BCObjectIdentifiers.xmss_with_SHA256);
        a.put("SHA512WITHXMSS", BCObjectIdentifiers.xmss_with_SHA512);
        a.put("SHAKE128WITHXMSS", BCObjectIdentifiers.xmss_with_SHAKE128);
        a.put("SHAKE256WITHXMSS", BCObjectIdentifiers.xmss_with_SHAKE256);
        a.put("SHA256WITHXMSSMT", BCObjectIdentifiers.xmss_mt_with_SHA256);
        a.put("SHA512WITHXMSSMT", BCObjectIdentifiers.xmss_mt_with_SHA512);
        a.put("SHAKE128WITHXMSSMT", BCObjectIdentifiers.xmss_mt_with_SHAKE128);
        a.put("SHAKE256WITHXMSSMT", BCObjectIdentifiers.xmss_mt_with_SHAKE256);
        b.add(X9ObjectIdentifiers.ecdsa_with_SHA1);
        b.add(X9ObjectIdentifiers.ecdsa_with_SHA224);
        b.add(X9ObjectIdentifiers.ecdsa_with_SHA256);
        b.add(X9ObjectIdentifiers.ecdsa_with_SHA384);
        b.add(X9ObjectIdentifiers.ecdsa_with_SHA512);
        b.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        b.add(NISTObjectIdentifiers.dsa_with_sha224);
        b.add(NISTObjectIdentifiers.dsa_with_sha256);
        b.add(NISTObjectIdentifiers.dsa_with_sha384);
        b.add(NISTObjectIdentifiers.dsa_with_sha512);
        b.add(NISTObjectIdentifiers.id_dsa_with_sha3_224);
        b.add(NISTObjectIdentifiers.id_dsa_with_sha3_256);
        b.add(NISTObjectIdentifiers.id_dsa_with_sha3_384);
        b.add(NISTObjectIdentifiers.id_dsa_with_sha3_512);
        b.add(NISTObjectIdentifiers.id_ecdsa_with_sha3_224);
        b.add(NISTObjectIdentifiers.id_ecdsa_with_sha3_256);
        b.add(NISTObjectIdentifiers.id_ecdsa_with_sha3_384);
        b.add(NISTObjectIdentifiers.id_ecdsa_with_sha3_512);
        b.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        b.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        b.add(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256);
        b.add(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512);
        b.add(BCObjectIdentifiers.sphincs256_with_SHA512);
        b.add(BCObjectIdentifiers.sphincs256_with_SHA3_512);
        b.add(BCObjectIdentifiers.xmss_with_SHA256);
        b.add(BCObjectIdentifiers.xmss_with_SHA512);
        b.add(BCObjectIdentifiers.xmss_with_SHAKE128);
        b.add(BCObjectIdentifiers.xmss_with_SHAKE256);
        b.add(BCObjectIdentifiers.xmss_mt_with_SHA256);
        b.add(BCObjectIdentifiers.xmss_mt_with_SHA512);
        b.add(BCObjectIdentifiers.xmss_mt_with_SHAKE128);
        b.add(BCObjectIdentifiers.xmss_mt_with_SHAKE256);
        b.add(GMObjectIdentifiers.sm2sign_with_sm3);
        d.add(PKCSObjectIdentifiers.sha1WithRSAEncryption);
        d.add(PKCSObjectIdentifiers.sha224WithRSAEncryption);
        d.add(PKCSObjectIdentifiers.sha256WithRSAEncryption);
        d.add(PKCSObjectIdentifiers.sha384WithRSAEncryption);
        d.add(PKCSObjectIdentifiers.sha512WithRSAEncryption);
        d.add(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        d.add(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        d.add(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        d.add(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224);
        d.add(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256);
        d.add(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384);
        d.add(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
        c.put("SHA1WITHRSAANDMGF1", DefaultSignatureAlgorithmIdentifierFinder.a(algorithmIdentifier, 20));
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha224, DERNull.INSTANCE);
        c.put("SHA224WITHRSAANDMGF1", DefaultSignatureAlgorithmIdentifierFinder.a(algorithmIdentifier2, 28));
        AlgorithmIdentifier algorithmIdentifier3 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE);
        c.put("SHA256WITHRSAANDMGF1", DefaultSignatureAlgorithmIdentifierFinder.a(algorithmIdentifier3, 32));
        AlgorithmIdentifier algorithmIdentifier4 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, DERNull.INSTANCE);
        c.put("SHA384WITHRSAANDMGF1", DefaultSignatureAlgorithmIdentifierFinder.a(algorithmIdentifier4, 48));
        AlgorithmIdentifier algorithmIdentifier5 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, DERNull.INSTANCE);
        c.put("SHA512WITHRSAANDMGF1", DefaultSignatureAlgorithmIdentifierFinder.a(algorithmIdentifier5, 64));
        e.put(PKCSObjectIdentifiers.sha224WithRSAEncryption, NISTObjectIdentifiers.id_sha224);
        e.put(PKCSObjectIdentifiers.sha256WithRSAEncryption, NISTObjectIdentifiers.id_sha256);
        e.put(PKCSObjectIdentifiers.sha384WithRSAEncryption, NISTObjectIdentifiers.id_sha384);
        e.put(PKCSObjectIdentifiers.sha512WithRSAEncryption, NISTObjectIdentifiers.id_sha512);
        e.put(NISTObjectIdentifiers.dsa_with_sha224, NISTObjectIdentifiers.id_sha224);
        e.put(NISTObjectIdentifiers.dsa_with_sha224, NISTObjectIdentifiers.id_sha256);
        e.put(NISTObjectIdentifiers.dsa_with_sha224, NISTObjectIdentifiers.id_sha384);
        e.put(NISTObjectIdentifiers.dsa_with_sha224, NISTObjectIdentifiers.id_sha512);
        e.put(NISTObjectIdentifiers.id_dsa_with_sha3_224, NISTObjectIdentifiers.id_sha3_224);
        e.put(NISTObjectIdentifiers.id_dsa_with_sha3_256, NISTObjectIdentifiers.id_sha3_256);
        e.put(NISTObjectIdentifiers.id_dsa_with_sha3_384, NISTObjectIdentifiers.id_sha3_384);
        e.put(NISTObjectIdentifiers.id_dsa_with_sha3_512, NISTObjectIdentifiers.id_sha3_512);
        e.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_224, NISTObjectIdentifiers.id_sha3_224);
        e.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_256, NISTObjectIdentifiers.id_sha3_256);
        e.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_384, NISTObjectIdentifiers.id_sha3_384);
        e.put(NISTObjectIdentifiers.id_ecdsa_with_sha3_512, NISTObjectIdentifiers.id_sha3_512);
        e.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, NISTObjectIdentifiers.id_sha3_224);
        e.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, NISTObjectIdentifiers.id_sha3_256);
        e.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, NISTObjectIdentifiers.id_sha3_384);
        e.put(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, NISTObjectIdentifiers.id_sha3_512);
        e.put(PKCSObjectIdentifiers.md2WithRSAEncryption, PKCSObjectIdentifiers.md2);
        e.put(PKCSObjectIdentifiers.md4WithRSAEncryption, PKCSObjectIdentifiers.md4);
        e.put(PKCSObjectIdentifiers.md5WithRSAEncryption, PKCSObjectIdentifiers.md5);
        e.put(PKCSObjectIdentifiers.sha1WithRSAEncryption, OIWObjectIdentifiers.idSHA1);
        e.put(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128, TeleTrusTObjectIdentifiers.ripemd128);
        e.put(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160, TeleTrusTObjectIdentifiers.ripemd160);
        e.put(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256, TeleTrusTObjectIdentifiers.ripemd256);
        e.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94, CryptoProObjectIdentifiers.gostR3411);
        e.put(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, CryptoProObjectIdentifiers.gostR3411);
        e.put(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256, RosstandartObjectIdentifiers.id_tc26_gost_3411_12_256);
        e.put(RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512, RosstandartObjectIdentifiers.id_tc26_gost_3411_12_512);
        e.put(GMObjectIdentifiers.sm2sign_with_sm3, GMObjectIdentifiers.sm3);
    }
}

