/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pkcs;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DLSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.ContentInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.MacData;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.Pfx;
import com.aspose.imaging.internal.bouncycastle.cms.CMSEncryptedDataGenerator;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.CMSProcessableByteArray;
import com.aspose.imaging.internal.bouncycastle.operator.OutputEncryptor;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCS12PfxPdu;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCS12SafeBag;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCSException;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCSIOException;
import com.aspose.imaging.internal.bouncycastle.pkcs.a;
import java.io.IOException;

public class PKCS12PfxPduBuilder {
    private ASN1EncodableVector a = new ASN1EncodableVector();

    public PKCS12PfxPduBuilder addData(PKCS12SafeBag pKCS12SafeBag) throws IOException {
        this.a.add(new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(new DLSequence(pKCS12SafeBag.toASN1Structure()).getEncoded())));
        return this;
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor outputEncryptor, PKCS12SafeBag pKCS12SafeBag) throws IOException {
        return this.a(outputEncryptor, new DERSequence(pKCS12SafeBag.toASN1Structure()));
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor outputEncryptor, PKCS12SafeBag[] pKCS12SafeBagArray) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != pKCS12SafeBagArray.length; ++i2) {
            aSN1EncodableVector.add(pKCS12SafeBagArray[i2].toASN1Structure());
        }
        return this.a(outputEncryptor, new DLSequence(aSN1EncodableVector));
    }

    private PKCS12PfxPduBuilder a(OutputEncryptor outputEncryptor, ASN1Sequence aSN1Sequence) throws IOException {
        CMSEncryptedDataGenerator cMSEncryptedDataGenerator = new CMSEncryptedDataGenerator();
        try {
            this.a.add(cMSEncryptedDataGenerator.generate(new CMSProcessableByteArray(aSN1Sequence.getEncoded()), outputEncryptor).toASN1Structure());
        }
        catch (CMSException cMSException) {
            throw new PKCSIOException(cMSException.getMessage(), cMSException.getCause());
        }
        return this;
    }

    public PKCS12PfxPdu build(PKCS12MacCalculatorBuilder pKCS12MacCalculatorBuilder, char[] cArray) throws PKCSException {
        Object object;
        byte[] byArray;
        AuthenticatedSafe authenticatedSafe = AuthenticatedSafe.getInstance(new DLSequence(this.a));
        try {
            byArray = authenticatedSafe.getEncoded();
        }
        catch (IOException iOException) {
            throw new PKCSException("unable to encode AuthenticatedSafe: " + iOException.getMessage(), iOException);
        }
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(byArray));
        MacData macData = null;
        if (pKCS12MacCalculatorBuilder != null) {
            object = new a(pKCS12MacCalculatorBuilder);
            macData = ((a)object).a(cArray, byArray);
        }
        object = new Pfx(contentInfo, macData);
        return new PKCS12PfxPdu((Pfx)object);
    }
}

