/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pkcs;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.imaging.internal.bouncycastle.operator.InputDecryptor;
import com.aspose.imaging.internal.bouncycastle.operator.InputDecryptorProvider;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCSException;
import com.aspose.imaging.internal.bouncycastle.pkcs.PKCSIOException;
import com.aspose.imaging.internal.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class PKCS8EncryptedPrivateKeyInfo {
    private EncryptedPrivateKeyInfo a;

    private static EncryptedPrivateKeyInfo a(byte[] byArray) throws IOException {
        try {
            return EncryptedPrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new PKCSIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PKCSIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        this.a = encryptedPrivateKeyInfo;
    }

    public PKCS8EncryptedPrivateKeyInfo(byte[] byArray) throws IOException {
        this(PKCS8EncryptedPrivateKeyInfo.a(byArray));
    }

    public EncryptedPrivateKeyInfo toASN1Structure() {
        return this.a;
    }

    public byte[] getEncoded() throws IOException {
        return this.a.getEncoded();
    }

    public PrivateKeyInfo decryptPrivateKeyInfo(InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        try {
            InputDecryptor inputDecryptor = inputDecryptorProvider.get(this.a.getEncryptionAlgorithm());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.a.getEncryptedData());
            return PrivateKeyInfo.getInstance(Streams.readAll(inputDecryptor.getInputStream(byteArrayInputStream)));
        }
        catch (Exception exception) {
            throw new PKCSException("unable to read encrypted data: " + exception.getMessage(), exception);
        }
    }
}

