/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pkcs.jcajce;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.bc.BCObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.misc.ScryptParams;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.EncryptionScheme;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PBES2Parameters;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.crypto.util.PBKDF2Config;
import com.aspose.imaging.internal.bouncycastle.crypto.util.PBKDFConfig;
import com.aspose.imaging.internal.bouncycastle.crypto.util.ScryptConfig;
import com.aspose.imaging.internal.bouncycastle.jcajce.PKCS12KeyWithParameters;
import com.aspose.imaging.internal.bouncycastle.jcajce.spec.ScryptKeySpec;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.operator.DefaultSecretKeySizeProvider;
import com.aspose.imaging.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.imaging.internal.bouncycastle.operator.OutputEncryptor;
import com.aspose.imaging.internal.bouncycastle.operator.SecretKeySizeProvider;
import com.aspose.imaging.internal.bouncycastle.pkcs.jcajce.f;
import com.aspose.imaging.internal.bouncycastle.pkcs.jcajce.g;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class JcePKCSPBEOutputEncryptorBuilder {
    private final PBKDFConfig a;
    private JcaJceHelper b = new DefaultJcaJceHelper();
    private ASN1ObjectIdentifier c;
    private ASN1ObjectIdentifier d;
    private SecureRandom e;
    private SecretKeySizeProvider f = DefaultSecretKeySizeProvider.INSTANCE;
    private int g = 1024;
    private PBKDF2Config.Builder h = new PBKDF2Config.Builder();

    public JcePKCSPBEOutputEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.a = null;
        if (this.a(aSN1ObjectIdentifier)) {
            this.c = aSN1ObjectIdentifier;
            this.d = aSN1ObjectIdentifier;
        } else {
            this.c = PKCSObjectIdentifiers.id_PBES2;
            this.d = aSN1ObjectIdentifier;
        }
    }

    public JcePKCSPBEOutputEncryptorBuilder(PBKDFConfig pBKDFConfig, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.c = PKCSObjectIdentifiers.id_PBES2;
        this.a = pBKDFConfig;
        this.d = aSN1ObjectIdentifier;
    }

    public JcePKCSPBEOutputEncryptorBuilder setProvider(Provider provider) {
        this.b = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setProvider(String string) {
        this.b = new NamedJcaJceHelper(string);
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setRandom(SecureRandom secureRandom) {
        this.e = secureRandom;
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setKeySizeProvider(SecretKeySizeProvider secretKeySizeProvider) {
        this.f = secretKeySizeProvider;
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setPRF(AlgorithmIdentifier algorithmIdentifier) {
        if (this.a != null) {
            throw new IllegalStateException("set PRF count using PBKDFDef");
        }
        this.h.withPRF(algorithmIdentifier);
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setIterationCount(int n2) {
        if (this.a != null) {
            throw new IllegalStateException("set iteration count using PBKDFDef");
        }
        this.g = n2;
        this.h.withIterationCount(n2);
        return this;
    }

    public OutputEncryptor build(char[] cArray) throws OperatorCreationException {
        if (this.e == null) {
            this.e = new SecureRandom();
        }
        try {
            AlgorithmIdentifier algorithmIdentifier;
            Cipher cipher;
            if (this.a(this.c)) {
                byte[] byArray = new byte[20];
                this.e.nextBytes(byArray);
                cipher = this.b.createCipher(this.c.getId());
                cipher.init(1, new PKCS12KeyWithParameters(cArray, byArray, this.g));
                algorithmIdentifier = new AlgorithmIdentifier(this.c, new PKCS12PBEParams(byArray, this.g));
            } else if (this.c.equals(PKCSObjectIdentifiers.id_PBES2)) {
                PBKDFConfig pBKDFConfig;
                PBKDFConfig pBKDFConfig2 = pBKDFConfig = this.a == null ? this.h.build() : this.a;
                if (MiscObjectIdentifiers.id_scrypt.equals(pBKDFConfig.getAlgorithm())) {
                    ScryptConfig scryptConfig = (ScryptConfig)pBKDFConfig;
                    byte[] byArray = new byte[scryptConfig.getSaltLength()];
                    this.e.nextBytes(byArray);
                    ScryptParams scryptParams = new ScryptParams(byArray, scryptConfig.getCostParameter(), scryptConfig.getBlockSize(), scryptConfig.getParallelizationParameter());
                    SecretKeyFactory secretKeyFactory = this.b.createSecretKeyFactory("SCRYPT");
                    SecretKey secretKey = secretKeyFactory.generateSecret(new ScryptKeySpec(cArray, byArray, scryptConfig.getCostParameter(), scryptConfig.getBlockSize(), scryptConfig.getParallelizationParameter(), this.f.getKeySize(new AlgorithmIdentifier(this.d))));
                    cipher = this.b.createCipher(this.d.getId());
                    cipher.init(1, (Key)secretKey, this.e);
                    PBES2Parameters pBES2Parameters = new PBES2Parameters(new KeyDerivationFunc(MiscObjectIdentifiers.id_scrypt, scryptParams), new EncryptionScheme(this.d, ASN1Primitive.fromByteArray(cipher.getParameters().getEncoded())));
                    algorithmIdentifier = new AlgorithmIdentifier(this.c, pBES2Parameters);
                } else {
                    PBKDF2Config pBKDF2Config = (PBKDF2Config)pBKDFConfig;
                    byte[] byArray = new byte[pBKDF2Config.getSaltLength()];
                    this.e.nextBytes(byArray);
                    SecretKeyFactory secretKeyFactory = this.b.createSecretKeyFactory(com.aspose.imaging.internal.bouncycastle.pkcs.jcajce.g.a(pBKDF2Config.getPRF().getAlgorithm()));
                    SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(cArray, byArray, pBKDF2Config.getIterationCount(), this.f.getKeySize(new AlgorithmIdentifier(this.d))));
                    cipher = this.b.createCipher(this.d.getId());
                    cipher.init(1, (Key)secretKey, this.e);
                    PBES2Parameters pBES2Parameters = new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(byArray, pBKDF2Config.getIterationCount(), pBKDF2Config.getPRF())), new EncryptionScheme(this.d, ASN1Primitive.fromByteArray(cipher.getParameters().getEncoded())));
                    algorithmIdentifier = new AlgorithmIdentifier(this.c, pBES2Parameters);
                }
            } else {
                throw new OperatorCreationException("unrecognised algorithm");
            }
            return new f(this, algorithmIdentifier, cipher, cArray);
        }
        catch (Exception exception) {
            throw new OperatorCreationException("unable to create OutputEncryptor: " + exception.getMessage(), exception);
        }
    }

    private boolean a(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds) || aSN1ObjectIdentifier.on(BCObjectIdentifiers.bc_pbe_sha1_pkcs12) || aSN1ObjectIdentifier.on(BCObjectIdentifiers.bc_pbe_sha256_pkcs12);
    }

    private static byte[] a(char[] cArray) {
        if (cArray != null) {
            byte[] byArray = new byte[cArray.length];
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray[i2] = (byte)cArray[i2];
            }
            return byArray;
        }
        return new byte[0];
    }

    private static byte[] b(char[] cArray) {
        if (cArray != null && cArray.length > 0) {
            byte[] byArray = new byte[(cArray.length + 1) * 2];
            for (int i2 = 0; i2 != cArray.length; ++i2) {
                byArray[i2 * 2] = (byte)(cArray[i2] >>> 8);
                byArray[i2 * 2 + 1] = (byte)cArray[i2];
            }
            return byArray;
        }
        return new byte[0];
    }

    static /* synthetic */ boolean access$000(JcePKCSPBEOutputEncryptorBuilder jcePKCSPBEOutputEncryptorBuilder, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return jcePKCSPBEOutputEncryptorBuilder.a(aSN1ObjectIdentifier);
    }

    static /* synthetic */ byte[] access$100(char[] cArray) {
        return JcePKCSPBEOutputEncryptorBuilder.b(cArray);
    }

    static /* synthetic */ byte[] access$200(char[] cArray) {
        return JcePKCSPBEOutputEncryptorBuilder.a(cArray);
    }
}

