/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.asn1;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;

public class RainbowPublicKey
extends ASN1Object {
    private ASN1Integer a;
    private ASN1ObjectIdentifier b;
    private ASN1Integer c;
    private byte[][] d;
    private byte[][] e;
    private byte[] f;

    private RainbowPublicKey(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
            this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        } else {
            this.b = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        }
        this.c = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1));
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(2));
        this.d = new byte[aSN1Sequence2.size()][];
        for (int i2 = 0; i2 < aSN1Sequence2.size(); ++i2) {
            this.d[i2] = ASN1OctetString.getInstance(aSN1Sequence2.getObjectAt(i2)).getOctets();
        }
        ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence.getObjectAt(3);
        this.e = new byte[aSN1Sequence3.size()][];
        for (int i3 = 0; i3 < aSN1Sequence3.size(); ++i3) {
            this.e[i3] = ASN1OctetString.getInstance(aSN1Sequence3.getObjectAt(i3)).getOctets();
        }
        ASN1Sequence aSN1Sequence4 = (ASN1Sequence)aSN1Sequence.getObjectAt(4);
        this.f = ASN1OctetString.getInstance(aSN1Sequence4.getObjectAt(0)).getOctets();
    }

    public RainbowPublicKey(int n2, short[][] sArray, short[][] sArray2, short[] sArray3) {
        this.a = new ASN1Integer(0L);
        this.c = new ASN1Integer(n2);
        this.d = RainbowUtil.convertArray(sArray);
        this.e = RainbowUtil.convertArray(sArray2);
        this.f = RainbowUtil.convertArray(sArray3);
    }

    public static RainbowPublicKey getInstance(Object object) {
        if (object instanceof RainbowPublicKey) {
            return (RainbowPublicKey)object;
        }
        if (object != null) {
            return new RainbowPublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public int getDocLength() {
        return this.c.getValue().intValue();
    }

    public short[][] getCoeffQuadratic() {
        return RainbowUtil.convertArray(this.d);
    }

    public short[][] getCoeffSingular() {
        return RainbowUtil.convertArray(this.e);
    }

    public short[] getCoeffScalar() {
        return RainbowUtil.convertArray(this.f);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        } else {
            aSN1EncodableVector.add(this.b);
        }
        aSN1EncodableVector.add(this.c);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            aSN1EncodableVector2.add(new DEROctetString(this.d[i2]));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
        for (int i3 = 0; i3 < this.e.length; ++i3) {
            aSN1EncodableVector3.add(new DEROctetString(this.e[i3]));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector3));
        ASN1EncodableVector aSN1EncodableVector4 = new ASN1EncodableVector();
        aSN1EncodableVector4.add(new DEROctetString(this.f));
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector4));
        return new DERSequence(aSN1EncodableVector);
    }
}

