/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.aspose.imaging.internal.bouncycastle.pqc.asn1.XMSSPublicKey;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.interfaces.XMSSKey;
import com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss.a;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PublicKey;

public class BCXMSSPublicKey
implements XMSSKey,
PublicKey {
    private final XMSSPublicKeyParameters a;
    private final ASN1ObjectIdentifier b;

    public BCXMSSPublicKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSPublicKeyParameters xMSSPublicKeyParameters) {
        this.b = aSN1ObjectIdentifier;
        this.a = xMSSPublicKeyParameters;
    }

    public BCXMSSPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        XMSSKeyParams xMSSKeyParams = XMSSKeyParams.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
        this.b = xMSSKeyParams.getTreeDigest().getAlgorithm();
        XMSSPublicKey xMSSPublicKey = XMSSPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
        this.a = new XMSSPublicKeyParameters.Builder(new XMSSParameters(xMSSKeyParams.getHeight(), com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss.a.a(this.b))).withPublicSeed(xMSSPublicKey.getPublicSeed()).withRoot(xMSSPublicKey.getRoot()).build();
    }

    @Override
    public final String getAlgorithm() {
        return "XMSS";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(this.a.getParameters().getHeight(), new AlgorithmIdentifier(this.b)));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSPublicKey(this.a.getPublicSeed(), this.a.getRoot()));
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    CipherParameters getKeyParams() {
        return this.a;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSPublicKey) {
            BCXMSSPublicKey bCXMSSPublicKey = (BCXMSSPublicKey)object;
            return this.b.equals(bCXMSSPublicKey.b) && Arrays.areEqual(this.a.toByteArray(), bCXMSSPublicKey.a.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.b.hashCode() + 37 * Arrays.hashCode(this.a.toByteArray());
    }

    @Override
    public int getHeight() {
        return this.a.getParameters().getHeight();
    }

    @Override
    public String getTreeDigest() {
        return com.aspose.imaging.internal.bouncycastle.pqc.jcajce.provider.xmss.a.b(this.b);
    }
}

