/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.tsp;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Boolean;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.ess.ESSCertID;
import com.aspose.imaging.internal.bouncycastle.asn1.ess.ESSCertIDv2;
import com.aspose.imaging.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.tsp.Accuracy;
import com.aspose.imaging.internal.bouncycastle.asn1.tsp.MessageImprint;
import com.aspose.imaging.internal.bouncycastle.asn1.tsp.TSTInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.GeneralNames;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.IssuerSerial;
import com.aspose.imaging.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.imaging.internal.bouncycastle.cms.CMSException;
import com.aspose.imaging.internal.bouncycastle.cms.CMSProcessableByteArray;
import com.aspose.imaging.internal.bouncycastle.cms.CMSSignedData;
import com.aspose.imaging.internal.bouncycastle.cms.CMSSignedDataGenerator;
import com.aspose.imaging.internal.bouncycastle.cms.SignerInfoGenerator;
import com.aspose.imaging.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.imaging.internal.bouncycastle.tsp.TSPException;
import com.aspose.imaging.internal.bouncycastle.tsp.TSPUtil;
import com.aspose.imaging.internal.bouncycastle.tsp.TimeStampRequest;
import com.aspose.imaging.internal.bouncycastle.tsp.TimeStampToken;
import com.aspose.imaging.internal.bouncycastle.tsp.a;
import com.aspose.imaging.internal.bouncycastle.tsp.b;
import com.aspose.imaging.internal.bouncycastle.util.CollectionStore;
import com.aspose.imaging.internal.bouncycastle.util.Encodable;
import com.aspose.imaging.internal.bouncycastle.util.Store;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;

public class TimeStampTokenGenerator {
    public static final int R_SECONDS = 0;
    public static final int R_TENTHS_OF_SECONDS = 1;
    public static final int R_MICROSECONDS = 2;
    public static final int R_MILLISECONDS = 3;
    private int a = 0;
    private Locale b = null;
    private int c = -1;
    private int d = -1;
    private int e = -1;
    boolean ordering = false;
    GeneralName tsa = null;
    private ASN1ObjectIdentifier f;
    private List g = new ArrayList();
    private List h = new ArrayList();
    private List i = new ArrayList();
    private Map j = new HashMap();
    private SignerInfoGenerator k;

    public TimeStampTokenGenerator(SignerInfoGenerator signerInfoGenerator, DigestCalculator digestCalculator, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IllegalArgumentException, TSPException {
        this(signerInfoGenerator, digestCalculator, aSN1ObjectIdentifier, false);
    }

    public TimeStampTokenGenerator(SignerInfoGenerator signerInfoGenerator, DigestCalculator digestCalculator, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2) throws IllegalArgumentException, TSPException {
        this.k = signerInfoGenerator;
        this.f = aSN1ObjectIdentifier;
        if (!signerInfoGenerator.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("SignerInfoGenerator must have an associated certificate");
        }
        X509CertificateHolder x509CertificateHolder = signerInfoGenerator.getAssociatedCertificate();
        TSPUtil.validateCertificate(x509CertificateHolder);
        try {
            OutputStream outputStream = digestCalculator.getOutputStream();
            outputStream.write(x509CertificateHolder.getEncoded());
            outputStream.close();
            if (digestCalculator.getAlgorithmIdentifier().getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
                ESSCertID eSSCertID = new ESSCertID(digestCalculator.getDigest(), bl2 ? new IssuerSerial(new GeneralNames(new GeneralName(x509CertificateHolder.getIssuer())), x509CertificateHolder.getSerialNumber()) : null);
                this.k = new SignerInfoGenerator(signerInfoGenerator, new a(this, signerInfoGenerator, eSSCertID), signerInfoGenerator.getUnsignedAttributeTableGenerator());
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestCalculator.getAlgorithmIdentifier().getAlgorithm());
                ESSCertIDv2 eSSCertIDv2 = new ESSCertIDv2(algorithmIdentifier, digestCalculator.getDigest(), bl2 ? new IssuerSerial(new GeneralNames(new GeneralName(x509CertificateHolder.getIssuer())), new ASN1Integer(x509CertificateHolder.getSerialNumber())) : null);
                this.k = new SignerInfoGenerator(signerInfoGenerator, new b(this, signerInfoGenerator, eSSCertIDv2), signerInfoGenerator.getUnsignedAttributeTableGenerator());
            }
        }
        catch (IOException iOException) {
            throw new TSPException("Exception processing certificate.", iOException);
        }
    }

    public void addCertificates(Store store) {
        this.g.addAll(store.getMatches(null));
    }

    public void addCRLs(Store store) {
        this.h.addAll(store.getMatches(null));
    }

    public void addAttributeCertificates(Store store) {
        this.i.addAll(store.getMatches(null));
    }

    public void addOtherRevocationInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, Store store) {
        this.j.put(aSN1ObjectIdentifier, store.getMatches(null));
    }

    public void setResolution(int n2) {
        this.a = n2;
    }

    public void setLocale(Locale locale) {
        this.b = locale;
    }

    public void setAccuracySeconds(int n2) {
        this.c = n2;
    }

    public void setAccuracyMillis(int n2) {
        this.d = n2;
    }

    public void setAccuracyMicros(int n2) {
        this.e = n2;
    }

    public void setOrdering(boolean bl2) {
        this.ordering = bl2;
    }

    public void setTSA(GeneralName generalName) {
        this.tsa = generalName;
    }

    public TimeStampToken generate(TimeStampRequest timeStampRequest, BigInteger bigInteger, Date date) throws TSPException {
        return this.generate(timeStampRequest, bigInteger, date, null);
    }

    public TimeStampToken generate(TimeStampRequest timeStampRequest, BigInteger bigInteger, Date date, Extensions extensions) throws TSPException {
        Object object;
        Object object2;
        ASN1Primitive aSN1Primitive;
        ASN1Integer aSN1Integer;
        ASN1Primitive aSN1Primitive2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = timeStampRequest.getMessageImprintAlgOID();
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
        MessageImprint messageImprint = new MessageImprint(algorithmIdentifier, timeStampRequest.getMessageImprintDigest());
        Accuracy accuracy = null;
        if (this.c > 0 || this.d > 0 || this.e > 0) {
            aSN1Primitive2 = null;
            if (this.c > 0) {
                aSN1Primitive2 = new ASN1Integer(this.c);
            }
            aSN1Integer = null;
            if (this.d > 0) {
                aSN1Integer = new ASN1Integer(this.d);
            }
            aSN1Primitive = null;
            if (this.e > 0) {
                aSN1Primitive = new ASN1Integer(this.e);
            }
            accuracy = new Accuracy((ASN1Integer)aSN1Primitive2, aSN1Integer, (ASN1Integer)aSN1Primitive);
        }
        aSN1Primitive2 = null;
        if (this.ordering) {
            aSN1Primitive2 = ASN1Boolean.getInstance(this.ordering);
        }
        aSN1Integer = null;
        if (timeStampRequest.getNonce() != null) {
            aSN1Integer = new ASN1Integer(timeStampRequest.getNonce());
        }
        aSN1Primitive = this.f;
        if (timeStampRequest.getReqPolicy() != null) {
            aSN1Primitive = timeStampRequest.getReqPolicy();
        }
        Extensions extensions2 = timeStampRequest.getExtensions();
        if (extensions != null) {
            object2 = new ExtensionsGenerator();
            if (extensions2 != null) {
                object = extensions2.oids();
                while (object.hasMoreElements()) {
                    ((ExtensionsGenerator)object2).addExtension(extensions2.getExtension(ASN1ObjectIdentifier.getInstance(object.nextElement())));
                }
            }
            object = extensions.oids();
            while (object.hasMoreElements()) {
                ((ExtensionsGenerator)object2).addExtension(extensions.getExtension(ASN1ObjectIdentifier.getInstance(object.nextElement())));
            }
            extensions2 = ((ExtensionsGenerator)object2).generate();
        }
        object2 = this.a == 0 ? (this.b == null ? new ASN1GeneralizedTime(date) : new ASN1GeneralizedTime(date, this.b)) : this.a(date);
        object = new TSTInfo((ASN1ObjectIdentifier)aSN1Primitive, messageImprint, new ASN1Integer(bigInteger), (ASN1GeneralizedTime)object2, accuracy, (ASN1Boolean)aSN1Primitive2, aSN1Integer, this.tsa, extensions2);
        try {
            Encodable encodable2;
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            if (timeStampRequest.getCertReq()) {
                cMSSignedDataGenerator.addCertificates(new CollectionStore(this.g));
                cMSSignedDataGenerator.addAttributeCertificates(new CollectionStore(this.i));
            }
            cMSSignedDataGenerator.addCRLs(new CollectionStore(this.h));
            if (!this.j.isEmpty()) {
                for (Encodable encodable2 : this.j.keySet()) {
                    cMSSignedDataGenerator.addOtherRevocationInfo((ASN1ObjectIdentifier)encodable2, new CollectionStore((Collection)this.j.get(encodable2)));
                }
            }
            cMSSignedDataGenerator.addSignerInfoGenerator(this.k);
            Object object3 = ((ASN1Object)object).getEncoded("DER");
            encodable2 = cMSSignedDataGenerator.generate(new CMSProcessableByteArray(PKCSObjectIdentifiers.id_ct_TSTInfo, (byte[])object3), true);
            return new TimeStampToken((CMSSignedData)encodable2);
        }
        catch (CMSException cMSException) {
            throw new TSPException("Error generating time-stamp token", cMSException);
        }
        catch (IOException iOException) {
            throw new TSPException("Exception encoding info", iOException);
        }
    }

    private ASN1GeneralizedTime a(Date date) throws TSPException {
        String string = "yyyyMMddHHmmss.SSS";
        SimpleDateFormat simpleDateFormat = this.b == null ? new SimpleDateFormat(string) : new SimpleDateFormat(string, this.b);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(date));
        int n2 = stringBuilder.indexOf(".");
        if (n2 < 0) {
            stringBuilder.append("Z");
            return new ASN1GeneralizedTime(stringBuilder.toString());
        }
        switch (this.a) {
            case 1: {
                if (stringBuilder.length() <= n2 + 2) break;
                stringBuilder.delete(n2 + 2, stringBuilder.length());
                break;
            }
            case 2: {
                if (stringBuilder.length() <= n2 + 3) break;
                stringBuilder.delete(n2 + 3, stringBuilder.length());
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new TSPException("unknown time-stamp resolution: " + this.a);
            }
        }
        while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (stringBuilder.length() - 1 == n2) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("Z");
        return new ASN1GeneralizedTime(stringBuilder.toString());
    }
}

