/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.x509;

import com.aspose.imaging.internal.bouncycastle.util.Selector;
import com.aspose.imaging.internal.bouncycastle.util.Store;
import com.aspose.imaging.internal.bouncycastle.x509.PKIXAttrCertChecker;
import com.aspose.imaging.internal.bouncycastle.x509.X509CertStoreSelector;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ExtendedPKIXParameters
extends PKIXParameters {
    private List a = new ArrayList();
    private Selector b;
    private boolean c;
    private List d = new ArrayList();
    private Set e = new HashSet();
    private Set f = new HashSet();
    private Set g = new HashSet();
    private Set h = new HashSet();
    public static final int PKIX_VALIDITY_MODEL = 0;
    public static final int CHAIN_VALIDITY_MODEL = 1;
    private int i = 0;
    private boolean j = false;

    public ExtendedPKIXParameters(Set set) throws InvalidAlgorithmParameterException {
        super(set);
    }

    public static ExtendedPKIXParameters getInstance(PKIXParameters pKIXParameters) {
        ExtendedPKIXParameters extendedPKIXParameters;
        try {
            extendedPKIXParameters = new ExtendedPKIXParameters((Set)pKIXParameters.getTrustAnchors());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        extendedPKIXParameters.setParams(pKIXParameters);
        return extendedPKIXParameters;
    }

    protected void setParams(PKIXParameters pKIXParameters) {
        this.setDate(pKIXParameters.getDate());
        this.setCertPathCheckers(pKIXParameters.getCertPathCheckers());
        this.setCertStores((List)pKIXParameters.getCertStores());
        this.setAnyPolicyInhibited(pKIXParameters.isAnyPolicyInhibited());
        this.setExplicitPolicyRequired(pKIXParameters.isExplicitPolicyRequired());
        this.setPolicyMappingInhibited(pKIXParameters.isPolicyMappingInhibited());
        this.setRevocationEnabled(pKIXParameters.isRevocationEnabled());
        this.setInitialPolicies(pKIXParameters.getInitialPolicies());
        this.setPolicyQualifiersRejected(pKIXParameters.getPolicyQualifiersRejected());
        this.setSigProvider(pKIXParameters.getSigProvider());
        this.setTargetCertConstraints(pKIXParameters.getTargetCertConstraints());
        try {
            this.setTrustAnchors(pKIXParameters.getTrustAnchors());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        if (pKIXParameters instanceof ExtendedPKIXParameters) {
            ExtendedPKIXParameters extendedPKIXParameters = (ExtendedPKIXParameters)pKIXParameters;
            this.i = extendedPKIXParameters.i;
            this.j = extendedPKIXParameters.j;
            this.c = extendedPKIXParameters.c;
            this.b = extendedPKIXParameters.b == null ? null : (Selector)extendedPKIXParameters.b.clone();
            this.a = new ArrayList(extendedPKIXParameters.a);
            this.d = new ArrayList(extendedPKIXParameters.d);
            this.e = new HashSet(extendedPKIXParameters.e);
            this.g = new HashSet(extendedPKIXParameters.g);
            this.f = new HashSet(extendedPKIXParameters.f);
            this.h = new HashSet(extendedPKIXParameters.h);
        }
    }

    public boolean isUseDeltasEnabled() {
        return this.j;
    }

    public void setUseDeltasEnabled(boolean bl2) {
        this.j = bl2;
    }

    public int getValidityModel() {
        return this.i;
    }

    public void setCertStores(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addCertStore((CertStore)iterator.next());
            }
        }
    }

    public void setStores(List list) {
        if (list == null) {
            this.a = new ArrayList();
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof Store) continue;
                throw new ClassCastException("All elements of list must be of type org.bouncycastle.util.Store.");
            }
            this.a = new ArrayList(list);
        }
    }

    public void addStore(Store store) {
        if (store != null) {
            this.a.add(store);
        }
    }

    public void addAdditionalStore(Store store) {
        if (store != null) {
            this.d.add(store);
        }
    }

    public void addAddionalStore(Store store) {
        this.addAdditionalStore(store);
    }

    public List getAdditionalStores() {
        return Collections.unmodifiableList(this.d);
    }

    public List getStores() {
        return Collections.unmodifiableList(new ArrayList(this.a));
    }

    public void setValidityModel(int n2) {
        this.i = n2;
    }

    @Override
    public Object clone() {
        ExtendedPKIXParameters extendedPKIXParameters;
        try {
            extendedPKIXParameters = new ExtendedPKIXParameters((Set)this.getTrustAnchors());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        extendedPKIXParameters.setParams(this);
        return extendedPKIXParameters;
    }

    public boolean isAdditionalLocationsEnabled() {
        return this.c;
    }

    public void setAdditionalLocationsEnabled(boolean bl2) {
        this.c = bl2;
    }

    public Selector getTargetConstraints() {
        if (this.b != null) {
            return (Selector)this.b.clone();
        }
        return null;
    }

    public void setTargetConstraints(Selector selector) {
        this.b = selector != null ? (Selector)selector.clone() : null;
    }

    @Override
    public void setTargetCertConstraints(CertSelector certSelector) {
        super.setTargetCertConstraints(certSelector);
        this.b = certSelector != null ? X509CertStoreSelector.getInstance((X509CertSelector)certSelector) : null;
    }

    public Set getTrustedACIssuers() {
        return Collections.unmodifiableSet(this.e);
    }

    public void setTrustedACIssuers(Set set) {
        if (set == null) {
            this.e.clear();
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof TrustAnchor) continue;
            throw new ClassCastException("All elements of set must be of type " + TrustAnchor.class.getName() + ".");
        }
        this.e.clear();
        this.e.addAll(set);
    }

    public Set getNecessaryACAttributes() {
        return Collections.unmodifiableSet(this.f);
    }

    public void setNecessaryACAttributes(Set set) {
        if (set == null) {
            this.f.clear();
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof String) continue;
            throw new ClassCastException("All elements of set must be of type String.");
        }
        this.f.clear();
        this.f.addAll(set);
    }

    public Set getProhibitedACAttributes() {
        return Collections.unmodifiableSet(this.g);
    }

    public void setProhibitedACAttributes(Set set) {
        if (set == null) {
            this.g.clear();
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof String) continue;
            throw new ClassCastException("All elements of set must be of type String.");
        }
        this.g.clear();
        this.g.addAll(set);
    }

    public Set getAttrCertCheckers() {
        return Collections.unmodifiableSet(this.h);
    }

    public void setAttrCertCheckers(Set set) {
        if (set == null) {
            this.h.clear();
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof PKIXAttrCertChecker) continue;
            throw new ClassCastException("All elements of set must be of type " + PKIXAttrCertChecker.class.getName() + ".");
        }
        this.h.clear();
        this.h.addAll(set);
    }
}

