/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERBitString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.CertificateList;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.TBSCertList;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Time;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.X509Extensions;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.X509Name;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.imaging.internal.bouncycastle.jce.X509Principal;
import com.aspose.imaging.internal.bouncycastle.jce.provider.X509CRLObject;
import com.aspose.imaging.internal.bouncycastle.x509.e;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509V2CRLGenerator {
    private final JcaJceHelper a = new BCJcaJceHelper();
    private V2TBSCertListGenerator b = new V2TBSCertListGenerator();
    private ASN1ObjectIdentifier c;
    private AlgorithmIdentifier d;
    private String e;
    private X509ExtensionsGenerator f = new X509ExtensionsGenerator();

    public void reset() {
        this.b = new V2TBSCertListGenerator();
        this.f.reset();
    }

    public void setIssuerDN(X500Principal x500Principal) {
        try {
            this.b.setIssuer(new X509Principal(x500Principal.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't process principal: " + iOException);
        }
    }

    public void setIssuerDN(X509Name x509Name) {
        this.b.setIssuer(x509Name);
    }

    public void setThisUpdate(Date date) {
        this.b.setThisUpdate(new Time(date));
    }

    public void setNextUpdate(Date date) {
        this.b.setNextUpdate(new Time(date));
    }

    public void addCRLEntry(BigInteger bigInteger, Date date, int n2) {
        this.b.addCRLEntry(new ASN1Integer(bigInteger), new Time(date), n2);
    }

    public void addCRLEntry(BigInteger bigInteger, Date date, int n2, Date date2) {
        this.b.addCRLEntry(new ASN1Integer(bigInteger), new Time(date), n2, new ASN1GeneralizedTime(date2));
    }

    public void addCRLEntry(BigInteger bigInteger, Date date, X509Extensions x509Extensions) {
        this.b.addCRLEntry(new ASN1Integer(bigInteger), new Time(date), Extensions.getInstance(x509Extensions));
    }

    public void addCRL(X509CRL x509CRL) throws CRLException {
        Set<? extends X509CRLEntry> set = x509CRL.getRevokedCertificates();
        if (set != null) {
            for (X509CRLEntry x509CRLEntry : set) {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(x509CRLEntry.getEncoded());
                try {
                    this.b.addCRLEntry(ASN1Sequence.getInstance(aSN1InputStream.readObject()));
                }
                catch (IOException iOException) {
                    throw new CRLException("exception processing encoding of CRL: " + iOException.toString());
                }
            }
        }
    }

    public void setSignatureAlgorithm(String string) {
        this.e = string;
        try {
            this.c = com.aspose.imaging.internal.bouncycastle.x509.e.a(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.d = com.aspose.imaging.internal.bouncycastle.x509.e.a(this.c, string);
        this.b.setSignature(this.d);
    }

    public void addExtension(String string, boolean bl2, ASN1Encodable aSN1Encodable) {
        this.addExtension(new ASN1ObjectIdentifier(string), bl2, aSN1Encodable);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) {
        this.f.addExtension(new ASN1ObjectIdentifier(aSN1ObjectIdentifier.getId()), bl2, aSN1Encodable);
    }

    public void addExtension(String string, boolean bl2, byte[] byArray) {
        this.addExtension(new ASN1ObjectIdentifier(string), bl2, byArray);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, byte[] byArray) {
        this.f.addExtension(new ASN1ObjectIdentifier(aSN1ObjectIdentifier.getId()), bl2, byArray);
    }

    public X509CRL generateX509CRL(PrivateKey privateKey) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509CRL(privateKey, "BC", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, SecureRandom secureRandom) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509CRL(privateKey, "BC", secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, String string) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateX509CRL(privateKey, string, null);
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, String string, SecureRandom secureRandom) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generate(privateKey, string, secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException("exception: " + generalSecurityException);
        }
    }

    public X509CRL generate(PrivateKey privateKey) throws CRLException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(privateKey, (SecureRandom)null);
    }

    public X509CRL generate(PrivateKey privateKey, SecureRandom secureRandom) throws CRLException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] byArray;
        TBSCertList tBSCertList = this.a();
        try {
            byArray = com.aspose.imaging.internal.bouncycastle.x509.e.a(this.c, this.e, privateKey, secureRandom, tBSCertList);
        }
        catch (IOException iOException) {
            throw new a("cannot generate CRL encoding", iOException);
        }
        return this.a(tBSCertList, byArray);
    }

    public X509CRL generate(PrivateKey privateKey, String string) throws CRLException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(privateKey, string, null);
    }

    public X509CRL generate(PrivateKey privateKey, String string, SecureRandom secureRandom) throws CRLException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] byArray;
        TBSCertList tBSCertList = this.a();
        try {
            byArray = com.aspose.imaging.internal.bouncycastle.x509.e.a(this.c, this.e, string, privateKey, secureRandom, tBSCertList);
        }
        catch (IOException iOException) {
            throw new a("cannot generate CRL encoding", iOException);
        }
        return this.a(tBSCertList, byArray);
    }

    private TBSCertList a() {
        if (!this.f.isEmpty()) {
            this.b.setExtensions(this.f.generate());
        }
        return this.b.generateTBSCertList();
    }

    private X509CRL a(TBSCertList tBSCertList, byte[] byArray) throws CRLException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(tBSCertList);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(new DERBitString(byArray));
        return new X509CRLObject(new CertificateList(new DERSequence(aSN1EncodableVector)));
    }

    public Iterator getSignatureAlgNames() {
        return com.aspose.imaging.internal.bouncycastle.x509.e.a();
    }

    private static class a
    extends CRLException {
        Throwable a;

        a(String string, Throwable throwable) {
            super(string);
            this.a = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.a;
        }
    }
}

