/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.AnnotationSelector;
import com.aspose.pdf.Border;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.MarkupAnnotation;
import com.aspose.pdf.Matrix;
import com.aspose.pdf.Operator;
import com.aspose.pdf.Page;
import com.aspose.pdf.Point;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XfdfReader;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z172;
import com.aspose.pdf.internal.ms.System.z61;
import com.aspose.pdf.internal.ms.System.z85;
import com.aspose.pdf.internal.p15.z1;
import com.aspose.pdf.internal.p600.z17;
import com.aspose.pdf.internal.p613.z48;
import com.aspose.pdf.internal.p643.z400;
import com.aspose.pdf.internal.p643.z553;
import com.aspose.pdf.internal.p643.z585;
import com.aspose.pdf.internal.p68.z13;
import com.aspose.pdf.internal.p68.z14;
import com.aspose.pdf.internal.p68.z16;
import com.aspose.pdf.internal.p68.z22;
import com.aspose.pdf.internal.p68.z27;
import com.aspose.pdf.internal.p68.z29;
import com.aspose.pdf.internal.p68.z5;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class InkAnnotation
extends MarkupAnnotation {
    private static final String m5 = "Aspose_CapStyle";
    private int m6 = 1;

    @Override
    void m1(z585 z5852) {
        z5852.m16("ink");
        this.m2(z5852);
        if (this.getEngineDict().m4("BS")) {
            this.getBorder().m1(z5852);
        }
        if (this.getEngineDict().m4("InkList")) {
            z5852.m16("inklist");
            for (Point[] pointArray : this.getInkList()) {
                z5852.m16("gesture");
                StringBuilder stringBuilder = new StringBuilder();
                for (Point point : pointArray) {
                    stringBuilder.append(z133.m1(this.m2, "{0},{1};", point.getX(), point.getY()));
                }
                stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                z5852.m5(stringBuilder.toString());
                z5852.m10();
            }
        } else {
            throw new IllegalStateException("Required entry is absent in annotation dictionary");
        }
        z5852.m10();
        this.m3(z5852);
        z5852.m10();
    }

    public int getCapStyle() {
        z13 z1338;
        if (this.getEngineDict() == null) {
            return this.m6;
        }
        if (this.getEngineDict().m4(m5) && (z1338 = this.getEngineDict().m2(m5).m66()) != null) {
            this.m6 = (int)z1338.m8();
        }
        return this.m6;
    }

    public void setCapStyle(int value) {
        this.m6 = value;
        if (this.getEngineDict() != null) {
            this.getEngineDict().m1(m5, (z16)new z29(this.m6));
            this.updateAppearances();
        }
    }

    @Override
    void m1(z400 z4002) {
        z17<Point[]> z1710;
        this.m2(z4002);
        this.setBorder(new Border(this));
        this.getBorder().m1(z4002);
        z1<String, String> z1338 = XfdfReader.m1(z4002);
        if (z1338.containsKey("inklist")) {
            z553 z5532 = new z553(new z48((String)z1338.get_Item("inklist")));
            z5532.m8();
            z1710 = new z17<Point[]>();
            while (z5532.m8()) {
                if (z5532.m26() != 1 || !"gesture".equals(z5532.m23())) continue;
                String[] stringArray = z133.m6(z5532.dH_(), ';');
                Point[] pointArray = new Point[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = z133.m6(stringArray[i], ',');
                    pointArray[i] = new Point(z61.m1(stringArray2[0], (z85)this.m2), z61.m1(stringArray2[1], (z85)this.m2));
                }
                z1710.addItem(pointArray);
            }
        } else {
            throw new IllegalStateException("Required attribute is absent in XFDF stream");
        }
        this.setInkList(z1710);
        this.m1(z1338);
    }

    @Override
    public void accept(AnnotationSelector visitor) {
        visitor.visit(this);
    }

    InkAnnotation(z14 engineAnnot, IDocument document) {
        super(engineAnnot, document);
    }

    public InkAnnotation(IDocument document, List<Point[]> inkList) {
        super(document);
        this.getEngineDict().m2("Subtype", (z16)new z27("Ink"));
        ArrayList<Point[]> arrayList = new ArrayList<Point[]>();
        for (Point[] pointArray : inkList) {
            arrayList.add(pointArray);
        }
        this.setInkList(arrayList);
        Rectangle rectangle = this.m16();
        this.setWidth(rectangle.getWidth());
        this.setHeight(rectangle.getHeight());
    }

    private Rectangle m16() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        Iterator iterator = this.getInkList().iterator();
        while (iterator.hasNext()) {
            Point[] pointArray;
            for (Point point : pointArray = (Point[])iterator.next()) {
                if (bl) {
                    d3 = d = point.getX();
                    d4 = d2 = point.getY();
                } else {
                    d = z172.m4(d, point.getX());
                    d2 = z172.m4(d2, point.getY());
                    d3 = z172.m3(d3, point.getX());
                    d4 = z172.m3(d4, point.getY());
                }
                bl = false;
            }
        }
        return new Rectangle(d, d2, d3, d4);
    }

    @Override
    void m2(Page page, Rectangle rectangle) {
        this.setRect(new Rectangle(page.getRect().getLLX(), page.getRect().getLLY(), page.getRect().getURX(), page.getRect().getURY()));
        Rectangle rectangle2 = this.m16();
        double d = rectangle.getLLX() - rectangle2.getLLX();
        double d2 = rectangle.getLLY() - rectangle2.getLLY();
        z17<Point[]> z1710 = new z17<Point[]>();
        for (Point[] pointArray : this.getInkList()) {
            Point[] pointArray2 = new Point[pointArray.length];
            int n = 0;
            for (Point point : pointArray) {
                pointArray2[n++] = new Point(point.getX() + d, point.getY() + d2);
            }
            z1710.add(pointArray2);
        }
        this.setInkList(z1710);
        this.updateAppearances();
    }

    public InkAnnotation(Page page, Rectangle rect, List<Point[]> inkList) {
        super(page, rect);
        this.getEngineDict().m2("Subtype", (z16)new z27("Ink"));
        this.setInkList(inkList);
    }

    public List<Point[]> getInkList() {
        if (!this.getEngineDict().m4("InkList")) {
            return null;
        }
        ArrayList<Point[]> arrayList = new ArrayList<Point[]>();
        z5 z5100 = this.getEngineDict().m3("InkList").m61();
        for (z16 z1610 : z5100) {
            z5 z5101 = z1610.m61();
            int n = z5101.m9() / 2;
            Point[] pointArray = new Point[n];
            for (int i = 0; i < n; ++i) {
                pointArray[i] = new Point(z5101.m1(2 * i).m66().m8(), z5101.m1(2 * i + 1).m66().m8());
            }
            arrayList.add(pointArray);
        }
        return arrayList;
    }

    public void setInkList(List<Point[]> value) {
        if (value != null) {
            z22 z2210 = new z22(this.getEngineDict());
            for (Point[] pointArray : value) {
                z22 z2211 = new z22(this.getEngineDict());
                for (Point point : pointArray) {
                    z2211.m1((z16)new z29(point.getX()));
                    z2211.m1((z16)new z29(point.getY()));
                }
                z2210.m1((z16)z2211);
            }
            this.getEngineDict().m1("InkList", (z16)z2210);
        }
    }

    @Override
    boolean m5() {
        return true;
    }

    @Override
    List<Operator> m2(Annotation.z1 z1338, Annotation annotation) {
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        arrayList.add(new Operator.GSave());
        arrayList.add(new Operator.SetRGBColorStroke(this.getColor().toRgb()));
        if (this.getEngineDict().m4("BS") && this.getEngineDict().m2("BS").m60() != null && this.getEngineDict().m2("BS").m60().m4("W") && this.getEngineDict().m2("BS").m60().m2("W").m66() != null) {
            arrayList.add(new Operator.SetLineWidth(this.getEngineDict().m2("BS").m60().m2("W").m66().m8()));
        }
        if (this.getOpacity() < 1.0) {
            arrayList.add(new Operator.GS("opacity"));
        }
        switch (this.getCapStyle()) {
            case 2: {
                arrayList.add(new Operator.SetLineCap(1));
                arrayList.add(new Operator.SetLineJoin(1));
            }
        }
        if (this.getInkList() != null) {
            Iterator<Point[]> iterator = this.getInkList().iterator();
            while (iterator.hasNext()) {
                Point[] pointArray;
                Point[] pointArray2 = pointArray = iterator.next();
                boolean bl = true;
                for (Point point : pointArray2) {
                    if (bl) {
                        arrayList.add(new Operator.MoveTo(point.getX(), point.getY()));
                    } else {
                        arrayList.add(new Operator.LineTo(point.getX(), point.getY()));
                    }
                    bl = false;
                }
            }
        }
        arrayList.add(new Operator.Stroke());
        arrayList.add(new Operator.GRestore());
        return arrayList;
    }

    @Override
    public int getAnnotationType() {
        return 12;
    }

    @Override
    XForm m1(String string, Annotation annotation) {
        XForm xForm = super.m1(string, annotation);
        Rectangle rectangle = null;
        if (this.getInkList() != null) {
            Iterator iterator = this.getInkList().iterator();
            while (iterator.hasNext()) {
                Point[] pointArray;
                for (Point point : pointArray = (Point[])iterator.next()) {
                    if (rectangle == null) {
                        rectangle = new Rectangle(point.getX(), point.getY(), point.getX(), point.getY());
                        continue;
                    }
                    double d = z172.m4(rectangle.getLLX(), point.getX());
                    double d2 = z172.m4(rectangle.getLLY(), point.getY());
                    double d3 = z172.m3(rectangle.getURX(), point.getX());
                    double d4 = z172.m3(rectangle.getURY(), point.getY());
                    rectangle.setLLX(d);
                    rectangle.setLLY(d2);
                    rectangle.setURX(d3);
                    rectangle.setURY(d4);
                }
            }
            if (this.getBorder() != null) {
                rectangle = new Rectangle(rectangle.getLLX() - (double)this.getBorder().getWidth(), rectangle.getLLY() - (double)this.getBorder().getWidth(), rectangle.getURX() + (double)this.getBorder().getWidth(), rectangle.getURY() + (double)this.getBorder().getWidth());
            }
            rectangle = new Rectangle(z172.m4(rectangle.getLLX(), this.getRect().getLLX()), z172.m4(rectangle.getLLY(), this.getRect().getLLY()), z172.m3(rectangle.getURX(), this.getRect().getURX()), z172.m3(rectangle.getURY(), this.getRect().getURY()));
            xForm.setBBox(rectangle);
            this.setRect(rectangle);
            xForm.setMatrix(new Matrix(1.0, 0.0, 0.0, 1.0, -rectangle.getLLX(), -rectangle.getLLY()));
        }
        return xForm;
    }
}

