/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.IDocument;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.SaveOptions;
import com.aspose.pdf.facades.APdfFileEditor;
import com.aspose.pdf.internal.ms.System.z72;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public interface IPdfFileEditor {
    public String getConversionLog();

    public boolean getMergeDuplicateLayers();

    public void setMergeDuplicateLayers(boolean var1);

    public boolean getMergeDuplicateOutlines();

    public void setMergeDuplicateOutlines(boolean var1);

    public boolean getPreserveUserRights();

    public void setPreserveUserRights(boolean var1);

    public boolean getIncrementalUpdates();

    public void setIncrementalUpdates(boolean var1);

    public int getCorruptedFileAction();

    public void setCorruptedFileAction(int var1);

    public String getOwnerPassword();

    public void setOwnerPassword(String var1);

    public boolean getAllowConcatenateExceptions();

    public void setAllowConcatenateExceptions(boolean var1);

    public void setConvertTo(int var1);

    public boolean getCloseConcatenatedStreams();

    public void setCloseConcatenatedStreams(boolean var1);

    public String getUniqueSuffix();

    public void setUniqueSuffix(String var1);

    public boolean getKeepFieldsUnique();

    public void setKeepFieldsUnique(boolean var1);

    public boolean concatenate(String var1, String var2, String var3);

    public boolean concatenate(InputStream var1, InputStream var2, OutputStream var3);

    public boolean concatenate(IDocument[] var1, IDocument var2);

    public boolean concatenate(String[] var1, String var2);

    public boolean concatenate(InputStream[] var1, OutputStream var2);

    public boolean concatenate(String var1, String var2, String var3, String var4);

    public boolean concatenate(InputStream var1, InputStream var2, InputStream var3, OutputStream var4);

    public boolean append(InputStream var1, InputStream[] var2, int var3, int var4, OutputStream var5);

    public boolean append(String var1, String[] var2, int var3, int var4, String var5);

    public boolean append(String var1, String var2, int var3, int var4, String var5);

    public boolean append(InputStream var1, InputStream var2, int var3, int var4, OutputStream var5);

    public boolean insert(String var1, int var2, String var3, int var4, int var5, String var6);

    public boolean insert(InputStream var1, int var2, InputStream var3, int var4, int var5, OutputStream var6);

    public boolean insert(String var1, int var2, String var3, int[] var4, String var5);

    public boolean insert(InputStream var1, int var2, InputStream var3, int[] var4, OutputStream var5);

    public boolean delete(String var1, int[] var2, String var3);

    public boolean delete(InputStream var1, int[] var2, OutputStream var3);

    public boolean extract(String var1, int var2, int var3, String var4);

    public boolean extract(String var1, int[] var2, String var3);

    public boolean extract(InputStream var1, int var2, int var3, OutputStream var4);

    public boolean extract(InputStream var1, int[] var2, OutputStream var3);

    public boolean splitFromFirst(String var1, int var2, String var3);

    public boolean splitFromFirst(InputStream var1, int var2, OutputStream var3);

    public boolean splitToEnd(String var1, int var2, String var3);

    public boolean splitToEnd(InputStream var1, int var2, OutputStream var3);

    public boolean makeBooklet(String var1, String var2);

    public boolean makeBooklet(InputStream var1, OutputStream var2);

    public boolean makeBooklet(String var1, String var2, PageSize var3);

    public boolean makeBooklet(InputStream var1, OutputStream var2, PageSize var3);

    public boolean makeBooklet(String var1, String var2, int[] var3, int[] var4);

    public boolean makeBooklet(InputStream var1, OutputStream var2, int[] var3, int[] var4);

    public boolean makeBooklet(String var1, String var2, PageSize var3, int[] var4, int[] var5);

    public boolean makeBooklet(InputStream var1, OutputStream var2, PageSize var3, int[] var4, int[] var5);

    public boolean makeNUp(String var1, String var2, int var3, int var4);

    public boolean makeNUp(InputStream var1, OutputStream var2, int var3, int var4);

    public boolean makeNUp(InputStream var1, OutputStream var2, int var3, int var4, PageSize var5);

    public boolean makeNUp(String var1, String var2, String var3);

    public boolean makeNUp(InputStream var1, InputStream var2, OutputStream var3);

    public boolean makeNUp(String[] var1, String var2, boolean var3);

    public boolean makeNUp(InputStream[] var1, OutputStream var2, boolean var3);

    public boolean makeNUp(String var1, String var2, int var3, int var4, PageSize var5);

    public ByteArrayInputStream[] splitToPages(String var1);

    public void splitToPages(String var1, String var2);

    public void splitToPages(InputStream var1, String var2);

    public ByteArrayInputStream[] splitToPages(InputStream var1);

    public ByteArrayInputStream[] splitToBulks(String var1, int[][] var2);

    public ByteArrayInputStream[] splitToBulks(InputStream var1, int[][] var2);

    public Exception getLastException();

    public boolean resizeContents(InputStream var1, OutputStream var2, int[] var3, double var4, double var6);

    public boolean resizeContentsPct(InputStream var1, OutputStream var2, int[] var3, double var4, double var6);

    public boolean addMargins(InputStream var1, OutputStream var2, int[] var3, double var4, double var6, double var8, double var10);

    public boolean addMarginsPct(InputStream var1, OutputStream var2, int[] var3, double var4, double var6, double var8, double var10);

    public boolean resizeContents(String var1, String var2, int[] var3, double var4, double var6);

    public boolean resizeContentsPct(String var1, String var2, int[] var3, double var4, double var6);

    public boolean addMargins(String var1, String var2, int[] var3, double var4, double var6, double var8, double var10);

    public boolean addMarginsPct(String var1, String var2, int[] var3, double var4, double var6, double var8, double var10);

    public int getContentDisposition();

    public void setContentDisposition(int var1);

    public SaveOptions getSaveOptions();

    public void setSaveOptions(SaveOptions var1);

    public String getAttachmentName();

    public void setAttachmentName(String var1);

    public static class ContentsResizeParameters {
        private APdfFileEditor.ContentsResizeValue m1 = APdfFileEditor.ContentsResizeValue.auto();
        private APdfFileEditor.ContentsResizeValue m2 = APdfFileEditor.ContentsResizeValue.auto();
        private APdfFileEditor.ContentsResizeValue m3 = APdfFileEditor.ContentsResizeValue.auto();
        private APdfFileEditor.ContentsResizeValue m4 = APdfFileEditor.ContentsResizeValue.auto();
        private APdfFileEditor.ContentsResizeValue m5 = APdfFileEditor.ContentsResizeValue.auto();
        private APdfFileEditor.ContentsResizeValue m6 = APdfFileEditor.ContentsResizeValue.auto();

        public APdfFileEditor.ContentsResizeValue getLeftMargin() {
            return this.m1;
        }

        public void setLeftMargin(APdfFileEditor.ContentsResizeValue value) {
            this.m1 = value;
        }

        public APdfFileEditor.ContentsResizeValue getRightMargin() {
            return this.m3;
        }

        public void setRightMargin(APdfFileEditor.ContentsResizeValue value) {
            this.m3 = value;
        }

        public APdfFileEditor.ContentsResizeValue getTopMargin() {
            return this.m4;
        }

        public void setTopMargin(APdfFileEditor.ContentsResizeValue value) {
            this.m4 = value;
        }

        public APdfFileEditor.ContentsResizeValue getBottomMargin() {
            return this.m6;
        }

        public void setBottomMargin(APdfFileEditor.ContentsResizeValue value) {
            this.m6 = value;
        }

        public APdfFileEditor.ContentsResizeValue getContentsWidth() {
            return this.m2;
        }

        public void setContentsWidth(APdfFileEditor.ContentsResizeValue value) {
            this.m2 = value;
        }

        public APdfFileEditor.ContentsResizeValue getContentsHeight() {
            return this.m5;
        }

        public void setContentsHeight(APdfFileEditor.ContentsResizeValue value) {
            this.m5 = value;
        }

        public ContentsResizeParameters() {
        }

        public ContentsResizeParameters(APdfFileEditor.ContentsResizeValue leftMargin, APdfFileEditor.ContentsResizeValue contentsWidth, APdfFileEditor.ContentsResizeValue rightMargin, APdfFileEditor.ContentsResizeValue topMargin, APdfFileEditor.ContentsResizeValue contentsHeight, APdfFileEditor.ContentsResizeValue bottomMargin) {
            this.setLeftMargin(leftMargin);
            this.setRightMargin(rightMargin);
            this.setContentsWidth(contentsWidth);
            this.setTopMargin(topMargin);
            this.setContentsHeight(contentsHeight);
            this.setBottomMargin(bottomMargin);
        }

        public static ContentsResizeParameters margins(double left, double right, double top, double bottom) {
            return new ContentsResizeParameters(APdfFileEditor.ContentsResizeValue.units(left), APdfFileEditor.ContentsResizeValue.auto(), APdfFileEditor.ContentsResizeValue.units(right), APdfFileEditor.ContentsResizeValue.units(top), APdfFileEditor.ContentsResizeValue.auto(), APdfFileEditor.ContentsResizeValue.units(bottom));
        }

        public static ContentsResizeParameters marginsPercent(double left, double right, double top, double bottom) {
            return new ContentsResizeParameters(APdfFileEditor.ContentsResizeValue.percents(left), APdfFileEditor.ContentsResizeValue.auto(), APdfFileEditor.ContentsResizeValue.percents(right), APdfFileEditor.ContentsResizeValue.percents(top), APdfFileEditor.ContentsResizeValue.auto(), APdfFileEditor.ContentsResizeValue.percents(bottom));
        }

        public static ContentsResizeParameters contentSize(double width, double height) {
            return new ContentsResizeParameters(APdfFileEditor.ContentsResizeValue.auto(), APdfFileEditor.ContentsResizeValue.units(width), APdfFileEditor.ContentsResizeValue.auto(), APdfFileEditor.ContentsResizeValue.auto(), APdfFileEditor.ContentsResizeValue.units(height), APdfFileEditor.ContentsResizeValue.auto());
        }

        public static ContentsResizeParameters contentSizePercent(double width, double height) {
            return new ContentsResizeParameters(APdfFileEditor.ContentsResizeValue.auto(), APdfFileEditor.ContentsResizeValue.percents(width), APdfFileEditor.ContentsResizeValue.auto(), APdfFileEditor.ContentsResizeValue.auto(), APdfFileEditor.ContentsResizeValue.percents(height), APdfFileEditor.ContentsResizeValue.auto());
        }

        public static ContentsResizeParameters pageResize(double width, double height) {
            return new ContentsResizeParameters(APdfFileEditor.ContentsResizeValue.units(0.0), APdfFileEditor.ContentsResizeValue.units(width), APdfFileEditor.ContentsResizeValue.units(0.0), APdfFileEditor.ContentsResizeValue.units(0.0), APdfFileEditor.ContentsResizeValue.units(height), APdfFileEditor.ContentsResizeValue.units(0.0));
        }

        public static ContentsResizeParameters pageResizePct(double widthPct, double heightPct) {
            return new ContentsResizeParameters(APdfFileEditor.ContentsResizeValue.units(0.0), APdfFileEditor.ContentsResizeValue.percents(widthPct), APdfFileEditor.ContentsResizeValue.units(0.0), APdfFileEditor.ContentsResizeValue.units(0.0), APdfFileEditor.ContentsResizeValue.percents(heightPct), APdfFileEditor.ContentsResizeValue.units(0.0));
        }

        private double[] m1(APdfFileEditor.ContentsResizeValue[] contentsResizeValueArray, double d) {
            int n;
            double d2 = 0.0;
            int n2 = 0;
            double[] dArray = new double[contentsResizeValueArray.length];
            for (n = 0; n < contentsResizeValueArray.length; ++n) {
                if (contentsResizeValueArray[n] != null) {
                    dArray[n] = contentsResizeValueArray[n].isPercent() ? d * contentsResizeValueArray[n].getValue() / 100.0 : contentsResizeValueArray[n].getValue();
                    d2 += dArray[n];
                    continue;
                }
                ++n2;
            }
            if (n2 > 0) {
                for (n = 0; n < contentsResizeValueArray.length; ++n) {
                    if (contentsResizeValueArray[n] != null) continue;
                    dArray[n] = (d - d2) / (double)n2;
                }
            }
            if (dArray[1] <= 0.0) {
                throw new z72("Margin sizes are larger then page size");
            }
            return dArray;
        }

        double[][] m1(double d, double d2) {
            double[] dArray = this.m1(new APdfFileEditor.ContentsResizeValue[]{this.getLeftMargin(), this.getContentsWidth(), this.getRightMargin()}, d);
            double[] dArray2 = this.m1(new APdfFileEditor.ContentsResizeValue[]{this.getBottomMargin(), this.getContentsHeight(), this.getTopMargin()}, d2);
            return new double[][]{dArray, dArray2};
        }
    }
}

