/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import aspose.pdf.Pdf;
import com.aspose.pdf.Document;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.IIndexBitmapConverter;
import com.aspose.pdf.ImageType;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.PageSize;
import com.aspose.pdf.Point;
import com.aspose.pdf.RenderingOptions;
import com.aspose.pdf.devices.BmpDevice;
import com.aspose.pdf.devices.EmfDevice;
import com.aspose.pdf.devices.GifDevice;
import com.aspose.pdf.devices.GraphicsDevice;
import com.aspose.pdf.devices.ImageDevice;
import com.aspose.pdf.devices.JpegDevice;
import com.aspose.pdf.devices.PngDevice;
import com.aspose.pdf.devices.Resolution;
import com.aspose.pdf.devices.TiffDevice;
import com.aspose.pdf.devices.TiffSettings;
import com.aspose.pdf.facades.Facade;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z72;
import com.aspose.pdf.internal.p606.z176;
import com.aspose.pdf.internal.p606.z23;
import com.aspose.pdf.internal.p606.z29;
import com.aspose.pdf.internal.p606.z39;
import com.aspose.pdf.internal.p609.z33;
import com.aspose.pdf.internal.p613.z14;
import com.aspose.pdf.internal.p613.z28;
import com.aspose.pdf.internal.p613.z32;
import com.aspose.pdf.internal.p613.z41;
import com.aspose.pdf.internal.p643.z370;
import com.aspose.pdf.internal.p643.z374;
import com.aspose.pdf.internal.p68.z6;
import com.aspose.pdf.internal.p68.z9;
import com.aspose.pdf.internal.p781.z5;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfConverter
extends Facade {
    private static final Logger m1 = Logger.getLogger(PdfConverter.class.getName());
    private Resolution m2 = new Resolution(150);
    private int m3 = 1;
    private int m4 = Integer.MAX_VALUE;
    private int m5 = 1;
    private String m6;
    private String m7;
    private int m8 = 0;
    private boolean m9 = false;
    private RenderingOptions m10 = new RenderingOptions();
    private boolean m12 = true;
    private boolean m13 = false;
    private int m14 = 1;

    public int getCoordinateType() {
        return this.m14;
    }

    public void setCoordinateType(int value) {
        this.m14 = value;
    }

    @Deprecated
    public boolean isShowHiddenAreas() {
        return this.m12;
    }

    @Deprecated
    public void setShowHiddenAreas(boolean value) {
        this.m13 = true;
        this.m12 = value;
    }

    private ImageDevice m1(ImageType imageType, Resolution resolution, int n) {
        return this.m1(imageType, 0, 0, resolution, n);
    }

    private ImageDevice m1(float f, float f2, int n, int n2, z176 z1762, float f3, Resolution resolution, int n3, boolean bl, int n4, int n5, boolean bl2) {
        GraphicsDevice graphicsDevice = new GraphicsDevice(new Point(f, f2), n, n2, z1762.m13(), f3, resolution, n3, bl, n4, n5, bl2);
        graphicsDevice.setFormPresentationMode(this.getFormPresentationMode());
        graphicsDevice.setConvertFontsToUnicodeTTF(this.m1());
        graphicsDevice.setRenderingOptions(this.getRenderingOptions());
        return graphicsDevice;
    }

    private ImageDevice m1(ImageType imageType, int n, int n2, Resolution resolution, int n3) {
        ImageDevice imageDevice = null;
        if (InternalHelper.m1(imageType) == z33.m10()) {
            imageDevice = new JpegDevice(n, n2, resolution, n3);
        } else if (InternalHelper.m1(imageType) == z33.m12()) {
            imageDevice = new PngDevice(n, n2, resolution);
        } else if (InternalHelper.m1(imageType) == z33.m5()) {
            imageDevice = new BmpDevice(n, n2, resolution);
        } else if (InternalHelper.m1(imageType) == z33.m8()) {
            imageDevice = new GifDevice(n, n2, resolution);
        } else if (InternalHelper.m1(imageType) == z33.m6()) {
            imageDevice = new EmfDevice(n, n2, resolution);
        } else {
            if (InternalHelper.m1(imageType) == z33.m13()) {
                throw new z72(z133.m1(new String[]{"Image format ", imageType.toString(), " is not supported. SaveAsTIFF methods should be used in order to generate Tiff files."}));
            }
            throw new z72(z133.m1(new String[]{"Image format ", imageType.toString(), " is not supported"}));
        }
        imageDevice.setFormPresentationMode(this.getFormPresentationMode());
        imageDevice.setConvertFontsToUnicodeTTF(this.m1());
        imageDevice.setRenderingOptions(this.getRenderingOptions());
        return imageDevice;
    }

    private ImageDevice m1(ImageType imageType, PageSize pageSize, Resolution resolution, int n) {
        ImageDevice imageDevice = null;
        if (InternalHelper.m1(imageType) == z33.m10()) {
            imageDevice = new JpegDevice(pageSize, resolution, n);
        } else if (InternalHelper.m1(imageType) == z33.m12()) {
            imageDevice = new PngDevice(pageSize, resolution);
        } else if (InternalHelper.m1(imageType) == z33.m5()) {
            imageDevice = new BmpDevice(pageSize, resolution);
        } else if (InternalHelper.m1(imageType) == z33.m8()) {
            imageDevice = new GifDevice(pageSize, resolution);
        } else if (InternalHelper.m1(imageType) == z33.m6()) {
            imageDevice = new EmfDevice(pageSize, resolution);
        } else {
            if (InternalHelper.m1(imageType) == z33.m13()) {
                throw new z72(z133.m1(new String[]{"Image format ", imageType.toString(), " is not supported. SaveAsTIFF methods should be used in order to generate Tiff files."}));
            }
            throw new z72(z133.m1(new String[]{"Image format ", imageType.toString(), " is not supported"}));
        }
        imageDevice.setFormPresentationMode(this.getFormPresentationMode());
        imageDevice.setConvertFontsToUnicodeTTF(this.m1());
        imageDevice.setRenderingOptions(this.getRenderingOptions());
        return imageDevice;
    }

    public RenderingOptions getRenderingOptions() {
        return this.m10;
    }

    public void setRenderingOptions(RenderingOptions value) {
        this.m10 = value;
    }

    public int getFormPresentationMode() {
        return this.m8;
    }

    public void setFormPresentationMode(int value) {
        this.m8 = value;
    }

    boolean m1() {
        return this.m9;
    }

    void m1(boolean bl) {
        this.m9 = bl;
    }

    public Resolution getResolution() {
        return this.m2;
    }

    public void setResolution(Resolution value) {
        this.m2 = value.getX() <= 0 || value.getY() <= 0 ? new Resolution(150) : value;
    }

    public int getStartPage() {
        return this.m3;
    }

    public void setStartPage(int value) {
        this.m5 = this.m3 = value < 1 ? 1 : value;
    }

    public int getEndPage() {
        this.m4();
        if (this.m4 != Integer.MAX_VALUE) {
            return this.m4;
        }
        return this.getDocument().getPages().size();
    }

    public void setEndPage(int value) {
        this.m4();
        int n = this.m4 = value > this.getDocument().getPages().size() ? this.getDocument().getPages().size() : value;
        if (this.m4 < this.m3) {
            this.m4 = this.m3;
        }
    }

    public void setRangeOfPages(int startPage, int EndPage) {
        if (startPage > EndPage) {
            this.m4 = startPage > this.m11.getPages().size() ? this.m11.getPages().size() : startPage;
            this.m3 = EndPage < 1 ? 1 : EndPage;
        } else {
            this.m4 = EndPage > this.m11.getPages().size() ? this.m11.getPages().size() : EndPage;
            this.m3 = startPage < 1 ? 1 : startPage;
        }
    }

    public String getPassword() {
        return this.m6;
    }

    public void setPassword(String value) {
        this.m6 = value;
    }

    public String getUserPassword() {
        return this.m7;
    }

    public void setUserPassword(String value) {
        this.m7 = value;
    }

    public int getPageCount() {
        this.m4();
        return this.getDocument().getPages().size();
    }

    public void doConvert() {
        this.m4();
        this.m5 = this.m3;
    }

    public void saveAsTIFF(String outputFile) {
        z28 z2810 = null;
        try {
            z2810 = z14.m8(outputFile);
            this.m1(z2810);
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            throw new RuntimeException(z7210.getMessage());
        }
        finally {
            if (z2810 != null) {
                try {
                    z2810.close();
                }
                catch (z72 z7211) {
                    m1.log(Level.INFO, "Exception occur", z7211);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int compressionType) {
        z28 z2810 = null;
        try {
            z2810 = z14.m8(outputFile);
            this.m1((z41)z2810, 0, 0, compressionType);
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            throw new RuntimeException(z7210.getMessage());
        }
        finally {
            if (z2810 != null) {
                try {
                    z2810.close();
                }
                catch (z72 z7211) {
                    m1.log(Level.INFO, "Exception occur", z7211);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight) {
        z28 z2810 = null;
        try {
            z2810 = z14.m8(outputFile);
            this.m1((z41)z2810, imageWidth, imageHeight);
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            throw new RuntimeException(z7210.getMessage());
        }
        finally {
            if (z2810 != null) {
                try {
                    z2810.close();
                }
                catch (z72 z7211) {
                    m1.log(Level.INFO, "Exception occur", z7211);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, PageSize pageSize) {
        z28 z2810 = null;
        try {
            z2810 = z14.m8(outputFile);
            this.m1((z41)z2810, pageSize);
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            throw new RuntimeException(z7210.getMessage());
        }
        finally {
            if (z2810 != null) {
                try {
                    z2810.close();
                }
                catch (z72 z7211) {
                    m1.log(Level.INFO, "Exception occur", z7211);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, PageSize pageSize, TiffSettings settings) {
        z28 z2810 = null;
        try {
            z2810 = z14.m8(outputFile);
            this.m1((z41)z2810, pageSize, settings);
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            throw new RuntimeException(z7210.getMessage());
        }
        finally {
            if (z2810 != null) {
                try {
                    z2810.close();
                }
                catch (z72 z7211) {
                    m1.log(Level.INFO, "Exception occur", z7211);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, int compressionType) {
        z28 z2810 = null;
        try {
            z2810 = z14.m8(outputFile);
            this.m1((z41)z2810, imageWidth, imageHeight, compressionType);
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            throw new RuntimeException(z7210.getMessage());
        }
        finally {
            if (z2810 != null) {
                try {
                    z2810.close();
                }
                catch (z72 z7211) {
                    m1.log(Level.INFO, "Exception occur", z7211);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, TiffSettings settings) {
        z28 z2810 = null;
        try {
            z2810 = z14.m8(outputFile);
            this.m1((z41)z2810, imageWidth, imageHeight, settings);
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            throw new RuntimeException(z7210.getMessage());
        }
        finally {
            if (z2810 != null) {
                try {
                    z2810.close();
                }
                catch (z72 z7211) {
                    m1.log(Level.INFO, "Exception occur", z7211);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, int imageWidth, int imageHeight, TiffSettings settings, IIndexBitmapConverter converter) {
        z28 z2810 = null;
        try {
            z2810 = z14.m8(outputFile);
            this.m1(z2810, imageWidth, imageHeight, settings, converter);
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            throw new RuntimeException(z7210.getMessage());
        }
        finally {
            if (z2810 != null) {
                try {
                    z2810.close();
                }
                catch (z72 z7211) {
                    m1.log(Level.INFO, "Exception occur", z7211);
                }
            }
        }
    }

    public void saveAsTIFFClassF(String outputFile, int imageWidth, int imageHeight) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, imageWidth, imageHeight);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void saveAsTIFFClassF(String outputFile, PageSize pageSize) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, pageSize);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void saveAsTIFFClassF(OutputStream outputStream, int imageWidth, int imageHeight) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, tiffSettings);
    }

    public void saveAsTIFFClassF(OutputStream outputStream, PageSize pageSize) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, pageSize, tiffSettings);
    }

    public void saveAsTIFF(OutputStream outputStream) {
        this.saveAsTIFF(outputStream, 0, 0, new TiffSettings());
    }

    private void m1(z41 z4110) {
        this.m1(z4110, 0, 0, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, int compressionType) {
        this.saveAsTIFF(outputStream, 0, 0, compressionType);
    }

    public void saveAsTIFF(OutputStream outputStream, PageSize pageSize) {
        this.saveAsTIFF(outputStream, pageSize, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, PageSize pageSize, TiffSettings settings) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(pageSize, this.getResolution(), settings);
        tiffDevice.process(this.m11, this.getStartPage(), this.getEndPage(), outputStream);
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight) {
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, new TiffSettings());
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, int compressionType) {
        this.saveAsTIFF(outputStream, imageWidth, imageHeight, new TiffSettings(compressionType));
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, TiffSettings settings) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(imageWidth, imageHeight, this.getResolution(), settings);
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), outputStream);
    }

    private void m1(z41 z4110, int n, int n2, TiffSettings tiffSettings) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), tiffSettings);
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), z4110);
    }

    private void m1(z41 z4110, int n, int n2, int n3) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), new TiffSettings(n3));
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), z4110);
    }

    private void m1(z41 z4110, int n, int n2) {
        this.m1(z4110, n, n2, new TiffSettings());
    }

    private void m1(z41 z4110, int n, int n2, TiffSettings tiffSettings, IIndexBitmapConverter iIndexBitmapConverter) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(n, n2, this.getResolution(), tiffSettings, iIndexBitmapConverter);
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), z4110);
    }

    private void m1(z41 z4110, PageSize pageSize) {
        this.m1(z4110, pageSize, new TiffSettings());
    }

    private void m1(z41 z4110, PageSize pageSize, TiffSettings tiffSettings) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(pageSize, this.getResolution(), tiffSettings);
        tiffDevice.setFormPresentationMode(this.getFormPresentationMode());
        tiffDevice.setRenderingOptions(this.getRenderingOptions());
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), z4110);
    }

    public void saveAsTIFF(OutputStream outputStream, int imageWidth, int imageHeight, TiffSettings settings, IIndexBitmapConverter converter) {
        this.m4();
        TiffDevice tiffDevice = new TiffDevice(imageWidth, imageHeight, this.getResolution(), settings, converter);
        tiffDevice.process(this.getDocument(), this.getStartPage(), this.getEndPage(), outputStream);
    }

    public boolean hasNextImage() {
        this.m4();
        return this.m5 <= this.getEndPage();
    }

    public void getNextImage(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(String outputFile, PageSize pageSize) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextImage(String outputFile, ImageType format) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(String outputFile, PageSize pageSize, ImageType format) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream) {
        this.getNextImage(outputStream, ImageType.getJpeg(), 0, 0, 100);
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize) {
        this.getNextImage(outputStream, pageSize, ImageType.getJpeg(), 100);
    }

    public void getNextImage(OutputStream outputStream, ImageType format) {
        this.m4();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, format, 0, 0, 100);
        }
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize, ImageType format) {
        this.m4();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, pageSize, format, 100);
        }
    }

    public void getNextImage(String outputFile, ImageType format, int imageWidth, int imageHeight, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageType format, int imageWidth, int imageHeight, int quality) {
        this.m4();
        z32 z3210 = new z32();
        if (this.hasNextImage()) {
            ImageDevice imageDevice = this.m1(format, imageWidth, imageHeight, this.getResolution(), quality);
            imageDevice.setCoordinateType(this.m14);
            imageDevice.processInternal(this.m11.getPages().get_Item(this.m5), z3210);
            ++this.m5;
        }
        try {
            if (z3210 != null) {
                outputStream.write(z3210.m4());
            }
            z3210.close();
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
    }

    public void getNextImage(String outputFile, ImageType format, double imageWidth, double imageHeight, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageType format, double imageWidth, double imageHeight, int quality) {
        this.getNextImage(outputStream, format, (int)imageWidth, (int)imageHeight, quality);
    }

    private void m2() {
        z374 z3742;
        if (this.getDocument().getForm().hasXfa() && (z3742 = this.getDocument().getForm().getXFA().getConfig()) != null) {
            z6 z6100;
            z9 z9100;
            z370 z3702 = new z370(this.getDocument().getForm().getXFA().getConfig().m9().m25());
            z3702.m1("cfg", this.getDocument().getForm().getXFA().getConfig().m6());
            z374 z3743 = z3742.m2("cfg:acrobat/cfg:acrobat7/cfg:dynamicRender", z3702);
            if (z3743 != null && z3743.m10() != null && z133.m8(z3743.m10(), "required") != -1 && (z9100 = this.getDocument().getEngineDoc().m2().m60()).m4("NeedsRendering") && (z6100 = z9100.m3("NeedsRendering").m63()).m1()) {
                this.getDocument().getForm().setType(0);
            }
        }
    }

    @Override
    public void bindPdf(String inputFile) {
        if (this.getPassword() != null) {
            this.bindPdf(inputFile, this.getPassword());
        } else if (this.getUserPassword() != null) {
            this.bindPdf(inputFile, this.getUserPassword());
        } else {
            this.bindPdf(inputFile, this.getPassword());
        }
        this.m2();
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.m7(z41.fromJava(inputStream));
    }

    @Override
    void m7(z41 z4110) {
        this.m1(z4110, this.getPassword());
        this.m2();
    }

    @Override
    public void bindPdf(Pdf pdf) {
        this.bindPdf(new Document(pdf));
        this.m4 = this.m11.getPages().size();
    }

    public PdfConverter() {
    }

    public PdfConverter(IDocument document) {
        super(document);
        this.m4 = this.getDocument().getPages().size();
    }

    @Override
    public void close() {
        super.close();
    }

    public void saveAsTIFFClassF(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.saveAsTIFFClassF(fileOutputStream, 0, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void saveAsTIFFClassF(OutputStream outputStream) {
        TiffSettings tiffSettings = new TiffSettings();
        tiffSettings.setDepth(3);
        tiffSettings.setCompression(1);
        this.saveAsTIFF(outputStream, 0, 0, tiffSettings);
    }

    public void saveAsTIFF(String outputFile, TiffSettings settings) {
        z28 z2810 = null;
        try {
            z2810 = z14.m8(outputFile);
            this.m1((z41)z2810, 0, 0, settings);
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            throw new RuntimeException(z7210.getMessage());
        }
        finally {
            if (z2810 != null) {
                try {
                    z2810.close();
                }
                catch (z72 z7211) {
                    m1.log(Level.INFO, "Exception occur", z7211);
                }
            }
        }
    }

    public void saveAsTIFF(String outputFile, TiffSettings settings, IIndexBitmapConverter converter) {
        z28 z2810 = null;
        try {
            z2810 = z14.m8(outputFile);
            this.m1(z2810, 0, 0, settings, converter);
        }
        catch (z72 z7210) {
            m1.log(Level.INFO, "Exception occur", z7210);
            throw new RuntimeException(z7210.getMessage());
        }
        finally {
            if (z2810 != null) {
                try {
                    z2810.close();
                }
                catch (z72 z7211) {
                    m1.log(Level.INFO, "Exception occur", z7211);
                }
            }
        }
    }

    public void saveAsTIFF(OutputStream outputStream, TiffSettings settings) {
        this.saveAsTIFF(outputStream, 0, 0, settings);
    }

    public void saveAsTIFF(OutputStream outputStream, TiffSettings settings, IIndexBitmapConverter converter) {
        this.saveAsTIFF(outputStream, 0, 0, settings, converter);
    }

    public void getNextImage(String outputFile, ImageType format, int imageWidth, int imageHeight) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, imageWidth, imageHeight, 100);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    public void getNextImage(OutputStream outputStream, ImageType format, int imageWidth, int imageHeight) {
        this.getNextImage(outputStream, format, 0, 0, 100);
    }

    public void getNextImage(OutputStream outputStream, ImageType format, int quality) {
        this.m4();
        if (this.hasNextImage()) {
            this.getNextImage(outputStream, format, 0, 0, quality);
        }
    }

    public void getNextImage(OutputStream outputStream, PageSize pageSize, ImageType format, int quality) {
        this.m4();
        if (this.hasNextImage()) {
            ImageDevice imageDevice = this.m1(format, pageSize, this.getResolution(), quality);
            if (this.m13) {
                if (!this.m12 && !this.getDocument().getPages().get_Item(this.m5).getCropBox().equals(this.getDocument().getPages().get_Item(this.m5).getMediaBox())) {
                    imageDevice.setCoordinateType(0);
                }
            } else {
                imageDevice.setCoordinateType(this.m14);
            }
            imageDevice.process(this.getDocument().getPages().get_Item(this.m5), outputStream);
            ++this.m5;
        }
    }

    public void getNextImage(String outputFile, ImageType format, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, format, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextImage(String outputFile, PageSize pageSize, ImageType format, int quality) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextImage((OutputStream)fileOutputStream, pageSize, format, quality);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void m1(z23 z2310, float f, float f2, int n, int n2, z176 z1762, float f3, int n3, boolean bl, int n4, int n5, boolean bl2, boolean bl3) {
        this.m4();
        if (this.hasNextImage()) {
            block13: {
                ImageDevice imageDevice = !bl3 ? this.m1(f, f2, n, n2, z1762.m13(), f3, this.getResolution(), n3, bl, n4, n5, bl2) : new PngDevice();
                if (this.m13) {
                    if (!this.m12 && !this.getDocument().getPages().get_Item(this.m5).getCropBox().equals(this.getDocument().getPages().get_Item(this.m5).getMediaBox())) {
                        imageDevice.setCoordinateType(0);
                    }
                } else {
                    imageDevice.setCoordinateType(this.m14);
                }
                if (bl3) {
                    z32 z3210 = new z32();
                    try {
                        imageDevice.processInternal(this.getDocument().getPages().get_Item(this.m5), z3210);
                        z29 z2910 = z29.m1(z3210);
                        try {
                            z2310.m1(z2910, new z39(z5.m5((Object)Float.valueOf(f), 13), z5.m5((Object)Float.valueOf(f2), 13)));
                            break block13;
                        }
                        finally {
                            if (z2910 != null) {
                                z2910.dispose();
                            }
                        }
                    }
                    finally {
                        if (z3210 != null) {
                            z3210.dispose();
                        }
                    }
                }
                imageDevice.process(this.getDocument().getPages().get_Item(this.m5), z2310);
            }
            ++this.m5;
        }
    }

    @Override
    public void dispose() {
        this.close();
    }

    static {
        m1.setUseParentHandlers(false);
    }
}

