/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.pdf.facades;

import com.aspose.pdf.Annotation;
import com.aspose.pdf.Document;
import com.aspose.pdf.FileAttachmentAnnotation;
import com.aspose.pdf.FileSpecification;
import com.aspose.pdf.IDocument;
import com.aspose.pdf.ImagePlacement;
import com.aspose.pdf.ImagePlacementAbsorber;
import com.aspose.pdf.ImageType;
import com.aspose.pdf.InternalHelper;
import com.aspose.pdf.Rectangle;
import com.aspose.pdf.TextAbsorber;
import com.aspose.pdf.TextEncodingInternal;
import com.aspose.pdf.TextExtractionOptions;
import com.aspose.pdf.TextSearchOptions;
import com.aspose.pdf.XForm;
import com.aspose.pdf.XImage;
import com.aspose.pdf.facades.Facade;
import com.aspose.pdf.internal.ms.System.Collections.Generic.z2;
import com.aspose.pdf.internal.ms.System.z105;
import com.aspose.pdf.internal.ms.System.z133;
import com.aspose.pdf.internal.ms.System.z72;
import com.aspose.pdf.internal.p652.z32;
import com.aspose.pdf.internal.p652.z34;
import com.aspose.pdf.internal.p652.z41;
import com.aspose.pdf.internal.p652.z46;
import com.aspose.pdf.internal.p677.z18;
import com.aspose.pdf.internal.p77.z14;
import com.aspose.pdf.internal.p77.z16;
import com.aspose.pdf.internal.p77.z9;
import com.aspose.pdf.internal.p820.z5;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PdfExtractor
extends Facade {
    private static final Logger m1 = Logger.getLogger(PdfExtractor.class.getName());
    private int m2;
    private int m3;
    private int m4;
    private com.aspose.pdf.internal.ms.System.Collections.Generic.z16<XImage> m5;
    private int m6;
    private int m7;
    private String m8;
    private com.aspose.pdf.internal.ms.System.Collections.Generic.z16<String> m9;
    private int m10 = 0;
    private int m12 = 0;
    private TextSearchOptions m13 = new TextSearchOptions(Rectangle.getEmpty());
    private int m14 = 150;
    private String m15 = null;
    private z18 m16;
    private z2<Integer, Integer> m17 = new z2();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void m1(FileSpecification fileSpecification, String string) {
        String string2 = z34.m1(fileSpecification.getName());
        if (string2 == null) {
            string2 = z133.m1("NoName{0}", new Object[]{this.m7++});
        }
        if (string == null) {
            string = z133.m1;
        }
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(z34.m2(string, string2));
            z32 z3210 = (z32)((Object)z5.m1(fileSpecification.getContentsInternal(), z32.class));
            if (z3210 == null) {
                throw new z105("Use for stream data only MemoryStream");
            }
            z3210.m1(0L, 0);
            byte[] byArray = new byte[1024];
            while ((n = z3210.m2(byArray, 0, byArray.length)) == byArray.length) {
                fileOutputStream.write(byArray, 0, byArray.length);
            }
            fileOutputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    private z32[] m1(String string, boolean bl) {
        int n;
        Object object;
        this.m3();
        com.aspose.pdf.internal.ms.System.Collections.Generic.z16<z41> z1610 = new com.aspose.pdf.internal.ms.System.Collections.Generic.z16<z41>();
        if (this.m8 == null) {
            object = new z2();
            if (this.getDocument().getEmbeddedFiles().size() != 0) {
                for (Object object2 : this.getDocument().getEmbeddedFiles()) {
                    if (object2 == null || ((FileSpecification)object2).getContentsInternal() == null || ((z2)object).containsKey(((FileSpecification)object2).getName())) continue;
                    if (bl) {
                        this.m1((FileSpecification)object2, string);
                    } else {
                        z1610.addItem(((FileSpecification)object2).getContentsInternal());
                    }
                    ((z2)object).set_Item(((FileSpecification)object2).getName(), 1);
                }
            }
            for (n = this.m2; n <= this.m3; ++n) {
                if (this.getDocument().getPages().get_Item(n).getAnnotations().size() == 0) continue;
                for (Annotation object3 : this.getDocument().getPages().get_Item(n).getAnnotations()) {
                    FileSpecification fileSpecification;
                    if (!(object3 instanceof FileAttachmentAnnotation) || (fileSpecification = ((FileAttachmentAnnotation)((Object)z5.m1(object3, FileAttachmentAnnotation.class))).getFile()) == null || fileSpecification.getName() == null || ((z2)object).containsKey(fileSpecification.getName())) continue;
                    if (bl) {
                        this.m1(fileSpecification, string);
                    } else {
                        z1610.addItem(fileSpecification.getContentsInternal());
                    }
                    ((z2)object).set_Item(fileSpecification.getName(), 1);
                }
            }
        } else {
            object = this.getDocument().getEmbeddedFiles().get_Item(this.m8);
            if (object != null) {
                if (bl) {
                    this.m1((FileSpecification)object, string);
                } else {
                    z1610.addItem(((FileSpecification)object).getContentsInternal());
                }
            }
            for (n = this.m2; n <= this.m3; ++n) {
                if (this.getDocument().getPages().get_Item(n).getAnnotations().size() == 0) continue;
                for (Annotation annotation : this.getDocument().getPages().get_Item(n).getAnnotations()) {
                    if (!(annotation instanceof FileAttachmentAnnotation) || (object = ((FileAttachmentAnnotation)((Object)z5.m1(annotation, FileAttachmentAnnotation.class))).getFile()) == null || !z133.m5(((FileSpecification)object).getName(), this.m8)) continue;
                    if (bl) {
                        this.m1((FileSpecification)object, string);
                        continue;
                    }
                    z1610.addItem(((FileSpecification)object).getContentsInternal());
                }
            }
        }
        object = null;
        if (!bl && z1610.size() > 0) {
            object = new z32[z1610.size()];
            n = 0;
            for (z41 z4110 : z1610) {
                object[n++] = (z32)z4110;
            }
        }
        return object;
    }

    private List<FileSpecification> m1() {
        ArrayList<FileSpecification> arrayList = new ArrayList<FileSpecification>();
        z2<String, Integer> z2100 = new z2<String, Integer>();
        if (this.getDocument().getEmbeddedFiles().size() != 0) {
            for (Object object : this.getDocument().getEmbeddedFiles()) {
                if (object == null || ((FileSpecification)object).getContentsInternal() == null || z2100.containsKey(((FileSpecification)object).getName())) continue;
                arrayList.add((FileSpecification)object);
                z2100.set_Item(((FileSpecification)object).getName(), 1);
            }
        }
        for (int i = this.m2; i <= this.m3; ++i) {
            if (this.getDocument().getPages().get_Item(i).getAnnotations().size() == 0) continue;
            for (Annotation annotation : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                FileSpecification fileSpecification;
                if (!(annotation instanceof FileAttachmentAnnotation) || (fileSpecification = ((FileAttachmentAnnotation)((Object)z5.m1(annotation, FileAttachmentAnnotation.class))).getFile()) == null || fileSpecification.getName() == null || z2100.containsKey(fileSpecification.getName())) continue;
                arrayList.add(fileSpecification);
                z2100.set_Item(fileSpecification.getName(), 1);
            }
        }
        return arrayList;
    }

    private void m2() {
        this.m4();
        if (this.m2 == 0) {
            this.m2 = 1;
        }
        if (this.m3 == 0) {
            this.m3 = this.getDocument().getPages().size();
        }
        if (this.m4 == 0) {
            this.m4 = 1;
        }
        if (this.m3 > this.getDocument().getPages().size()) {
            this.m3 = this.getDocument().getPages().size();
        }
        if (this.m2 > this.getDocument().getPages().size()) {
            this.m2 = this.getDocument().getPages().size();
        }
        if (this.m3 < this.m2) {
            this.m3 = this.m2;
        }
        if (!InternalHelper.m1() && this.m3 > 4) {
            this.m3 = 4;
        }
    }

    static void m1(com.aspose.pdf.internal.ms.System.Collections.Generic.z16<XImage> z1610, XForm xForm) {
        int n;
        for (n = xForm.getResources().getForms().size(); n >= 1; --n) {
            PdfExtractor.m1(z1610, xForm.getResources().getForms().get_Item(n));
        }
        for (n = xForm.getResources().getImages().size(); n >= 1; --n) {
            z1610.insertItem(0, xForm.getResources().getImages().get_Item(n));
        }
    }

    void m1(com.aspose.pdf.internal.ms.System.Collections.Generic.z16<XImage> z1610, IDocument iDocument, int n, int n2) {
        if (this.m12 == 0) {
            this.m3(z1610, iDocument, n, n2);
        } else {
            PdfExtractor.m2(z1610, iDocument, n, n2);
        }
    }

    static void m2(com.aspose.pdf.internal.ms.System.Collections.Generic.z16<XImage> z1610, IDocument iDocument, int n, int n2) {
        z1610.clear();
        ImagePlacementAbsorber imagePlacementAbsorber = new ImagePlacementAbsorber();
        if (n <= n2) {
            iDocument.getPages().get_Item(n).accept(imagePlacementAbsorber);
            for (ImagePlacement imagePlacement : imagePlacementAbsorber.getImagePlacements()) {
                z1610.addItem(imagePlacement.getImage());
            }
        }
    }

    void m3(com.aspose.pdf.internal.ms.System.Collections.Generic.z16<XImage> z1610, IDocument iDocument, int n, int n2) {
        int n3;
        z1610.clear();
        if (n <= n2) {
            for (n3 = iDocument.getPages().get_Item(n).getResources().getForms().size(); n3 >= 1; --n3) {
                PdfExtractor.m1(z1610, iDocument.getPages().get_Item(n).getResources().getForms().get_Item(n3));
            }
        }
        for (n3 = iDocument.getPages().get_Item(n).getResources().getImages().size(); n3 >= 1; --n3) {
            z1610.insertItem(0, iDocument.getPages().get_Item(n).getResources().getImages().get_Item(n3));
        }
        if (iDocument.getPages().get_Item(n).getResources().getEngineDict().m4("Pattern")) {
            z9 z910 = iDocument.getPages().get_Item(n).getResources().getEngineDict().m3("Pattern").m64();
            for (String string : z910.m30()) {
                z9 z911;
                z9 z912 = z910.m3(string).m64();
                if (z912 == null || !z912.m4("Resources") || (z911 = z912.m3("Resources").m64()) == null || !z911.m4("XObject")) continue;
                z9 z913 = z911.m3("XObject").m64();
                for (String string2 : z913.m30()) {
                    z16 z1611 = z913.m3(string2);
                    if (!XImage.isImage(z1611)) continue;
                    z14 z1410 = z1611.m68();
                    XImage xImage = InternalHelper.m1(z1611.m68(), z1611.m61());
                    if (z1410 == null) {
                        z1610.addItem(xImage);
                        continue;
                    }
                    if (this.m17.containsKey(z1410.m46())) continue;
                    this.m17.addItem(z1410.m46(), z1410.m46());
                    z1610.addItem(xImage);
                }
            }
        }
    }

    private boolean m1(char c) {
        return c >= '\u0600' && c <= '\u06ff' || c >= '\u0750' && c <= '\u077f' || c >= '\ufb50' && c <= '\ufdff' || c >= '\ufe70' && c <= '\ufeff';
    }

    private boolean m2(char c) {
        return c >= '\u0590' && c <= '\u05ff';
    }

    public int getStartPage() {
        return this.m2;
    }

    public void setStartPage(int value) {
        int n = this.m2 = value < 1 ? 1 : value;
        if (this.m3 < this.m2) {
            this.m3 = this.m2;
        }
    }

    public int getEndPage() {
        return this.m3;
    }

    public void setEndPage(int value) {
        int n = this.m3 = value < 1 ? 1 : value;
        if (this.m2 > this.m3) {
            this.m2 = this.m3;
        }
    }

    public int getExtractTextMode() {
        return this.m10;
    }

    public void setExtractTextMode(int value) {
        if (value == 0 || value == 1) {
            this.m10 = value;
        }
    }

    public TextSearchOptions getTextSearchOptions() {
        return this.m13;
    }

    public void setTextSearchOptions(TextSearchOptions value) {
        if (value != null) {
            this.m13 = value;
        }
    }

    public int getExtractImageMode() {
        return this.m12;
    }

    public void setExtractImageMode(int value) {
        this.m12 = value;
    }

    public boolean isBidi() {
        z32 z3210 = new z32();
        this.getText(z3210.m23());
        z3210.m1(0L);
        z46 z4610 = new z46((z41)z3210, z18.m27());
        String string = z4610.m13();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!this.m1(c) && !this.m2(c)) continue;
            return true;
        }
        return false;
    }

    public void extractText() {
        this.m3();
        this.extractTextInternal(TextEncodingInternal.getUnicode());
    }

    public void extractText(Charset encoding) {
        this.extractTextInternal(TextEncodingInternal.getEncoding(encoding.displayName()));
    }

    public void extractTextInternal(TextEncodingInternal encoding) {
        this.m3();
        this.m16 = encoding.getInternalFormat();
        this.m9 = new com.aspose.pdf.internal.ms.System.Collections.Generic.z16();
        for (int i = this.getStartPage(); i <= this.getEndPage(); ++i) {
            if (Document.restricted(i)) continue;
            long l = 0L;
            TextExtractionOptions textExtractionOptions = this.m10 == 0 ? new TextExtractionOptions(0) : new TextExtractionOptions(1);
            TextAbsorber textAbsorber = new TextAbsorber(textExtractionOptions);
            textAbsorber.setTextSearchOptions(this.getTextSearchOptions());
            textAbsorber.visit(this.getDocument().getPages().get_Item(i));
            this.m9.addItem(textAbsorber.getText());
        }
    }

    public void getText(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getText(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(OutputStream outputStream) {
        z32 z3210 = new z32();
        this.m1(z3210);
        try {
            if (((z41)z3210).m3()) {
                ((z41)z3210).m1(0L, 0);
            }
            byte[] byArray = new byte[z3210.m24().available()];
            z3210.m24().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (z3210 != null) {
                z3210.m1();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void m1(z41 z4110) {
        if (this.getDocument() == null) {
            throw new IllegalStateException("PdfExtractor hasn't been bound yet. Please provide pdf document to process.");
        }
        if (this.m9 == null) {
            return;
        }
        com.aspose.pdf.internal.p652.z2 z2100 = new com.aspose.pdf.internal.p652.z2(z4110);
        try {
            for (int i = 0; i < this.m9.size(); ++i) {
                String string = this.m9.get_Item(i);
                if (string == null) continue;
                if (i > 0) {
                    z2100.m1(this.m16.m3("\r\n"));
                }
                z2100.m1(this.m16.m3(string));
            }
        }
        finally {
            z2100.m3();
        }
    }

    @Override
    public void bindPdf(String inputFile) {
        this.bindPdf(inputFile, this.m15);
        this.m3();
    }

    @Override
    public void bindPdf(InputStream inputStream) {
        this.m1(z41.m2(inputStream), this.m15);
        this.m3();
    }

    public void extractImage() {
        this.m3();
        this.m5 = new com.aspose.pdf.internal.ms.System.Collections.Generic.z16();
        this.m1(this.m5, this.getDocument(), this.m4, this.m3);
        this.m6 = 0;
    }

    public boolean hasNextImage() {
        this.m2();
        if (this.m5 == null) {
            throw new IllegalStateException("PdfExtractor hasn't been prepared for extracting images. Please call ExtractImage.");
        }
        if (this.m4 > this.m3) {
            return false;
        }
        if (this.m6 >= this.m5.size()) {
            ++this.m4;
            this.m6 = 0;
            while (this.m4 <= this.m3) {
                this.m1(this.m5, this.getDocument(), this.m4, this.m3);
                if (this.m5.size() != 0) break;
                ++this.m4;
            }
        }
        return this.m4 <= this.m3 && this.m6 < this.m5.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextImage(String outputFile) {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.getNextImage(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                    throw new RuntimeException(iOException);
                }
            }
        }
        return bl;
    }

    public boolean getNextImage(String outputFile, ImageType format) {
        boolean bl = false;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            bl = this.getNextImage(fileOutputStream, format);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
        return bl;
    }

    public boolean getNextImage(OutputStream outputStream, ImageType format) {
        if (this.hasNextImage()) {
            try {
                ((XImage)((Object)z5.m1(this.m5.get_Item(this.m6++), XImage.class))).save(outputStream, format, this.m14);
                return true;
            }
            catch (z72 z7210) {
                m1.log(Level.INFO, "Exception occur", z7210);
                return false;
            }
        }
        return false;
    }

    public boolean getNextImage(OutputStream outputStream) {
        if (this.hasNextImage()) {
            try {
                ((XImage)((Object)z5.m1(this.m5.get_Item(this.m6++), XImage.class))).save(outputStream, this.m14);
                return true;
            }
            catch (z72 z7210) {
                m1.log(Level.INFO, "Exception occur", z7210);
                return false;
            }
        }
        return false;
    }

    public List getAttachNames() {
        this.m3();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getDocument().getEmbeddedFiles().size() != 0) {
            for (Object object : this.getDocument().getEmbeddedFiles()) {
                arrayList.add(((FileSpecification)object).getName());
            }
        }
        for (int i = this.m2; i <= this.m3; ++i) {
            if (this.getDocument().getPages().get_Item(i).getAnnotations().size() == 0) continue;
            for (Annotation annotation : this.getDocument().getPages().get_Item(i).getAnnotations()) {
                if (!(annotation instanceof FileAttachmentAnnotation)) continue;
                arrayList.add(((FileAttachmentAnnotation)((Object)z5.m1(annotation, FileAttachmentAnnotation.class))).getFile().getName());
            }
        }
        return arrayList;
    }

    public void extractAttachment() {
        this.m3();
        this.m8 = null;
        this.m7 = 1;
    }

    private void m3() {
        this.m2();
        this.m4 = this.m2;
    }

    public void extractAttachment(String attachmentFileName) {
        this.m8 = attachmentFileName;
    }

    public void getAttachment(String outputPath) {
        this.m1(outputPath, true);
    }

    public boolean hasNextPageText() {
        return this.m9 != null && this.m4 <= this.getEndPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextPageText(String outputFile) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(outputFile);
            this.getNextPageText(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            m1.log(Level.INFO, "Exception occur", fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextPageText(OutputStream outputStream) {
        z32 z3210 = new z32();
        this.m2(z3210);
        try {
            if (((z41)z3210).m3()) {
                ((z41)z3210).m1(0L, 0);
            }
            byte[] byArray = new byte[z3210.m24().available()];
            z3210.m24().read(byArray);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
        finally {
            if (z3210 != null) {
                z3210.m1();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void m2(z41 z4110) {
        if (this.hasNextPageText() && this.m9.size() >= this.m4) {
            com.aspose.pdf.internal.p652.z2 z2100 = new com.aspose.pdf.internal.p652.z2(z4110);
            try {
                String string = (String)((Object)z5.m1(this.m9.get_Item(this.m4 - 1), String.class));
                if (string != null) {
                    z2100.m1(this.m16.m3(string));
                }
            }
            finally {
                z2100.m3();
            }
            ++this.m4;
        }
    }

    public PdfExtractor() {
    }

    public PdfExtractor(IDocument document) {
        super(document);
    }

    public void getText(OutputStream outputStream, boolean filterNotAscii) {
        if (!filterNotAscii) {
            this.getText(outputStream);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.getText(byteArrayOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            outputStreamWriter.write(new String(byteArrayOutputStream.toByteArray(), "UTF-8").replaceAll("[^\\u0000-\\u007F]", z133.m1));
        }
        catch (Exception exception) {
            m1.log(Level.INFO, "Exception occur", exception);
            throw new RuntimeException(exception.getMessage());
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                }
            }
        }
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            m1.log(Level.INFO, "Exception occur", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream[] getAttachment() {
        z32[] z32Array = this.m5();
        if (z32Array != null && z32Array.length > 0) {
            ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[z32Array.length];
            for (int i = 0; i < z32Array.length; ++i) {
                InputStream inputStream = z32Array[i].m24();
                byteArrayOutputStreamArray[i] = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                try {
                    int n;
                    while ((n = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStreamArray[i].write(byArray, 0, n);
                    }
                    continue;
                }
                catch (IOException iOException) {
                    m1.log(Level.INFO, "Exception occur", iOException);
                    continue;
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (z32Array[i] != null) {
                            z32Array[i].m1();
                        }
                    }
                    catch (IOException iOException) {
                        m1.log(Level.INFO, "Exception occur", iOException);
                    }
                }
            }
            return byteArrayOutputStreamArray;
        }
        return null;
    }

    private z32[] m5() {
        return this.m1(null, false);
    }

    public List<FileSpecification> getAttachmentInfo() {
        return this.m1();
    }

    public int getResolution() {
        return this.m14;
    }

    public void setResolution(int value) {
        this.m14 = value;
    }

    public String getPassword() {
        return this.m15;
    }

    public void setPassword(String value) {
        this.m15 = value;
    }

    static {
        m1.setUseParentHandlers(false);
    }
}

