/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd;

import com.aspose.psd.Color;
import com.aspose.psd.DataStreamSupporter;
import com.aspose.psd.FileStreamContainer;
import com.aspose.psd.IColorPalette;
import com.aspose.psd.IImageCreator;
import com.aspose.psd.IImageLoaderDescriptor;
import com.aspose.psd.IObjectWithBounds;
import com.aspose.psd.ImageCreatorsRegistry;
import com.aspose.psd.ImageExportersRegistry;
import com.aspose.psd.ImageLoadersRegistry;
import com.aspose.psd.ImageOptionsBase;
import com.aspose.psd.ImageResizeSettings;
import com.aspose.psd.LoadOptions;
import com.aspose.psd.Point;
import com.aspose.psd.ProgressEventHandler;
import com.aspose.psd.Rectangle;
import com.aspose.psd.Size;
import com.aspose.psd.StreamContainer;
import com.aspose.psd.coreexceptions.FrameworkException;
import com.aspose.psd.coreexceptions.ImageCreateException;
import com.aspose.psd.coreexceptions.ImageException;
import com.aspose.psd.coreexceptions.ImageLoadException;
import com.aspose.psd.coreexceptions.ImageSaveException;
import com.aspose.psd.coreexceptions.OperationInterruptedException;
import com.aspose.psd.internal.Exceptions.ArgumentException;
import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.aZ.D;
import com.aspose.psd.internal.bG.aD;
import com.aspose.psd.internal.bG.aV;
import com.aspose.psd.internal.bG.bC;
import com.aspose.psd.internal.bV.k;
import com.aspose.psd.internal.fY.d;
import com.aspose.psd.internal.gJ.c;
import com.aspose.psd.internal.gL.aQ;
import com.aspose.psd.internal.gL.b;
import com.aspose.psd.internal.gL.bP;
import com.aspose.psd.internal.gL.bQ;
import com.aspose.psd.internal.kN.e;
import com.aspose.psd.internal.kN.g;
import com.aspose.psd.internal.kN.i;
import com.aspose.psd.internal.lg.a;
import com.aspose.psd.multithreading.InterruptMonitor;
import com.aspose.psd.progressmanagement.EventType;
import com.aspose.psd.progressmanagement.ProgressEventHandlerInfo;
import com.aspose.psd.q;
import com.aspose.psd.s;
import com.aspose.psd.sources.StreamSource;
import com.aspose.psd.system.Enum;
import com.aspose.psd.system.Event;
import com.aspose.psd.system.io.FileStream;
import com.aspose.psd.system.io.Stream;
import com.aspose.psd.u;
import com.aspose.psd.v;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Image
extends DataStreamSupporter
implements IObjectWithBounds,
com.aspose.psd.internal.kY.b,
com.aspose.psd.internal.kY.c {
    private static com.aspose.psd.internal.gL.d a;
    public static final Event<com.aspose.psd.internal.gL.d> g;
    private static b b;
    public static final Event<b> h;
    private Image j;
    private IColorPalette k;
    private Object l;
    private boolean m = false;
    private boolean n;
    private InterruptMonitor o;
    private final AtomicReference<i> p = new AtomicReference<Object>(null);
    private ProgressEventHandlerInfo q;
    private final Color r = Color.getWhite();
    protected StreamContainer i;
    private boolean s;

    protected Image() {
    }

    protected Image(IColorPalette colorPalette) {
        this.k = colorPalette;
    }

    public static boolean canLoad(String filePath) {
        return Image.canLoad(filePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLoad(String filePath, LoadOptions loadOptions) {
        Object object = SyncOperation;
        synchronized (object) {
            boolean bl2;
            FileStream fileStream = com.aspose.psd.internal.bV.k.a(filePath, 3, 3, 3);
            try {
                bl2 = Image.a((Stream)fileStream, loadOptions);
            }
            catch (Throwable throwable) {
                fileStream.dispose();
                throw throwable;
            }
            fileStream.dispose();
            return bl2;
        }
    }

    public static boolean canLoad(InputStream stream) {
        return Image.d(Stream.fromJava(stream));
    }

    public static boolean d(Stream stream) {
        return Image.a(stream, null);
    }

    public static boolean canLoad(InputStream stream, LoadOptions loadOptions) {
        return Image.a(Stream.fromJava(stream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean a(Stream stream, LoadOptions loadOptions) {
        boolean bl2;
        bP bP2 = bQ.a().a(stream);
        try {
            bl2 = ImageLoadersRegistry.a(bP2, loadOptions) != null;
        }
        finally {
            bQ.a().a(bP2);
        }
        return bl2;
    }

    public static Image create(ImageOptionsBase imageOptions, int width, int height) {
        if (imageOptions == null) {
            throw new ArgumentNullException("imageOptions");
        }
        if (imageOptions.getSource() == null) {
            throw new ArgumentNullException("imageOptions", "Please specify source for the image creation.");
        }
        if (width <= 0) {
            throw new ArgumentOutOfRangeException("width", "Expected positive width value.");
        }
        if (height <= 0) {
            throw new ArgumentOutOfRangeException("height", "Expected positive height value.");
        }
        return Image.a(imageOptions, width, height);
    }

    public static Image create(Image[] images) {
        return new aQ(images, false);
    }

    public static Image create(Image[] images, boolean disposeImages) {
        return new aQ(images, disposeImages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileFormat(String filePath) {
        FileStream fileStream = com.aspose.psd.internal.bV.k.a(filePath, 3, 1, 1);
        bP bP2 = bQ.a().a(fileStream, false, true);
        Object object = bP2.getSyncRoot();
        synchronized (object) {
            long l2;
            block7: {
                try {
                    l2 = Image.e(bP2);
                    if (bP2.b() > 0) break block7;
                    bP2.dispose();
                }
                catch (Throwable throwable) {
                    if (bP2.b() <= 0) {
                        bP2.dispose();
                    }
                    throw throwable;
                }
            }
            return l2;
        }
    }

    public static long getFileFormat(InputStream stream) {
        return Image.e(Stream.fromJava(stream));
    }

    public static long e(Stream stream) {
        long l2 = 0L;
        IImageLoaderDescriptor iImageLoaderDescriptor = ImageLoadersRegistry.a(stream, null);
        if (iImageLoaderDescriptor != null) {
            l2 = iImageLoaderDescriptor.getSupportedFormat();
        }
        return l2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int width, int height) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle, new Rectangle(new Point(), new Size(bC.a(width), bC.a(height))));
        if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) {
            throw new ArgumentException("The rectangle has no common processing area. Cannot proceed.");
        }
        return rectangle2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int[] pixels, int width, int height) {
        if (pixels == null) {
            throw new ArgumentNullException("pixels");
        }
        Rectangle rectangle2 = Image.getFittingRectangle(rectangle, width, height);
        if (pixels.length < rectangle2.getWidth() * rectangle2.getHeight()) {
            String string = aV.a("The passed rectangle does not correspond to pixels array size. Expected: {0} pixels, passed: {1} pixels.", new Object[]{rectangle2.getWidth() * rectangle2.getHeight(), pixels.length});
            throw new ImageException(string);
        }
        return rectangle2;
    }

    public static Image load(String filePath, LoadOptions loadOptions) {
        return Image.a(FileStreamContainer.openFileStream(filePath, true), loadOptions);
    }

    public static Image load(String filePath) {
        return Image.a(FileStreamContainer.openFileStream(filePath, true), null);
    }

    public static Image load(RandomAccessFile file, LoadOptions loadOptions) {
        return Image.b(new a(file), loadOptions);
    }

    public static Image load(RandomAccessFile file) {
        return Image.b(new a(file), null);
    }

    public static Image load(InputStream stream, LoadOptions loadOptions) {
        return Image.b(Stream.fromJava(stream), loadOptions);
    }

    public static Image b(Stream stream, LoadOptions loadOptions) {
        StreamContainer streamContainer = new StreamContainer(stream, 0L, false);
        return Image.a(streamContainer, loadOptions);
    }

    public static Image load(InputStream stream) {
        return Image.f(Stream.fromJava(stream));
    }

    public static Image f(Stream stream) {
        return Image.b(stream, null);
    }

    public static Image a(Stream stream, long l2, LoadOptions loadOptions) {
        StreamContainer streamContainer = new StreamContainer(stream, l2, false);
        return Image.a(streamContainer, loadOptions);
    }

    public static Image a(Stream stream, long l2) {
        return Image.a(stream, l2, null);
    }

    public static Image g(Stream stream) {
        return Image.a(stream, 0L, null);
    }

    public static int getProportionalWidth(int width, int height, int newHeight) {
        double d2 = (double)newHeight / (double)height;
        return com.aspose.psd.internal.gK.d.e(d2 * (double)width + 0.5);
    }

    public static int getProportionalHeight(int width, int height, int newWidth) {
        double d2 = (double)newWidth / (double)width;
        return com.aspose.psd.internal.gK.d.e(d2 * (double)height + 0.5);
    }

    public abstract D a(ImageOptionsBase var1, int var2, Rectangle var3);

    protected static void doAfterLoad(long[] maximum, InputStream stream) {
        Image.a(maximum, Stream.fromJava(stream));
    }

    protected static void a(long[] lArray, Stream stream) {
        if (a != null) {
            a.a(lArray, stream);
        }
    }

    protected static void doAfterCreate(long[] maximum, long imageSize) {
        if (b != null) {
            b.a(maximum, imageSize);
        }
    }

    private static void a(ProgressEventHandlerInfo progressEventHandlerInfo, EventType eventType) {
        if (progressEventHandlerInfo != null) {
            progressEventHandlerInfo.a(eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static Image a(ImageOptionsBase imageOptionsBase, int n2, int n3) {
        Object object;
        StreamSource streamSource = (StreamSource)((Object)com.aspose.psd.internal.gK.d.a(imageOptionsBase.getSource(), StreamSource.class));
        Stream stream = streamSource != null ? streamSource.getStream() : null;
        Object object2 = object = bP.a(stream, stream == null ? new Object() : stream);
        synchronized (object2) {
            ProgressEventHandlerInfo progressEventHandlerInfo = null;
            if (imageOptionsBase.getProgressEventHandler() != null) {
                progressEventHandlerInfo = ProgressEventHandlerInfo.a(4);
                progressEventHandlerInfo.a(imageOptionsBase.getProgressEventHandler());
            }
            Image.a(progressEventHandlerInfo, EventType.Initialization);
            StreamContainer streamContainer = imageOptionsBase.getSource().getStreamContainer();
            boolean bl2 = true;
            try {
                Object object3;
                block17: {
                    IImageCreator iImageCreator = ImageCreatorsRegistry.createFirstSupportedCreator(imageOptionsBase);
                    if (iImageCreator == null) {
                        throw new ImageLoadException("Cannot create a new image. The image file format may be not supported at the moment.");
                    }
                    Image.a(progressEventHandlerInfo, EventType.PreProcessing);
                    Image image = iImageCreator.create(streamContainer, imageOptionsBase, n2, n3);
                    try {
                        image.q = progressEventHandlerInfo;
                        Image.a(progressEventHandlerInfo, EventType.Processing);
                        image.setDataStreamContainer(streamContainer);
                        image.a(com.aspose.psd.internal.kN.g.a(imageOptionsBase), true);
                        Image.a(progressEventHandlerInfo, EventType.Finalization);
                        if (!imageOptionsBase.getIgnoreAfterCreate_internalized()) {
                            object3 = new long[]{image.f};
                            Image.doAfterCreate((long[])object3, (long)image.getWidth() * (long)image.getHeight());
                            image.f = (long)object3[0];
                        }
                        bl2 = false;
                        object3 = image;
                        if (!bl2) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bl2) {
                                image.close();
                            }
                            throw throwable;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageCreateException("Image creation failed.", runtimeException);
                        }
                        catch (Error error) {
                            throw new ImageCreateException("Image creation failed.", error);
                        }
                    }
                    image.close();
                }
                return object3;
            }
            finally {
                if (bl2) {
                    streamContainer.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Image a(StreamContainer var0, LoadOptions var1_1) {
        block16: {
            var2_2 = true;
            var3_3 = null;
            var5_4 = var0.getSyncRoot();
            // MONITORENTER : var5_4
            var6_5 = null;
            if (var1_1 != null && var1_1.getProgressEventHandler() != null) {
                var6_5 = ProgressEventHandlerInfo.a(4);
                var6_5.a(var1_1.getProgressEventHandler());
            }
            Image.a(var6_5, EventType.Initialization);
            var7_6 = ImageLoadersRegistry.createFirstSupportedLoader(var0.a(), var1_1, false);
            if (var7_6 != null) ** GOTO lbl29
            var8_7 = com.aspose.psd.internal.lA.b.a(var0.a());
            if (var8_7 == null) break block16;
            var9_9 = new StreamContainer(var8_7);
            var10_10 = Image.a(var9_9, var1_1);
            var10_10.i = var0;
            var2_2 = false;
            var11_11 = var10_10;
            // MONITOREXIT : var5_4
            if (var2_2 == false) return var11_11;
            bQ.a(var0);
            if (var3_3 == null) return var11_11;
            var3_3.close();
            return var11_11;
        }
        throw new ImageLoadException("Cannot open an image. The image file format may be not supported at the moment.");
lbl29:
        // 1 sources

        Image.a(var6_5, EventType.PreProcessing);
        var3_3 = com.aspose.psd.internal.kN.g.a(var1_1);
        if (com.aspose.psd.internal.gK.d.b((Object)var7_6, e.class)) {
            ((e)var7_6).a((i)var3_3);
        }
        Image.a(var6_5, EventType.Processing);
        var4_12 = var7_6.load(var0, var1_1);
        if (var4_12.getDataStreamContainer() != var0) {
            var8_8 = var4_12.getDataStreamContainer();
            if (var8_8 != null && !var8_8.getDisposed()) {
                var8_8.dispose();
            }
            var4_12.setDataStreamContainer(var0);
        }
        var4_12.a((i)var3_3, true);
        var4_12.q = var6_5;
        Image.a(var6_5, EventType.Finalization);
        if (var1_1 == null || !var1_1.b()) {
            var8_8 = new long[]{var4_12.f};
            Image.a((long[])var8_8, var0.a());
            var4_12.f = (long)var8_8[0];
        }
        var4_12.m = false;
        var2_2 = false;
        var8_8 = var4_12;
        // MONITOREXIT : var5_4
        if (var2_2 == false) return var8_8;
        bQ.a(var0);
        if (var3_3 == null) return var8_8;
        var3_3.close();
        return var8_8;
        {
            catch (OperationInterruptedException var4_13) {
                throw var4_13;
            }
            catch (ImageException var4_14) {
                throw var4_14;
            }
            catch (Error var4_15) {
                throw new ImageLoadException("Image loading failed.", var4_15);
            }
            catch (RuntimeException var4_16) {
                com.aspose.psd.internal.bN.a.a(var4_16);
                throw new ImageLoadException("Image loading failed.", var4_16);
            }
        }
        catch (Throwable var13_17) {
            if (var2_2 == false) throw var13_17;
            bQ.a(var0);
            if (var3_3 == null) throw var13_17;
            var3_3.close();
            throw var13_17;
        }
    }

    public abstract int getBitsPerPixel();

    @Override
    public Rectangle getBounds() {
        this.verifyNotDisposed();
        return new Rectangle(Point.getEmpty(), this.getSize());
    }

    public Image getContainer() {
        return this.j;
    }

    @Override
    public abstract int getHeight();

    public IColorPalette getPalette() {
        return this.k;
    }

    public void setPalette(IColorPalette value) {
        if (this.k != value) {
            IColorPalette iColorPalette = this.k;
            this.onPaletteChanging(iColorPalette, value);
            this.k = value;
            this.onPaletteChanged(iColorPalette, value);
        }
    }

    public boolean isUsePalette() {
        return false;
    }

    @Override
    public Size getSize() {
        this.verifyNotDisposed();
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public abstract int getWidth();

    public InterruptMonitor getInterruptMonitor() {
        return this.o;
    }

    public void setInterruptMonitor(InterruptMonitor value) {
        this.o = value;
    }

    public final int getBufferSizeHint() {
        return this.v_().b();
    }

    public final void setBufferSizeHint(int value) {
        i i2 = this.v_();
        if (!aD.a(i2, com.aspose.psd.internal.kN.i.a)) {
            i2.c(value);
        }
    }

    public boolean isAutoAdjustPalette() {
        return this.n;
    }

    public void setAutoAdjustPalette(boolean value) {
        this.n = value;
    }

    public boolean hasBackgroundColor() {
        return false;
    }

    public long getFileFormat() {
        return 0L;
    }

    public Color getBackgroundColor() {
        return Color.getWhite();
    }

    public void setBackgroundColor(boolean value) {
    }

    public void setBackgroundColor(Color value) {
        value.CloneTo(this.r);
    }

    public boolean w_() {
        return this.m;
    }

    public void f(boolean bl2) {
        this.m = bl2;
    }

    public i v_() {
        i i2 = this.p.get();
        return i2 != null ? i2 : com.aspose.psd.internal.kN.i.a;
    }

    @Override
    public boolean v() {
        return this.v_().c();
    }

    @Override
    @com.aspose.psd.internal.gK.g
    public final ProgressEventHandler getProgressEventHandler() {
        if (this.q == null) {
            return null;
        }
        return this.q.a();
    }

    @Override
    @com.aspose.psd.internal.gK.g
    public final ProgressEventHandlerInfo getProgressEventHandlerInfo() {
        return this.q;
    }

    public boolean canSave(ImageOptionsBase options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        this.verifyNotDisposed();
        return ImageExportersRegistry.getFirstSupportedDescriptor(this, options) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int newWidth, int newHeight) {
        Object object = this.e;
        synchronized (object) {
            try {
                this.d(true);
                this.resize(newWidth, newHeight, 7);
            }
            finally {
                this.e(true);
            }
        }
    }

    public abstract void resize(int var1, int var2, int var3);

    public abstract void resize(int var1, int var2, ImageResizeSettings var3);

    public ImageOptionsBase getDefaultOptions(Object[] args) {
        return null;
    }

    public ImageOptionsBase getOriginalOptions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int newWidth) {
        Object object = this.e;
        synchronized (object) {
            boolean bl2 = this.doUseRecursion(1);
            try {
                this.d(bl2);
                this.resizeWidthProportionally(newWidth, 1);
            }
            finally {
                this.e(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int newHeight) {
        Object object = this.e;
        synchronized (object) {
            boolean bl2 = this.doUseRecursion(2);
            try {
                this.d(bl2);
                this.resizeHeightProportionally(newHeight, 1);
            }
            finally {
                this.e(bl2);
            }
        }
    }

    public void resizeWidthProportionally(int newWidth, int resizeType) {
        int n2 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), newWidth);
        this.resize(newWidth, n2, resizeType);
    }

    public void resizeHeightProportionally(int newHeight, int resizeType) {
        int n2 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), newHeight);
        this.resize(n2, newHeight, resizeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int newWidth, ImageResizeSettings settings) {
        Object object = this.e;
        synchronized (object) {
            try {
                this.d(true);
                int n2 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), newWidth);
                this.resize(newWidth, n2, settings);
            }
            finally {
                this.e(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int newHeight, ImageResizeSettings settings) {
        Object object = this.e;
        synchronized (object) {
            try {
                this.d(true);
                int n2 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), newHeight);
                this.resize(n2, newHeight, settings);
            }
            finally {
                this.e(true);
            }
        }
    }

    public abstract void rotateFlip(int var1);

    @Override
    public final void save() {
        if (this.j != null) {
            throw new FrameworkException("The result of this method is unpredictable since the current image has Container defined. Use the parent Container's Save() method instead.");
        }
        super.save();
        if (this.i != null) {
            this.i.setPosition(0L);
            Stream stream = this.getDataStreamContainer().a();
            stream.setPosition(0L);
            com.aspose.psd.internal.lA.b.a(stream, this.i.a());
        }
    }

    public void save(String filePath, ImageOptionsBase options) {
        this.save(filePath, options, Rectangle.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filePath, ImageOptionsBase options, Rectangle boundsRectangle) {
        this.verifyNotDisposed();
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        try {
            FileStream fileStream = com.aspose.psd.internal.bV.k.b(filePath);
            try {
                this.a(fileStream, options, boundsRectangle);
                fileStream.flush();
            }
            finally {
                fileStream.dispose();
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (Error error) {
            throw new ImageLoadException("Image saving failed.", error);
        }
        catch (ImageSaveException imageSaveException) {
            throw imageSaveException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image saving failed.", runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile file, ImageOptionsBase options) {
        a a2 = new a(file);
        try {
            this.a(a2, options, Rectangle.getEmpty());
        }
        finally {
            a2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile file, ImageOptionsBase optionsBase, Rectangle boundsRectangle) {
        a a2 = new a(file);
        try {
            this.a(a2, optionsBase, boundsRectangle);
        }
        finally {
            a2.dispose();
        }
    }

    public void save(OutputStream stream, ImageOptionsBase optionsBase) {
        if (stream instanceof d) {
            this.a(((d)stream).a(), optionsBase, Rectangle.getEmpty());
        } else {
            com.aspose.psd.internal.gJ.c.a(new u(this, stream, optionsBase));
        }
    }

    public void save(OutputStream stream, ImageOptionsBase optionsBase, Rectangle boundsRectangle) {
        if (stream instanceof d) {
            this.a(((d)stream).a(), optionsBase, boundsRectangle);
        } else {
            com.aspose.psd.internal.gJ.c.a(new v(this, stream, optionsBase, boundsRectangle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Stream stream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("optionsBase");
        }
        if (!(rectangle.isEmpty() || rectangle.getWidth() > 0 && rectangle.getHeight() > 0)) {
            throw new ArgumentOutOfRangeException("boundsRectangle", "Rectangle should have positive width and height");
        }
        boolean bl2 = false;
        try {
            Object object;
            Object object2 = this.e;
            synchronized (object2) {
                this.isRecursiveCall = bl2 = this.isSameSourceStream_internalized(stream);
                this.MutuallyExclusiveOperationIsNotRunningEvent_internalized.waitOne();
                if (imageOptionsBase.getProgressEventHandler() != null) {
                    this.q = ProgressEventHandlerInfo.a(4);
                    this.q.a(imageOptionsBase.getProgressEventHandler());
                } else if (this.q != null) {
                    this.q.setMaxValue(this.q.getMaxValue() + 4);
                    imageOptionsBase.setProgressEventHandler(this.q.a());
                }
                object = this.SyncNonExclusiveOperation_internalized;
                synchronized (object) {
                    if (this.NonExclusiveRunningOperationsCount_internalized.incrementAndGet() > 0) {
                        this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.reset();
                    }
                }
            }
            Image.a(this.q, EventType.Initialization);
            object2 = ImageExportersRegistry.createFirstSupportedExporter(this, imageOptionsBase);
            if (object2 == null) {
                object = this.getCanNotSaveMessage(imageOptionsBase);
                throw new ArgumentException((String)object, "optionsBase");
            }
            object = this.getImage2Export(imageOptionsBase, rectangle);
            bP bP2 = null;
            try {
                Image.a(this.q, EventType.PreProcessing);
                bP2 = bQ.a().a(stream);
                Object object3 = bP2.getSyncRoot();
                synchronized (object3) {
                    bP2.setPosition(0L);
                    ((DataStreamSupporter)object).tryCacheImage(bP2);
                    Image.a(this.q, EventType.Processing);
                    object2.export((Image)object, bP2.toOutputStream(), imageOptionsBase, rectangle);
                    Image.a(this.q, EventType.Finalization);
                    this.b(bP2);
                }
                bQ.a().a(bP2);
            }
            catch (Throwable throwable) {
                bQ.a().a(bP2);
                throw throwable;
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image export failed.", runtimeException);
        }
        finally {
            Object object = this.SyncNonExclusiveOperation_internalized;
            synchronized (object) {
                if (bl2) {
                    this.isRecursiveCall = false;
                }
                if (this.NonExclusiveRunningOperationsCount_internalized.decrementAndGet() <= 0) {
                    this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.set();
                }
            }
        }
    }

    public abstract void setPalette(IColorPalette var1, boolean var2);

    public Object y() {
        return this.l;
    }

    public void a(Object object) {
        this.l = object;
    }

    public void a(Image image) {
        this.j = image;
    }

    public final void a(EventType eventType) {
        if (this.q != null) {
            this.q.b(this.q.getValue() + 1);
            this.q.a(eventType, this.q.getValue());
        }
    }

    public final void e(int n2) {
        if (this.q != null) {
            this.q.setMaxValue(this.q.getMaxValue() + n2);
        }
    }

    public void a(i i2, boolean bl2) {
        if (this.s) {
            i i3 = this.p.getAndSet(aD.a(i2, com.aspose.psd.internal.kN.i.a) ? null : i2);
            if (i3 != null && !aD.a(i3, i2)) {
                i3.dispose();
            }
        } else {
            this.p.set(aD.a(i2, com.aspose.psd.internal.kN.i.a) ? null : i2);
        }
        this.s = bl2;
    }

    protected boolean doUseRecursion(int operation) {
        return false;
    }

    protected String getCanNotSaveMessage(ImageOptionsBase optionsBase) {
        return "Cannot save to the specified format as it is not supported at the moment";
    }

    public Image z() {
        return this;
    }

    public boolean A() {
        return this.n || this.j != null && this.j.A();
    }

    protected Rectangle getFitRectangle(Rectangle rectangle) {
        return Image.getFittingRectangle(rectangle, this.getWidth(), this.getHeight());
    }

    protected Image getImage2Export(ImageOptionsBase optionsBase, Rectangle boundsRectangle) {
        return this;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle, int[] pixels) {
        return Image.getFittingRectangle(rectangle, pixels, this.getWidth(), this.getHeight());
    }

    protected void onPaletteChanged(IColorPalette oldPalette, IColorPalette newPalette) {
    }

    protected void onPaletteChanging(IColorPalette oldPalette, IColorPalette newPalette) {
    }

    @Override
    protected void releaseManagedResources() {
        this.j = null;
        this.k = null;
        i i2 = this.p.getAndSet(null);
        if (i2 != null && this.s) {
            i2.dispose();
        }
        if (this.i != null) {
            try {
                this.i.a().dispose();
                this.i.dispose();
                Stream stream = this.getDataStreamContainer().a();
                if (stream instanceof bP) {
                    bP bP2 = (bP)stream;
                    String string = ((FileStream)bP2.a()).getName();
                    stream.dispose();
                    this.getDataStreamContainer().dispose();
                    com.aspose.psd.internal.bV.k.d(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.releaseManagedResources();
    }

    static /* synthetic */ com.aspose.psd.internal.gL.d access$002(com.aspose.psd.internal.gL.d x0) {
        a = x0;
        return a;
    }

    static /* synthetic */ b access$202(b x0) {
        b = x0;
        return b;
    }

    static {
        g = new q();
        h = new s();
        new com.aspose.psd.internal.ar.b().run();
    }

    protected static final class ImageOperation
    extends Enum {
        public static final int Resize = 0;
        public static final int ResizeWidthProportionally = 1;
        public static final int ResizeHeightProportionally = 2;
        public static final int Filter = 3;
        public static final int LoadPixels = 4;
        public static final int SavePixels = 5;
        public static final int Crop = 6;
        public static final int BinarizeFixed = 7;
        public static final int BinarizeOtsu = 8;
        public static final int BinarizeBradley = 9;
        public static final int Grayscale = 10;
        public static final int AdjustBrightness = 11;
        public static final int AdjustContrast = 12;
        public static final int AdjustGamma = 13;
        public static final int Rotate = 14;
        public static final int RotateFlip = 15;

        private ImageOperation() {
        }

        static {
            Enum.register(new a());
        }

        private static final class a
        extends Enum.SimpleEnum {
            a() {
                super(ImageOperation.class, Integer.class);
                this.addConstant("Resize", 0L);
                this.addConstant("ResizeWidthProportionally", 1L);
                this.addConstant("ResizeHeightProportionally", 2L);
                this.addConstant("Filter", 3L);
                this.addConstant("LoadPixels", 4L);
                this.addConstant("SavePixels", 5L);
                this.addConstant("Crop", 6L);
                this.addConstant("BinarizeFixed", 7L);
                this.addConstant("BinarizeOtsu", 8L);
                this.addConstant("BinarizeBradley", 9L);
                this.addConstant("Grayscale", 10L);
                this.addConstant("AdjustBrightness", 11L);
                this.addConstant("AdjustContrast", 12L);
                this.addConstant("AdjustGamma", 13L);
                this.addConstant("Rotate", 14L);
                this.addConstant("RotateFlip", 15L);
            }
        }
    }
}

