/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.brushes;

import com.aspose.psd.Image;
import com.aspose.psd.ImageAttributes;
import com.aspose.psd.Rectangle;
import com.aspose.psd.RectangleF;
import com.aspose.psd.brushes.TransformBrush;
import com.aspose.psd.internal.Exceptions.ArgumentException;
import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.cj.G;
import com.aspose.psd.internal.cj.M;
import com.aspose.psd.system.SerializableAttribute;

@SerializableAttribute
public final class TextureBrush
extends TransformBrush {
    private final RectangleF a = new RectangleF();
    private Image b;
    private ImageAttributes c;

    public TextureBrush(Image image) {
        this(image, 0);
    }

    public TextureBrush(Image image, int wrapMode) {
        this(image, wrapMode, new RectangleF(0.0f, 0.0f, 2.1474836E9f, 2.1474836E9f));
    }

    public TextureBrush(Image image, int wrapMode, RectangleF destinationRectangle) {
        this(image, destinationRectangle, wrapMode, new ImageAttributes());
    }

    public TextureBrush(Image image, int wrapMode, Rectangle destinationRectangle) {
        this(image, wrapMode, RectangleF.to_RectangleF(destinationRectangle));
    }

    public TextureBrush(Image image, RectangleF destinationRectangle) {
        this(image, 0, destinationRectangle);
    }

    public TextureBrush(Image image, RectangleF destinationRectangle, ImageAttributes imageAttributes) {
        this(image, destinationRectangle, 0, imageAttributes);
    }

    public TextureBrush(Image image, Rectangle destinationRectangle) {
        this(image, RectangleF.to_RectangleF(destinationRectangle));
    }

    public TextureBrush(Image image, Rectangle destinationRectangle, ImageAttributes imageAttributes) {
        this(image, RectangleF.to_RectangleF(destinationRectangle), imageAttributes);
    }

    private TextureBrush(G information, M context) {
    }

    private TextureBrush(Image image, RectangleF destinationRectangle, int wrapMode, ImageAttributes imageAttributes) {
        if (image == null) {
            throw new ArgumentNullException("image");
        }
        if (imageAttributes == null) {
            throw new ArgumentNullException("imageAttributes");
        }
        RectangleF rectangleF = RectangleF.intersect(RectangleF.to_RectangleF(image.getBounds()), destinationRectangle);
        if (rectangleF.getWidth() == 0.0f || rectangleF.getHeight() == 0.0f) {
            throw new ArgumentException("The destination rectangle does not intersect the image rectangle");
        }
        this.b = image;
        rectangleF.CloneTo(this.a);
        this.c = imageAttributes;
        this.setWrapMode(wrapMode);
    }

    public Image getImage() {
        return this.b;
    }

    public ImageAttributes getImageAttributes() {
        return this.c;
    }

    public RectangleF getImageRectangle() {
        return this.a;
    }

    @Override
    protected void releaseManagedResources() {
        Image image = this.b;
        if (image != null) {
            image.dispose();
        }
        super.releaseManagedResources();
    }
}

