/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.fileformats.psd.layers.adjustmentlayers;

import com.aspose.psd.Point;
import com.aspose.psd.Rectangle;
import com.aspose.psd.coreexceptions.imageformats.PsdImageArgumentException;
import com.aspose.psd.fileformats.psd.layers.LayerResource;
import com.aspose.psd.fileformats.psd.layers.adjustmentlayers.AdjustmentLayer;
import com.aspose.psd.fileformats.psd.layers.layerresources.ExpaResource;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.bG.I;
import com.aspose.psd.internal.bG.bC;
import com.aspose.psd.internal.gK.d;
import com.aspose.psd.internal.iJ.i;
import com.aspose.psd.internal.iS.g;
import com.aspose.psd.internal.js.k;

public class ExposureLayer
extends AdjustmentLayer {
    private ExpaResource a;
    private double b;

    ExposureLayer(k header, LayerResource[] resources) {
        super(header, null, resources);
        this.setResources(resources);
        this.a(resources);
    }

    public static ExposureLayer a(k k2, LayerResource[] layerResourceArray) {
        return new ExposureLayer(k2, layerResourceArray);
    }

    public final float getExposure() {
        return this.a.getExposure();
    }

    public final void setExposure(float value) {
        if (value < -20.0f || value > 20.0f) {
            throw new ArgumentOutOfRangeException("Photoshop is supported Exposure only between -20.0 and +20.0");
        }
        this.a.setExposure(value);
    }

    public final float getOffset() {
        return this.a.getOffset();
    }

    public final void setOffset(float value) {
        if (value < -0.5f || value > 0.5f) {
            throw new ArgumentOutOfRangeException("Photoshop is supported Offset only between -0.5 and +0.5");
        }
        this.a.setOffset(value);
    }

    public final float getGammaCorrection() {
        return this.a.getGammaCorrection();
    }

    public final void setGammaCorrection(float value) {
        if (value < 0.01f || value > 9.99f) {
            throw new ArgumentOutOfRangeException("Photoshop is supported GammaCorrection only between +9.99 and +0.01");
        }
        this.a.setGammaCorrection(value);
    }

    @Override
    public i<int[], Rectangle> a(Rectangle rectangle, int[] nArray, Point point, Point point2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[]{byArray[0]};
            byte[] byArray3 = new byte[]{byArray[1]};
            byte[] byArray4 = new byte[]{byArray[2]};
            byte[] byArray5 = new byte[]{byArray[3]};
            com.aspose.psd.internal.iS.g.a(nArray[i2], byArray2, byArray3, byArray4, byArray5);
            byArray[0] = byArray2[0];
            byArray[1] = byArray3[0];
            byArray[2] = byArray4[0];
            byArray[3] = byArray5[0];
            double d2 = this.r();
            this.b = Math.E / bC.f(d2, this.getExposure() - 1.0f);
            for (int i3 = 0; i3 < 3; ++i3) {
                byte by2 = this.c(byArray[i3]);
                byte by3 = this.b(by2);
                byArray[i3] = this.a(by3);
            }
            nArray[i2] = com.aspose.psd.internal.iS.g.a(byArray[0], byArray[1], byArray[2], byArray[3]);
        }
        return new i<int[], Rectangle>(nArray, rectangle);
    }

    private byte a(byte by2) {
        int n2 = com.aspose.psd.internal.gK.d.e(255.0 * bC.f((double)(by2 & 0xFF) / 255.0, 1.0 / (double)this.getGammaCorrection()) + 0.5);
        return (byte)bC.d(255, n2);
    }

    private double r() {
        double d2 = this.getExposure() >= 0.0f ? 1.2 : 1.162;
        return d2;
    }

    private byte b(byte by2) {
        float f2 = bC.a(this.getOffset());
        if (this.getOffset() < 0.0f) {
            f2 = 0.5f - f2;
        }
        if ((double)f2 < 1.0E-5) {
            return by2;
        }
        double d2 = bC.s(f2) + 0.029;
        double d3 = d2 * 255.0;
        if (this.getOffset() < 0.0f) {
            d3 = d3 + (double)(by2 & 0xFF) - 255.0;
        }
        double d4 = 0.00166388 - 6.29144E-4 * bC.q(f2);
        double d5 = d3 + (double)((by2 & 0xFF) * (by2 & 0xFF)) * d4;
        return I.d(bC.c(0.0, bC.d(255.0, d5)));
    }

    private byte c(byte by2) {
        if (this.b == 0.0) {
            return by2;
        }
        double d2 = bC.c(0.0, bC.d(255.0, (double)(by2 & 0xFF) + (double)(by2 & 0xFF) / this.b * (double)this.getExposure()));
        return I.d(d2);
    }

    private void a(LayerResource[] layerResourceArray) {
        for (LayerResource layerResource : layerResourceArray) {
            if (!com.aspose.psd.internal.gK.d.b((Object)layerResource, ExpaResource.class)) continue;
            this.a = (ExpaResource)layerResource;
        }
        if (this.a == null) {
            this.dispose();
            throw new PsdImageArgumentException("Can not create Exposure Adjustment Layer without ExpaResource");
        }
    }
}

