/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.cmc;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERBitString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.math.BigInteger;

public class CertificationRequest
extends ASN1Object {
    private static final ASN1Integer a = new ASN1Integer(0L);
    private final a b;
    private final AlgorithmIdentifier c;
    private final DERBitString d;

    public CertificationRequest(X500Name x500Name, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString, ASN1Set aSN1Set, AlgorithmIdentifier algorithmIdentifier2, DERBitString dERBitString2) {
        this.b = new a(x500Name, algorithmIdentifier, dERBitString, aSN1Set, null);
        this.c = algorithmIdentifier2;
        this.d = dERBitString2;
    }

    private CertificationRequest(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.b = new a(ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(0)), null);
        this.c = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.d = DERBitString.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public static CertificationRequest getInstance(Object object) {
        if (object instanceof CertificationRequest) {
            return (CertificationRequest)object;
        }
        if (object != null) {
            return new CertificationRequest(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public BigInteger getVersion() {
        return this.b.a().getValue();
    }

    public X500Name getSubject() {
        return this.b.b();
    }

    public ASN1Set getAttributes() {
        return this.b.d();
    }

    public AlgorithmIdentifier getSubjectPublicKeyAlgorithm() {
        return AlgorithmIdentifier.getInstance(this.b.c().getObjectAt(0));
    }

    public DERBitString getSubjectPublicKey() {
        return DERBitString.getInstance(this.b.c().getObjectAt(1));
    }

    public ASN1Primitive parsePublicKey() throws IOException {
        return ASN1Primitive.fromByteArray(this.getSubjectPublicKey().getOctets());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.c;
    }

    public DERBitString getSignature() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }

    private class a
    extends ASN1Object {
        private final ASN1Integer b;
        private final X500Name c;
        private final ASN1Sequence d;
        private final ASN1Set e;

        private a(ASN1Sequence aSN1Sequence) {
            if (aSN1Sequence.size() != 4) {
                throw new IllegalArgumentException("incorrect sequence size for CertificationRequestInfo");
            }
            this.b = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
            this.c = X500Name.getInstance(aSN1Sequence.getObjectAt(1));
            this.d = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(2));
            if (this.d.size() != 2) {
                throw new IllegalArgumentException("incorrect subjectPublicKeyInfo size for CertificationRequestInfo");
            }
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(3);
            if (aSN1TaggedObject.getTagNo() != 0) {
                throw new IllegalArgumentException("incorrect tag number on attributes for CertificationRequestInfo");
            }
            this.e = ASN1Set.getInstance(aSN1TaggedObject, false);
        }

        private a(X500Name x500Name, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString, ASN1Set aSN1Set) {
            this.b = a;
            this.c = x500Name;
            this.d = new DERSequence(new ASN1Encodable[]{algorithmIdentifier, dERBitString});
            this.e = aSN1Set;
        }

        private ASN1Integer a() {
            return this.b;
        }

        private X500Name b() {
            return this.c;
        }

        private ASN1Sequence c() {
            return this.d;
        }

        private ASN1Set d() {
            return this.e;
        }

        @Override
        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(this.b);
            aSN1EncodableVector.add(this.c);
            aSN1EncodableVector.add(this.d);
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.e));
            return new DERSequence(aSN1EncodableVector);
        }

        /* synthetic */ a(X500Name x500Name, AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString, ASN1Set aSN1Set, com.aspose.psd.internal.bouncycastle.asn1.cmc.a a2) {
            this(x500Name, algorithmIdentifier, dERBitString, aSN1Set);
        }

        /* synthetic */ a(ASN1Sequence aSN1Sequence, com.aspose.psd.internal.bouncycastle.asn1.cmc.a a2) {
            this(aSN1Sequence);
        }
    }
}

